unit Timser;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, RChart, StdCtrls, printers;

type
  TForm1 = class(TForm)
    RChart1: TRChart;
    ButPrintit: TButton;
    ButDone: TButton;
    CBMX: TCheckBox;
    CBMY: TCheckBox;
    PrintDialog1: TPrintDialog;
    procedure FormActivate(Sender: TObject);
    procedure ButPrintitClick(Sender: TObject);
    procedure ButDoneClick(Sender: TObject);
    procedure CBMXClick(Sender: TObject);
    procedure CBMYClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

(*******************************************************************)
procedure TForm1.FormActivate(Sender: TObject);
(*******************************************************************)

const
  Numval = 800;

var
  i : integer;

begin
RChart1.RangeHiX := NumVal;
RChart1.RangeLoX := 0;
RChart1.RangeHiY := 150;
RChart1.RangeLoY := -30;
RCHart1.MoveTo (0,0);
for i:=1 to NumVal do
  RChart1.DrawTo (i,i/10+i/30*sin(i*0.04)+20*(random+random));
RChart1.DataColor := clRed;
RChart1.MoveTo (0,40);
for i:=1 to NumVal do
  RChart1.DrawTo (i,40+i/20*sin(i*0.05));
RChart1.MoveTo (0,0); { dummy token for FindNext-example }
end;


(******************************************************************)
procedure TForm1.ButPrintitClick(Sender: TObject);
(*******************************************************************)

begin
if PrintDialog1.Execute then
  RChart1.Printit (1.0, true);
end;

(*******************************************************************)
procedure TForm1.ButDoneClick(Sender: TObject);
(*******************************************************************)

begin
close;
end;

(*******************************************************************)
procedure TForm1.CBMXClick(Sender: TObject);
(*******************************************************************)

begin
RChart1.MXTrackOn := CBMX.Checked;
end;

(*******************************************************************)
procedure TForm1.CBMYClick(Sender: TObject);
(*******************************************************************)

begin
RChart1.MYTrackOn := CBMY.Checked;
end;



end.
