/////////////////////////////////////////////////////////////////////////////
/** This routine Quicksorts two arrays. The first array (called KWList here)
is actively sorted while the second (called KWPtr here) is passive: it moves
with its corresponding element in the active array. An example is sorting of
full names but based on Last names only, so the input file may look like

Dover, Ben
Freely, I.P.
Tuhuggenkiss, Amanda
Liball, Bo
Graham, Anna
Dozent, Betty
...

Illustrates usage of linked lists(vectors), DOS file IO, and the
StringTokenizer.

input is a text file of two columns of strings (arbitrary length & number)
The two columns must be blank delimited.
Output is the sorted version of input.
All data is converted to uppercase before sorting and output.

This routine was translated from the Numerical Recipes book by Press et al.
by a java ultra-novice:
Y.T. Tim Hatamian, Mathematicus Laboratories
                   73243.647@compuserve.com
                   Ourworld.Compuserve.com/Homepages/Mathematicus

Please let me know of any problems.*/
/////////////////////////////////////////////////////////////////////////////
        

//package Scriptis.Util;       //Scriptis Utilities
import java.io.*;
import java.util.*;

public class Sort2{
    private static Vector KWList = new Vector(50,50);     //Text of 1st arrray
    private static Vector KWPtr = new Vector(50,50);      // 2nd array
    private static int KWNumber;                          //# of elements in each array

    public static void main(String args[]){
      String outfile,infile;
        
      try {infile = args[0];}
      catch (IndexOutOfBoundsException e) {
             System.out.println("Usage: java Sort2 <inputfile>   (overwrites input)");
             System.out.println(" or :  java Sort2 <inputfile> <outputfile> ");
             System.exit(0);
      }

      infile=args[0];  
      try { outfile = args[1]; }
      catch (IndexOutOfBoundsException e) { outfile = infile; }


      GetKWs(infile);                            //load input into vectors
      QuickSort2();                                 //use quicksort algorithm
      WriteKWs(outfile);                        // Write sorted list

    }   //end main
        

//=========================================================================
/** Quicksort from Numerical recipes; translated from Fortran.
TEMPA1 and TEMPB1 have been added to cope with the Java's cumbersome notation.
Note: this routine requires 1 based arrays(vectors)
*/
    static void QuickSort2(){
        int m=7,nstack=100;
        String a,b,tempa,tempb,tempa1,tempb1;    //scrtach pads for 1st&2nd array elemnts
        int i,j,k,ir=KWNumber,jstack=0,l=1;
        int istack[]=new int[nstack];
        boolean goto2=false,loop3=true;                   //need these for branching
      
        while (true){
          if(ir-l < m){

            for(j=l+1;j<=ir;j++){           //loop-12
              a=KWList.elementAt(j).toString();
              b=KWPtr.elementAt(j).toString();
              for(i=j-1;i>=1;i--){           //loop-11
                tempa1=KWList.elementAt(i).toString();
                tempb1=KWPtr.elementAt(i).toString();
                if(tempa1.compareTo(a)<=0){goto2=true; break ;}
                KWList.setElementAt(tempa1,i+1);
                KWPtr.setElementAt(tempb1,i+1);
              }  //end loop-11
            
              if(!goto2)i=0;
              goto2=false;
//label 2:
              KWList.setElementAt(a,i+1);
              KWPtr.setElementAt(b,i+1);

            }  //end loop-12

            if(jstack==0)return;
            ir=istack[jstack];
            l=istack[jstack-1];
            jstack=jstack-2;
          }else{                                //if(ir-l<m)
            k=(l+ir)/2;
            tempa=KWList.elementAt(k).toString();
            tempa1=KWList.elementAt(l+1).toString();
            KWList.setElementAt(tempa1,k);
            KWList.setElementAt(tempa,l+1);
            tempb=KWPtr.elementAt(k).toString();
            tempb1=KWPtr.elementAt(l+1).toString();
            KWPtr.setElementAt(tempb1,k);
            KWPtr.setElementAt(tempb,l+1);


            tempa=KWList.elementAt(l+1).toString();
            tempa1=KWList.elementAt(ir).toString();
            if(tempa.compareTo(tempa1)>0){

              KWList.setElementAt(tempa1,l+1);
              KWList.setElementAt(tempa,ir);
              tempb=KWPtr.elementAt(l+1).toString();
              tempb1=KWPtr.elementAt(ir).toString();
              KWPtr.setElementAt(tempb1,l+1);
              KWPtr.setElementAt(tempb,ir);
            } //endif(tempa.compareTo(tempa1)>0)


            tempa=KWList.elementAt(l).toString();
            tempa1=KWList.elementAt(ir).toString();
            if(tempa.compareTo(tempa1)>0){

              KWList.setElementAt(tempa1,l);
              KWList.setElementAt(tempa,ir);
              tempb=KWPtr.elementAt(l).toString();
              tempb1=KWPtr.elementAt(ir).toString();
              KWPtr.setElementAt(tempb1,l);
              KWPtr.setElementAt(tempb,ir);
            } //endif(tempa.compareTo(tempa1)>0);


            tempa=KWList.elementAt(l+1).toString();
            tempa1=KWList.elementAt(l).toString();
            if(tempa.compareTo(tempa1)>0){

              KWList.setElementAt(tempa1,l+1);
              KWList.setElementAt(tempa,l);
              tempb=KWPtr.elementAt(l+1).toString();
              tempb1=KWPtr.elementAt(l).toString();
              KWPtr.setElementAt(tempb1,l+1);
              KWPtr.setElementAt(tempb,l);
            } //endif(tempa.compareTo(tempa1)>0)


            i=l+1;
            j=ir;
            a=KWList.elementAt(l).toString();
            b=KWPtr.elementAt(l).toString();


            do{                         //loop-3
             loop3=true;
             do{
               i=i+1;
               tempa1=KWList.elementAt(i).toString();
             }while(tempa1.compareTo(a)<0);
     
             do{
               j=j-1;
               tempa1=KWList.elementAt(j).toString();
             }while(tempa1.compareTo(a)>0);
          
             if(j>=i){                
                tempa=KWList.elementAt(i).toString();
                tempa1=KWList.elementAt(j).toString();
                KWList.setElementAt(tempa1,i);
                KWList.setElementAt(tempa,j);
                tempb=KWPtr.elementAt(i).toString();
                tempb1=KWPtr.elementAt(j).toString();
                KWPtr.setElementAt(tempb1,i);
                KWPtr.setElementAt(tempb,j);
                loop3=true;
             }else{
                loop3=false;             //j<i
             }                           //endif(j>=i)

            } while(loop3);              //enddo loop3

//label 5
            tempa1=KWList.elementAt(j).toString();
            KWList.setElementAt(tempa1,l);
            KWList.setElementAt(a,j);
            tempb1=KWPtr.elementAt(j).toString();
            KWPtr.setElementAt(tempb1,l);
            KWPtr.setElementAt(b,j);

            jstack=jstack+2;
            if(jstack > nstack){
              System.out.println("SORT2: NSTACK too small");
              System.exit(1);
            }

            if(ir-i+1 >= j-l){
              istack[jstack]=ir;
              istack[jstack-1]=i;
              ir=j-1;
            }else{
              istack[jstack]=j-1;
              istack[jstack-1]=l;
              l=i;
            }//endif(ir-i+1 >= j-l)

          } // endif(ir-l<m)
        } //end while(true)

    } //end Sort2 routine

  
//========================================================================
//Get the arrays and the # of entries in there.

  static void GetKWs (String KWFile){
    String line;
    DataInputStream File = null;
    try{
      File = new DataInputStream(new FileInputStream(KWFile));
    }catch (IOException e){
      System.out.println("SORT: Error Opening the input List "
      +KWFile+" during read.");
      System.exit(1);
    }//end Open file try

//these 2 lines make the vectors 1 based as needed in Sort2
    KWList.addElement("something is fishy");             
    KWPtr.addElement("something is really fishy");       

    try{
      while(File.available()>0){
        line=File.readLine().toUpperCase();
        StringTokenizer lintok= new StringTokenizer(line);
        if(lintok.countTokens() < 2 )continue;   //skips blank lines and single columns
        line=(lintok.nextToken()).trim();
        KWList.addElement(line);                //separate 1st column...
        line=(lintok.nextToken()).trim();
        KWPtr.addElement(line);                 //...from second
        lintok=null;
      } //End while
      File.close();
    }catch (IOException e){
      System.out.println("SORT: Error Reading the input List "+KWFile);
      System.exit(1);
    }//end readout try
    KWNumber=KWList.size()-1;        //vectors are simulated to be 1 based
  }

//========================================================================

  static void WriteKWs (String KWFile){
    String line;
    PrintStream File = null;

    try{
      File = new PrintStream(new FileOutputStream(KWFile));
    }catch (IOException e){
      System.out.println("SORT: Error Opening the output file "
      +KWFile+" during write.");
      System.exit(1);
    }//end Open file try
    File.flush();

      for(int i=1; i<=KWNumber; i++){
        line=KWList.elementAt(i).toString()+"  "+KWPtr.elementAt(i).toString();
        File.println(line+'\r');
      } //end for loop
      File.close();
  }  //end WriteKWs

//========================================================================
}  //end class Sort
