unit Files;

interface

uses 
     SysUtils,
     WinTypes, 
     WinProcs, 
     Classes, 
     Graphics, 
     Forms, 
     Controls, 
     Buttons,
     StdCtrls,
     ExtCtrls,
     Nwtools,
     NWServer,
     Nwlib;

type
  TwinFile = class(TForm)
    CancelBtn: TBitBtn;
    Bevel1: TBevel;
    Panel1: TPanel;
    SalvageList: TListBox;
    Header1: THeader;
    NWServer1: TNWServer;
    NWTools1: TNWTools;
    NWLib1: TNWLib;
    Bevel2: TBevel;
    Panel2: TPanel;
    fileList: TListBox;
    Header2: THeader;
    bSalvage: TButton;
    Bevel3: TBevel;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    Label6: TLabel;
    fileOwner: TEdit;
    fileCreated: TEdit;
    fileModified: TEdit;
    fileSize: TEdit;
    deleteDate: TEdit;
    deleteBy: TEdit;
    fileUpdated: TEdit;
    archiveBy: TEdit;
    Label7: TLabel;
    Label8: TLabel;
    bInfo: TButton;
    bFileInfo: TButton;
    dirPath: TEdit;
    Label9: TLabel;
    bRefresh: TButton;
    procedure FormShow(Sender: TObject);
    procedure bSalvageClick(Sender: TObject);
    procedure bInfoClick(Sender: TObject);
    procedure bFileInfoClick(Sender: TObject);
    procedure bRefreshClick(Sender: TObject);
    procedure SalvageListEnter(Sender: TObject);
    procedure fileListEnter(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
    filePath : string[99] ;
  end;

var
  winFile: TwinFile;

implementation

{$R *.DFM}

procedure TwinFile.FormShow(Sender: TObject);
  var
    ncursor : TCursor ;
  begin
    ncursor := screen.cursor ;
    screen.cursor := crHourglass ;
    if (length(alltrim(filePath)) < 2) then
      filePath := 'z:.\' ;
    dirPath.text  := filePath ;
    try
      { Add to Salvage List }
      salvageList.items.clear ;
      salvageList.items.addStrings(
           getDeletedFileList(getPrimaryServerID,filePath)) ;
      if (salvageList.items.count > 0) then
        begin
          salvageList.enabled   := true ;
          salvageList.itemIndex := 0    ;
          bInfo.enabled         := true ;
          bInfoClick(sender) ;
          bInfo.setfocus ;
        end
      else
        begin
          bInfo.enabled := false ;
          salvageList.enabled := false ;
          salvageList.items.add('<No Deleted Files in ' + filePath  + '>');
        end;
      { Add files to FileList }
      fileList.items.clear ;
      fileList.items.addStrings(getVolFileList(filePath + '*.*')) ;
      if (fileList.items.count > 0) then
        begin
          fileList.itemIndex := 0 ;
          fileList.enabled   := true ;
          bFileInfo.enabled  := true ;
          if (salvageList.items.count < 1) then
            begin
              bFileInfoClick(sender) ;
              bFileInfo.setfocus ;
            end;
         end
      else
        begin
          bFileInfo.enabled := false ;
          bFileInfo.enabled := false ;
          fileList.items.add('<No Files in ' + filePath  + '>');
        end;
     finally
       screen.cursor := ncursor ;
     end;
  end;

procedure TwinFile.bSalvageClick(Sender: TObject);
  begin
    if fileExists(filePath + 'erase.me') and
       yesNoBox(filePath + 'ERASE.ME;OverWrite Existing File?') then
      deleteFile(filePath + 'erase.me') ;
    if (not fileExists(filePath + 'erase.me')) then
      begin
        if Salvage(getPrimaryServerID,
                    filePath + salvageList.items[salvageList.itemIndex],
                    filePath + 'erase.me') then
          okbox('File Salvaged to ' + filePath + 'ERASE.ME')
        else
          alertBox('Salvage Failed!') ;
      end;
  end;

procedure TwinFile.bInfoClick(Sender: TObject);
  var
    deletedFileInfo : TNWDeletedFileInfo ;
  begin
    fileOwner.text    := 'Unknown' ;
    fileModified.text := 'N/A'     ;
    fileSize.text     := 'Unknown' ;
    fileCreated.text  := 'Unknown' ;
    fileUpdated.text  := 'Unknown' ;
    deleteDate.text   := 'Unknown' ;
    deleteBy.text     := 'Unknown' ;
    archiveBy.text    := 'Unknown' ;
    bSalvage.enabled  := true      ;
    if getDeletedFileInfo(filePath +
                          salvageList.items[salvageList.itemIndex],
                          deletedFileInfo) then
      begin
        fileOwner.text   := deletedFileInfo.ownerID                    ;
        fileSize.text    := intToStr(deletedFileInfo.fileSize)         ;
        fileCreated.text := dateToStr(deletedFileInfo.creationDate)    ;
        fileUpdated.text := dateToStr(deletedFileInfo.updateDateTime)  ;
        deleteDate.text  := dateToStr(deletedFileInfo.deletedDateTime) ;
        deleteBy.text    := deletedFileInfo.deletedBy ;
        archiveBy.text   := deletedFileInfo.lastArchivedBy ;
      end;
  end;

procedure TwinFile.bFileInfoClick(Sender: TObject);
  var
    fileInfo : TNWFileInfo ;
  begin
    fileOwner.text    := 'Unknown' ;
    fileModified.text := 'Unknown' ;
    fileSize.text     := 'Unknown' ;
    fileCreated.text  := 'Unknown' ;
    fileUpdated.text  := 'Unknown' ;
    deleteDate.text   := 'N/A'     ;
    deleteBy.text     := 'N/A'     ;
    archiveBy.text    := 'Unknown' ;
    bSalvage.enabled  := false     ;
    if getFileInfo(filePath + fileList.items[fileList.itemIndex],
                   fileInfo) then
      begin
        fileOwner.text    := fileInfo.ownerID ;
        fileUpdated.text  := dateToStr(fileInfo.updatedDateTime);
        fileModified.text := dateToStr(fileInfo.lastModifyDate) ;
        fileSize.text     := intToStr(fileInfo.fileSize)        ;
        fileCreated.text  := dateToStr(fileInfo.creationDate)   ;
        archiveBy.text    := fileInfo.lastArchivedBy            ;
      end;
  end;

procedure TwinFile.bRefreshClick(Sender: TObject);
  begin
    filePath := setPath(dirPath.text) ;
    if dirPath.modified then
      formShow(self.owner) ;
  end;

procedure TwinFile.SalvageListEnter(Sender: TObject);
  begin
    bSalvage.enabled := (salvageList.items.count > 0) ;
  end;

procedure TwinFile.fileListEnter(Sender: TObject);
  begin
    bSalvage.enabled := false ;
  end;

end.
