;*****************************************************************************
;
;   DXT_ME.CMD - MicroEMACS MACRO FUNCTIONS FOR
;
;       DFTN (TM) DBASE FUNCTION TREE NAVIGATOR
;
;   Copyright (C) Juergen Mueller (J.M.) 1992-1996
;   All rights reserved.
;
;   You are expressly prohibited from selling this software in any form,
;   distributing it with another product, or removing this notice.
;
;   Limited permission is given to registered DXT users to modify this
;   file for their own personal use only. This file may not be used for any
;   purpose other than in conjunction with the DXT software package.
;
;   THIS SOFTWARE IS PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND,
;   EITHER EXPRESSED OR IMPLIED, INCLUDING, WITHOUT LIMITATION, THE
;   IMPLIED WARRANTIES OF MERCHANTIBILITY OR FITNESS FOR A PARTICULAR
;   PURPOSE. THE ENTIRE RISK AS TO THE QUALITY AND PERFORMANCE OF THE
;   PROGRAM AND DOCUMENTATION IS WITH YOU.
;
;   written by: Juergen Mueller, Aldingerstrasse 22, D-70806 Kornwestheim,
;               GERMANY
;
;   FILE       : DXT_ME.CMD
;   REVISION   : 27-Apr-1996
;                18:30:52
;
;*****************************************************************************

; NOTE: for OS/2 you should exchange "dftn" with "dftn4os2"
; NOTE: for Windows NT / Windows 95 you should exchange "dftn" with "dftn32"

;*****************************************************************************
;**** write initial message ****
;*****************************************************************************
write-message "Loading DXT macro package"

;*****************************************************************************
;**** macro package initialization section ****
;*****************************************************************************
set %dxt_item ""                ; set internal variables
set %dxt_file ""
set %dxt_line ""
set %dxtn_cmd ""
set %char_set "_abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789"

set %dft_base &env "DFTNBASE"   ; get environment variables, if set

;*****************************************************************************
;**** definition of user macros ****
;*****************************************************************************

;**** find function ****
store-procedure dft
        execute-procedure _extract_item         ; get tagged item
        execute-procedure _dxt_dft
!endm

;**** find function ****
store-procedure dftmark
        execute-procedure _extract_marked_item  ; get marked item
        execute-procedure _dxt_dft
!endm

;**** find function ****
store-procedure dftfind
        set %dxt_item "DFT function name: "
        set %dxt_item @%dxt_item                ; get user input
        execute-procedure _dxt_dft
!endm

;**** set DFT database name ****
store-procedure dftbase
        set %dft_base "DFT database name: "
        set %dft_base @%dft_base                ; get user input
!endm

;**** DFT file list
store-procedure dftfile
        write-message "Extracting DFT filelist"

        !if &not &seq &len %dft_base 0
          set %tmp &cat &cat "-f" %dft_base " "         ; database access path
        !else
          set %tmp ""
        !endif

        set %dxtn_cmd &cat "dftn -F " %tmp
        pipe-command %dxtn_cmd          ; perform database access, shell command
!endm

;*****************************************************************************
;**** internal macro execution functions ****
;*****************************************************************************

;*****************************************************************************
;* DFT front-end *
;*****************************************************************************
store-procedure _dxt_dft
        !if &seq &len %dxt_item 0
          write-message "No function selected"
          !return
        !endif

        write-message &cat &cat "Searching for function: '" %dxt_item "'"

        !if &not &seq &len %dft_base 0
          set %tmp &cat &cat "-f" %dft_base " "         ; database access path
        !else
          set %tmp ""
        !endif

        set %dxtn_cmd &cat &cat "dftn -b " %tmp %dxt_item
        execute-procedure _dxt_search                   ; start search
!endm

;*****************************************************************************
;* the database retrieval function *
;*****************************************************************************
store-procedure _dxt_search
        set %dxt_file ""                ; clear variables
        set %dxt_line ""

!force  pipe-command %dxtn_cmd          ; perform database access, shell command
        !if &seq $status FALSE
          !return
        !endif

!force  select-buffer command           ; get result buffer from pipe-command
        !if &seq $status FALSE
          !return
        !endif

!force  beginning-of-file               ; go to file begin
        !if &seq $status FALSE
          !return
        !endif

        set-mark                        ; extract target file name

!force  search-forward " "              ; search for first blank after file name
        !if &seq $status FALSE
          !return
        !endif

        backward-character
        copy-region
        set %dxt_file $kill             ; store target file name
        forward-character
        set-mark                        ; extract target file line
        end-of-line
        copy-region
        set %dxt_line $kill             ; store target file line

!force  delete-window                   ; delete command window
!force  delete-buffer command           ; delete command buffer
!force  next-buffer                     ; switch to next buffer just to hide command buf

        !if &not &exist %dxt_file       ; test if file exists
          write-message &cat &cat "Target file ~"" %dxt_file "~" not found"
          !return
        !endif

!force  find-file %dxt_file             ; open target file

        !if &seq $status TRUE
!force    goto-line %dxt_line           ; jump to target line

          !if &seq $status FALSE
            clear-message-line
            !return
          !endif

          delete-other-windows          ; just for safety
          redraw-display                ; center target line
          clear-message-line
        !endif
!endm

;*****************************************************************************
;* read search item from current buffer *
;*****************************************************************************
store-procedure _extract_item
        set %dxt_item ""                ; clear variable

        !if &seq &sindex %char_set &chr $curchar 0
          !return                       ; not on a valid character
        !endif

!force  end-of-word

        !while TRUE
!force  previous-word
!force  backward-character
        !if &seq &sindex %char_set &chr $curchar 0
!force    forward-character
          !break
        !endif
        !endwhile

        set-mark                        ; mark first item character

        !while TRUE
!force  end-of-word                     ; goto end of item
        !if &seq &sindex %char_set &chr $curchar 0
          !break
        !endif
        !endwhile

        copy-region
        set %dxt_item $kill             ; store item name
!endm

;*****************************************************************************
;* read marked search item *
;*****************************************************************************
store-procedure _extract_marked_item
        set %dxt_item ""                                ; clear variable
!force  copy-region
        set %dxt_item $kill                             ; store item name

        !if &not &seq &len %dxt_item 0
          set %dxt_item &cat &cat "~"" %dxt_item "~""   ; quote
        !endif
!endm

;*****************************************************************************
;* bind macros to WINDOWS menu, only if MicroEMACS for WINDOWS is present *
;*****************************************************************************
!if &seq $sres "MSWIN"          ; test, if this is running under MS Windows
  ; insert separator
  bind-to-menu  nop     ">&Miscellaneous>-@5"

  ; create a new underlying pop-up menu for the DFT macros
  macro-to-menu dft     ">&Miscellaneous>L&FT macros@6>DFT &function search@0"
  macro-to-menu dftmark "DFT function search &mark"
  macro-to-menu dftfind "DFT function search &prompt"
  macro-to-menu dftfile "DFT file&list"
  macro-to-menu dftbase "DFT data&base name"
!endif

;*****************************************************************************
;**** write final message ****
;*****************************************************************************
write-message "DXT macro package loaded"

;**** THIS IS THE END THIS IS THE END THIS IS THE END THIS IS THE END ****

