;*******************************************************************************
;        SPACE.ASM   DISPLAYS DISK SPACE USING INT 21H FUNCTION 036H
;                CONVERTS TO SPACE.COM USING EXE2BIN
;--------------------- M A C R O S ---------------------------------------------
       ;A = ROW NUMBER
       ;B = COLUMN
       ;C = MESSAGE ##
  LOC_MESS   MACRO A,B,C
             MOV ROW,A
             MOV COLUMN,B
             CALL LOKATE
             PUSH AX
             PUSH DX
             MOV DX,OFFSET MESS&C
             MOV AH,09H
             INT 21H
             POP DX
             POP AX
             ENDM
;------------------------------------------------------------------------
  CURSOR     MACRO  X,Y
             MOV ROW,X
             MOV COLUMN,Y
             CALL LOKATE
             ENDM
;------------------------------------------------------------------------
  KEY_WAIT   MACRO
             MOV AH,07H
             INT 21H                  ;WAIT FOR KEYSTROKE
             ENDM
;-------------------- M A C R O S  E N D P ------------------------------------
;*******************************************************************************
PROGNAM SEGMENT     ;DEFINE CODE SEGMENT
;-----------------------------------------------------------
           ASSUME CS:PROGNAM,DS:PROGNAM
;-----------------------------------------------------------
   ORG 0100H
;-----------------------------------------------------------
MAIN PROC NEAR
;-----------------------------------------------------------
START:              ;starting execution address
      JMP GO_SPACE
      ROW                      DB  ?  ;ROW NUMBER
      COLUMN                   DB  ?  ;COLUMN
      ;-----------------------------------------------------------------
      MESS1   DB   '  TOTAL FREE DISK SPACE  => $'
      MESS2   DB   '    SECTORS PER CLUSTER  => $'
      MESS3   DB   '     AVAILABLE CLUSTERS  => $'
      MESS4   DB   '       BYTES PER SECTOR  => $'
      MESS5   DB   'TOTAL CLUSTERS ON DRIVE  => $'
      MESS6   DB   '       TOTAL DISK SPACE  => $'
      MESS7   DB   'PLEASE ENTER A DRIVE LETTER !!  A,B,C,D,??$'
      MESS8   DB   '------------------------------------------ $'
      MESS9   DB   'Press Any Key to Stop Your Floppy Drive!!$'
      L_OLDINT  DW   ?
      H_OLDINT  DW   ?
      L_TIMER   DW   ?
      H_TIMER   DW   ?
;-----------------------------------------------------------------------
         GO_SPACE:
                   CALL CURSOR_OFF    ;TURN CURSOR OFF
                   CALL CLEAR         ;CLEAR SCREEN
      ;-----------------------------------------------------------------
                  ;KEYBOARD ROUTINE
                   LOC_MESS 10,10,7   ;SELECT DRIVE TO CHECK
        SPACE_KEY:
                   MOV AH,1           ;GET A KEY
                   INT 21H
                   XOR AH,AH
                   XOR DX,DX          ;SET DRIVE
        ;---------------------------------------------------
                   CMP AL,0DH         ;CHECK CR
                   JNE CHK_LETTER
                   JMP START_SPACE    ;CHECK DEFAULT DRIVE
       CHK_LETTER:
                   CMP AL,044H        ; "D"
                   JG CHK_SMALL
                   CMP AL,041H        ; "A"
                   JL SPRING
                   SUB AL,040H        ;CONVERT TO DRIVE NUMBER
                   MOV DL,AL          ;SET DRIVE NUMBER
                   JMP SET_FDC
       CHK_SMALL:
                   CMP AL,064H        ;"d"
                   JG SPRING
                   CMP AL,061H        ; "a"
                   JL SPRING
                   SUB AL,060H        ;CONVERT TO DRIVE NUMBER
                   MOV DL,AL          ;SET DRIVE NUMBER
                   JMP SET_FDC
          SPRING:
                   JMP BYE_SPACE
          SET_FDC:
                   CMP DL,3
                   JL REVEC_INT       ;GO AROUND IF HARD DRVE SELECTED
                   JG START_SPACE
                   XOR DX,DX          ;SET DRIVE ZERO
                   JMP START_SPACE
        REVEC_INT:
                   CALL SET_TIMER_INT
      START_SPACE:
                   PUSH DX            ;SAVE DX FOR DRIVE CHECK
         ;------------------------------------------------------
                    MOV AH,036H     ;GET DISK SPACE
                    INT 21H
                    CALL CLEAR
         ;------------------------------------------------------
                    CMP AX,0FFFFH   ;CHECK HERE FOR ERROR
                    JNE TOTAL_FREE_BYTES
                    JMP BYE_SPACE
         ;-----------------------------------------------------
         ;              RETURNS:                              |
         ;            CX * AX = BYTES PER CLUSTER             |
         ;                                                    |
         ;       CX * AX * BX = TOTAL NUMBER OF FREE BYTES    |
         ;                                                    |
         ;       CX * AX * DX = TOTAL STORAGE SPACE IN BYTES  |
         ;                                                    |
         ;       AX = SECTORS PER CLUSTER                     |
         ;       BX = NUMBER OF AVAILABLE CLUSTERS            |
         ;       CX = BYTES PER SECTOR                        |
         ;       DX = CLUSTERS ON DRIVE                       |
         ;                                                    |
         ;-----------------------------------------------------
  TOTAL_FREE_BYTES:
                    PUSH DX            ;PUSH REGS IN THE
                    PUSH AX            ;ORDER WE USE THEM.
                    PUSH BX            ;
                    MOV BX,DX          ;SAVE DX
                    XOR DX,DX          ;SET OVERFLOW TO ZERO JUST IN CASE.
                    MUL CX             ;MULTIPLY AX * CX
                    PUSH AX            ;SAVE BYTES PER CLUSTER
                    MUL BX             ;NOW MULTIPLY BY TOTAL CLUSTERS
                    LOC_MESS 10,15,6   ;PRINT TOTAL DISK SPACE
                    CALL WRITE_DECIMAL ;PRINT DX:AX
   ;-------------------------------------------------------------
                    XOR DX,DX          ;SET OVERFLOW TO ZERO JUST IN CASE
                    POP AX             ;GET BYTES PER CLUSTER
                    POP BX             ;GET AVAILABLE CLUSTERS
                    MUL BX             ;NOW MULTIPLY BY AVAILABLE CLUSTERS
                    LOC_MESS 11,15,1   ;DISPLAY MESS1
                    CALL WRITE_DECIMAL ;PRINT TOTAL FREE BYTES
                    LOC_MESS 12,15,8   ;PRINT A LINE
        GOOD_DRIVE:
                    XOR DX,DX          ;ZERO DX FOR WRITE_DECIMAL
         ;------------------------------------------------------
                    LOC_MESS 13,15,2        ;DISPLAY MESS2
                    POP AX
                    CALL WRITE_DECIMAL      ;SECT PER CLUSTER  (AX)
                    LOC_MESS 14,15,3        ;DISPLAY MESS3
                    MOV AX,BX
                    CALL WRITE_DECIMAL      ;AVAILABLE CLUSTERS  (BX)
                    LOC_MESS 15,15,4        ;DISPLAY MESS4
                    MOV AX,CX
                    CALL WRITE_DECIMAL      ;BYTES PER SECTOR
                    LOC_MESS 16,15,5        ;DISPLAY MESS5
                    POP AX                  ;GET DX BACK
                    CALL WRITE_DECIMAL      ;TOTAL DISK CLUSTERS
        BYE_SPACE:
                    POP DX
                    OR DX,DX                ;SEE IF DX = 0
                    JZ NO_INT
                    XOR DX,4
                    JZ NO_INT
                    LOC_MESS 18,17,9
                    KEY_WAIT
                    CALL REMOVE_TIMER_INT
          NO_INT:
                    CURSOR 0,0              ;CURSOR TO TOP OF SCREEN
                    CALL CURSOR_ON
                    RET            ;return to dos

 main endp                         ;end main part of program
;******************************************************************************-
CLEAR proc near          ;define subprocedure
             ;clear screen,using scroll up function
                    PUSH AX        ;SAVE ALL REGISTERS USED
                    PUSH BX
                    PUSH CX
                    PUSH DX
                    mov ah,7       ;scroll up function
                    mov al,0       ;code to blank screen
                    mov ch,0       ;upper left row
                    mov cl,0       ;upper left column
                    mov dh,24      ;lower right row
                    mov dl,79      ;lower right column
                    mov bh,7       ;blank line attribute
                    int 10h        ;video rom call
                    POP DX         ;RESTORE REGISTERS
                    POP CX
                    POP BX
                    POP AX
                    RET
CLEAR ENDP                         ;end subprocedure
;*******************************************************************************
LOKATE PROC NEAR
                 PUSH AX
                 PUSH BX
                 PUSH DX
                 MOV AH,02h           ;POSITION CURSOR
                 MOV DH,ROW           ;SET STARTING ROW
                 MOV DL,COLUMN        ;SET STARTING COLUMN
                 MOV BH,0             ;SET CURRENT PAGE
                 INT 10H              ;VIDEO ROM CALL
                 POP DX
                 POP BX
                 POP AX
                 RET
LOKATE  ENDP
;*******************************************************************************
WRITE_DECIMAL PROC NEAR
                PUSH AX
                PUSH BX
                PUSH CX
                PUSH DX
                PUSH SI
                PUSH DI              ;ON ENTRY -
                MOV BX,DX            ;DX MSDW   AX LSDW
                MOV SI,10            ;WILL DIVIDE BY 10
                XOR CX,CX
                XOR DI,DI
                JMP TEST_BX          ;SEE IF BX (DX) = 0
     WRITE_AGAIN:
                XCHG AX,BX           ;PUT DX IN AX
                XOR DX,DX            ;ZERO DX FOR REMAINDER
                DIV SI               ;DIV AX BY 10
                XCHG AX,BX
                DIV SI               ;DIVIDE AX INCLUDING DX REMAINDER
                PUSH DX
                INC CX
     TEST_BX:
                OR BX,BX
                JNZ WRITE_AGAIN
       PUT:
                XOR DX,DX            ;SET UPPER WORD OF N TO ZERO
                DIV SI
                PUSH DX              ;PUSH ONE DIGIT ON STACK
                INC CX               ;ONE MORE DIGIT ADDED
                OR AX,AX             ;N = 0 YET ?
                JNE PUT              ;NOPE CONTINUE
       ;--------------------------------------------
       COMMA_CHK:
                CMP CX,4             ;SEE IF NUMBER NEEDS A COMMA
                JL WRITE_NUMB        ;NOPE !
                XOR DX,DX
                MOV AX,CX            ;ADJUST HERE FOR THE COMMAS
                MOV BX,3
                DIV BX
                MOV DI,DX
                OR DX,DX
                JNZ WRITE_NUMB       ;WRITE FIRST DIGITS WITH NO COMMA
        LOAD_3:
                MOV DI,3
            WRITE_NUMB:
                POP DX               ;GET DIGITS IN REVERSE ORDER
                ADD DX,30H           ;CONVERT TO ASCII
                MOV AH,02H           ;PRINT FUNCTION
                INT 21H              ;CALL DOS
                DEC DI
                JNZ DEC_AGAIN
                CMP CX,2
                JL DEC_AGAIN
                MOV AH,02H
                MOV DL,','           ;COSMETIC COMMA
                INT 21H
                MOV DI,3
      DEC_AGAIN:
                LOOP WRITE_NUMB      ;GO DO MORE
                POP DI
                POP SI
                POP DX
                POP CX
                POP BX
                POP AX
                RET
WRITE_DECIMAL ENDP
;***********************************************************************
CURSOR_OFF PROC NEAR
                    MOV AH,01H
                    MOV CX,2000H
                    INT 10H         ;SET CURSOR FUNCTION
                    RET
CURSOR_OFF ENDP
;*****************************************************************
CURSOR_ON PROC NEAR
                    MOV CX,0607H
                    MOV AH,01H
                    INT 10H         ;SET CURSOR FUNCTION
                    RET
CURSOR_ON ENDP
;*****************************************************************
TIMER_INT PROC NEAR
                  STI
                  PUSH DS
                  PUSH AX
                  PUSH DX
                  PUSH BX
                  MOV AX,0040H
                  MOV DS,AX                 ;SET DOS DATA SEG
         ;------------------------------------------------------
                  MOV BX,006CH
                  ADD WORD PTR DS:[BX],+01   ;LOW TIMER INCREMENT
         ;------------------------------------------------------
                  MOV BX,006EH
                  ADC WORD PTR DS:[BX],+00
         ;------------------------------------------------------
                  CMP WORD PTR DS:[BX],+018H
                  JNZ T5
                  MOV BX,006CH
                  CMP WORD PTR DS:[BX],00B1H
                  JNZ T5
                  XOR AX,AX                 ;ZERO AX
                  MOV WORD PTR DS:[BX],AX
                  MOV BX,006EH
                  MOV WORD PTR DS:[BX],AX
                  MOV BX,0070H
                  INC BYTE PTR DS:[BX]
            T5:
       ;------------------------------------------------------
                  ; THE NORMAL TIMER INTERRUPT ROUTINE
                  ; CHECKS THE DISKETTE MOTOR_STATUS
                  ; WORD HERE TO SEE IF THE DISK MOTOR
                  ; NEEDS TO BE TURNED OFF. WE ARE NOT
                  ; GOING TO CHECK THAT. !!  IT ALSO
                  ; CALLS INT 1CH HERE TO LET THE USER
                  ; PUT IN A TIMER ROUTINE. WE DON'T DO
                  ; THAT EITHER. !!
         ACK_INT:
                  MOV AL,20H
                  OUT 20H,AL
                  POP BX
                  POP DX
                  POP AX
                  POP DS
                  IRET               ;RETURN FROM INTERRUPT
TIMER_INT ENDP
;**************************************************************************
SET_TIMER_INT PROC NEAR
                CLI
                PUSH AX
                PUSH BX
                PUSH CX
                PUSH DX
                PUSH DS
                PUSH CS
                POP DS             ;GET CS INTO DS
;--------------------------------------------------------------------
;      GET THE INTERRUPT VECTOR
;--------------------------------------------------------------------
                MOV AH,035H        ;FUNCTION TO GET INT VECTOR
                MOV AL,08H         ;INT NUMBER TO GET
                INT 21H            ;GO GET IT
                MOV WORD PTR CS:H_TIMER,ES
                MOV WORD PTR CS:L_TIMER,BX ;OLD INT VECTOR STORED
;--------------------------------------------------------------------
;          GO SET THE NEW ONE
;--------------------------------------------------------------------
    ;----------------- SET DS:DX TO NEW VECTOR
                MOV DX,OFFSET TIMER_INT
                MOV AH,025H        ;FUNCTION NUMBER
                MOV AL,08H         ;INTERRUPT TO CHANGE
                INT 21H            ;GO SET IT
                POP DS
                POP DX
                POP CX
                POP BX
                POP AX
                STI
                RET
SET_TIMER_INT ENDP
;********************************************************************
REMOVE_TIMER_INT PROC NEAR
                    PUSH AX
                    PUSH BX
                    PUSH CX
                    PUSH DX
                    PUSH DI
                    PUSH SI
;--------------------------------------------------------------------
;  THIS WILL ATTEMPT TO RESTORE ORIGINAL INT 08 VECTOR
;--------------------------------------------------------------------
;       THE LODSB INS LOADS BYTES FROM DS:SI TO AL
;--------------------------------------------------------------------
                    PUSH CS
                    POP DS
                    MOV SI,OFFSET L_TIMER
      ;THE STOSB INS STORES BYTES FROM AL TO ES:DI
                    CLI
                    XOR DX,DX
                    MOV ES,DX    ;SET ES TO SEGMENT 0000
                    MOV DI,0020H ;SET DI TO INT 08H OFFSET
                    MOV CX,04H   ;SET CX FOR 4 BYTES
                    CLD          ;CLEAR DIRECTION FLAG
        LOAD_TIME:
                    LODSB
                    STOSB
                    LOOP LOAD_TIME
;--------------------------------------------------------------------
                    STI
                    POP SI
                    POP DI
                    POP DX
                    POP CX
                    POP BX
                    POP AX
                    RET
REMOVE_TIMER_INT ENDP
;********************************************************************
PROGNAM ENDS                       ;end of code segment
;*******************************************************************************
END  START                         ;end assembly