program VirtualExample;

uses
	(* we need this unit for two things; first, all run-time errors
	are transformed into trappable exceptions, and second, we will
	be able to query the status of the heap so that we can check
	whether the objects have leaked *)
	SysUtils,
  Employee in 'Employee.pas',
  EmployeeCaller in 'EmployeeCaller.pas',
  Programmer in 'Programmer.pas',
	ProgrammerCaller in 'ProgrammerCaller.pas',
	Manager in 'Manager.pas',
	ManagerCaller in 'ManagerCaller.pas',
	Lead in 'Lead.pas';

(* we'll use this procedure as an opportunity to shown
polymorphism; we only need a TEmployee to fire *)
procedure Fire( Employee : TEmployee );
begin
	Employee.Destroy;
end;

procedure Code( Programmer : TProgrammer );
begin
	Programmer.Work( 8 );
end;

procedure Plan( Manager : TManager );
begin
	Manager.Work( 8 );
end;

procedure ErrorHandler;
begin
	Writeln( 'Error!' );
	Readln;
	Halt;
end;

var
	Lead			:	TLead;
	Programmer	:	TProgrammer;
	Manager		:	TManager;

begin
	(* we write out the amount of free memory on the heap before
	creation and after destruction of the object. if these two
	are different, we've had a memory leak *)
	Writeln( GetHeapStatus.TotalFree, ' bytes free.' );
	try
		Lead	:=	TLead.Create;
		Writeln( GetHeapStatus.TotalFree, ' bytes free.' );
		Code( Lead.AsProgrammer );
		Plan( Lead.AsManager );
		Writeln( Lead.LinesWritten, ' lines written.' );
		Writeln( Lead.PlansMade, ' plans made.' );
		Writeln( Lead.Wage:3:2, ' dollars earned.' );
		Fire( Lead.AsEmployee );
		Writeln( GetHeapStatus.TotalFree, ' bytes free.' );
		Readln;
		Programmer	:=	TProgrammer.Create;
		Writeln( GetHeapStatus.TotalFree, ' bytes free.' );
		Code( Programmer );
		Writeln( Programmer.LinesWritten, ' lines written.' );
		Writeln( Programmer.Wage:3:2, ' dollars earned.' );
		Fire( Programmer.AsEmployee );
		Writeln( GetHeapStatus.TotalFree, ' bytes free.' );
		Readln;
		Manager		:=	TManager.Create;
		Writeln( GetHeapStatus.TotalFree, ' bytes free. ');
		Plan( Manager );
		Writeln( Manager.PlansMade, ' plans made.' );
		Writeln( Manager.Wage:3:2, ' dollars earned.' );
		Fire( Manager.AsEmployee );
	except
		ErrorHandler;
	end;
	writeln( GetHeapStatus.TotalFree, ' bytes free.' );
	readln;
end.
