{
  Author:    Craig Ward
  Copyright: none - public domain

  Date:      20/5/96

  Version:   1.0

  Overview:  Common utilities, common constants, and other misc. information.

  Notes:     WinExecAndWait, though useful in most cases, will not work efficately if used
             to execute Setup programmes which launch a "child" setup routine themselves. An
             example would be the installation programmes for the BDE and ReportSmith
             which both, once initiated, spawn a child program (which runs from the
             hard-disk).
********************************************************************************}
unit Cw_apps;

interface

uses
 WinTypes, WinProcs, Messages, Dialogs, SysUtils, IniFiles, WinDos,
 DBiTypes;



{***constants*******************************************************************}

{file-system constants}
const
 fsMaxDir =            fsDirectory + 1;     {maximum length of directory, plus null}
 fsMaxFullFileName =   fsPathName + 1;      {maximum length of path\file-name, plus null}
 fsMaxFileName =       fsFileName + 1;      {maximum length of a file-name, not inc. ext.}
 fsMaxFileNameExt =    fsFileName + fsExtension +1; {maximum lenght of a file-name, inc. extension}
 fsString =            256;                 {chosen length of a string allocation, inc. null}
 fsWinBuffer =         144;                 {minimum length of buffer for Windows directory}


{database constants}
const
 dbAlias =             DBiMaxNameLen + 1;   {maximum length of an ALIAS name plus null}
 dbTable =             fsFileName + 1;      {maximum length of a table-name plus null}




{***custom routines*************************************************************}

{prototypes}
function mWinExecAndWait(Path: PChar; Visibility: word): word;
procedure mCheckWinExec(i: integer);





implementation



{***executing programs**********************************************************}

{execute program and wait for termination -
 this routine was downloaded from an un-named source on Compuserve}
function mWinExecAndWait(Path: PChar; Visibility: word): word;
var
 InstanceID: THandle;
 Msg: TMsg;
begin
 InstanceID := WinExec(Path,Visibility);
 if InstanceID < 32 then {a value less than 32 indiciates an Exec error}
  begin
   mCheckWinExec(InstanceID);
  end
 else
  Repeat
   while PeekMessage(Msg,0,0,0,PM_REMOVE) do
    begin
     if Msg.Message = WM_QUIT then
      halt(Msg.wParam);
      TranslateMessage(Msg);
      DispatchMessage(Msg);
    end;
  until GetModuleUsage(InstanceID) = 0
end;


{switch on returned error value, and display text}
procedure mCheckWinExec(i: integer);
var
 s: ^string;
begin
 try
  New(s);

 case i of
  0:
   s^ := 'System was out of memory, executable file was corrupt'+#13#10+
         'or relocations were invalid.';
  2:
   s^ := 'File was not found.';
  3:
   s^ := 'Path was not found.';
  5:
   s^ := 'Attempt was made to dynamically link to a task,'+#13#10+
         'or there was a sharing or network-protection error.';
  6:
   s^ := 'Library required separate data segments for each task.';
  8:
   s^ := 'There was insufficient memory to start the application.';
  10:
   s^ := 'Windows version was incorrect.';
  11:
   s^ := 'Executable file was invalid. Either it was not'+#13#10+
         'a Windows application or there was an error in'+#13#10+
         'the .EXE image.';
  12:
   s^ := 'Application was designed for a different operating'+#13#10+
         'system.';
  13:
   s^ := 'Application was designed for MS-DOS 4.0.';
  14:
   s^ := 'Type of executable file was unknown.';
  15:
   s^ := 'Attempt was made to load a real-mode application'+#13#10+
         '(developed for an earlier version of Windows).';
  16:
   s^ := 'Attempt to load second instance of an executable'+#13#10+
         'containing multiple data segments not marked read-only.';
  19:
   s^ := 'Attempt was made to load a compressed executable file.'+#13#10+
         'The file must be decompressed before it can be loaded.';
  20:
   s^ := 'Dynamic-link library (DLL) file was invalid. One of the'+#13#10+
         'DLLs required to run this application was corrupt.';
  21:
   s^ := 'Application requires 32-bit extensions.';
 end;
  messageDlg('Error in execution of program: '+#13#10+#13#10+s^,mtWarning,[mbOK],0);

 finally
  Dispose(s);
 end;

end;






{}
end.
