
/**** C/C++ to HTML Converter Filter ******/

#include <stdio.h>
#include <string.h>


/* Output chars and convert various
   HTML-specific characters */
void outchar (char ch)
{ switch (ch) {
    case '<'  : printf ("&lt;"); break;
    case '>'  : printf ("&gt;"); break;
    case '&'  : printf ("&amp;"); break;
    case '\"' : printf ("&quot;"); break;
    default   : putchar (ch);
    }
} /* outchar */


void main (void)
{ char line[255+1];
  int i, /* counter for each char in line */
      inEOLcomment=0, /* flag to indicate in C++
                         "to EOL" comment */
      incomment=0, /* flag to indicate if
                      currently in comment */
      inquote=0; /* flag to indicate if currently
                    in quoted text */

  /* start HTML output; indicate text is
     preformatted and will begin in bold */
  printf ("<pre><b>");

  /* process each line from stdin */
  while (gets(line) != NULL) {

    i = inEOLcomment = 0;

    /* look at each char on line */
    while (line[i]) {
      if (!inEOLcomment) {
        if (!incomment &&
             (line[i] == '\'' || line[i] == '\"'))
          if (line[i-1] != '\\' ||
             (line[i-1] == '\\' && line[i-2] == '\\'))
            inquote = !inquote; /* toggle quote status */
        if (!inquote)
	  if (!incomment && strncmp(line+i,"//",2) == 0) {
            /* beginning of C++ line comment */
            inEOLcomment = 1;
            printf ("</b><i>//");  i += 2;
            }
          else if (strncmp(line+i,"/*",2) == 0) {
            /* beginning of comment.. */
            if (!incomment) printf ("</b><i>");
            incomment++;
            }
          else if (incomment && strncmp(line+i,"*/",2) == 0) {
            /* end of comment... */
            printf ("*/");
            incomment--;  i += 2;
            if (!incomment) printf ("</i><b>");
            continue;
            }
        }

      outchar (line[i++]);

      } /* end of line */

    if (inEOLcomment) printf ("</i><b>");
    putchar ('\n');
    } /* end of input */

  /* finish up HTML output */
  printf ("</b></pre>\n");
}

