/* ----------------------------------------------------
 *  Filename:           cftest.cpp
 *  Summary:            TCachedFile test code
 *  Author:             T.W. Nelson
 *  Compiler:           BCC++ 4.0
 *  Compile options:
 *  Start date:         06-Aug-1995
 *  Last update:        31-Aug-1995
 *  Version:            1.00
 *  Notes:
 *
 *  Source code Copyright (c) 1995 T.W. Nelson.
 *  This source (including derivations thereof) may
 *  be used in any manner provided this copyright
 *  notice is displayed appropriately.
 * ------------------------------------------------- */

#include <iostream.h>
#include <iomanip.h>
#include <stdlib.h>
#include <time.h>
#include <bios.h>
#include <io.h>
#include "cfile.h"

const int BMAX = 8;       //#cache nodes
const int BSIZE = 128;    //object size

typedef struct {
    char data[BSIZE];
    } MYDATA;

/* r/w pos for block# .... */
#define BPOS(num)   (num*sizeof(MYDATA))

static TCachedFile<MYDATA> *Cf;
static MYDATA Buf;
static int Fblocks;

void do_random(void)
{
    /* Read and write random blocks from file .....
     */
    ulong blockno;

    cout << "Random block read/write test routine.\n";
    cout << "Press any key to quit...\n\n";
    randomize();        //initialize random# generator

    while( bioskey(1) == 0 )    {
        blockno = random( Fblocks );
        Cf->ReadObject( Buf, BPOS(blockno) );
        Cf->WriteObject( Buf, BPOS(blockno) );
    }

    bioskey(0);         //remove keypress from buffer
}

int btest(void)
{
    unsigned char    option = 0;
    static long num = -1L;

    cout << "\n[Q]uit, R[a]ndom R/W, [R]ead, [W]rite, [F]lush: ";
    cin >> option;

    switch( option )
    {
    case    'Q':
    case    'q':
        return 0;       //quit
    case    'A':
    case    'a':
        do_random();    //random read/write
        num = -1;       //reset
        return 1;
    case    'R':
    case    'r':
        cout << "Enter block to read: ";
        cin >> num;
        if( (int) num >= Fblocks )
        {
            cout << "Block# out of range\a\n";
            num = -1;
        }
        else
            Cf->ReadObject( Buf, BPOS(num) );
        return 1;
    case    'W':
    case    'w':
        if( num != -1L )    {
            Cf->WriteObject( Buf, BPOS(num) );
            cout << "Block " << num << " written\n";
            num = -1;
        }
        return 1;
    case    'F':
    case    'f':
        Cf->Flush();
        return 1;
    default:
        return 1;
    }
}

long BNUM( long rw_pos )
{
    /* return block# for given r/w pos.... */
    return rw_pos == -1L ? -1L : rw_pos/sizeof(MYDATA) ;
}

void print_status()
{
    CacheNode *lru = Cf->LruNode();
    CacheNode *mru = Cf->MruNode();

    cout << "Cache statistics: Hits = " << Cf->Hits()
         << " Miss = " << Cf->Miss()
         << " Adds = " << Cf->Adds() << endl;
    cout << "Block#  Status"
         << " MRU = " << BNUM(mru->_tag)
         << " LRU = " << BNUM(lru->_tag) << endl;
    cout << "------- -------" << endl;

    TIGenDoubleListIterator<CacheNode,StdAlloc>
                                itr( *Cf->Cman() );
    CacheNode * p;
    cout.setf( ios::left, ios::adjustfield );
    while( (p = itr++) != 0 )
        cout << setw(11) << BNUM(p->_tag)
             << p->_stat << endl;
}

int main( int argc, char **argv )
{
    if( argc <= 1 )     {
            cout << "Need file name argument...\n";
            return 1;
    }

    Cf = new TCachedFile<MYDATA> ( BMAX, argv[1] );
    Fblocks = (int) (filelength( Cf->FHandle() ) / sizeof(MYDATA) );

    do {
        print_status();
    } while( btest() );

    delete Cf;

    return 0;
}

/* ----- EOF --------------------------------------- */
