/* ----------------------------------------------------
 *  Filename:           cfile.h
 *  Summary:            class CachedFile: i/o interface
 *                      to C++ cache manager
 *  Author:             T.W. Nelson
 *  Compile options:    
 *  Version:            2.0
 *  Start Date:         09-Oct-1994
 *  Last Update:        31-Aug-1995
 *  Notes:
 *
 *  14-Dec-1994 (1.5): Changed to non-template version
 *  10-Jun-1995 (2.0): Began 2.0 revisions
 *
 *  Source code Copyright (c) 1995 T.W. Nelson.
 *  This source (including derivations thereof) may
 *  be used in any manner provided copyright notice
 *  is displayed appropriately.
 * ------------------------------------------------- */

#if  !defined( __CFILE_H )
#define __CFILE_H

#include <stdio.h>  /* tmpnam() */
#include "mru.h"
#include "binfile.h"

class CachedFile : public MruCache
{
    void init();
    int tempused() const { return (_mode & CreateTemp); }
    char _tmpbuf[ L_tmpnam ];  /* temp file buffer */
    const char *_fname;  /* file, path name */
    BinaryFile  *Fp;
    int   _mode;       /* status flags */
    int   _size;        /* object size */

  protected:
    void commit( const CacheNode * );
    int read_object ( void *, ulong );
    int write_object(const void *, ulong );

  public:
    enum Mode {
        Clear = 0x0000, IsOpen = 0x0001,
        CreateTemp = 0x0002, WriteThru = 0x0004,
        IoErr = 0x0008, ReadOnly = 0x0010
        };

    CachedFile( int nodes, int objsz, const char *path, int mode )
                : _fname(path), _mode(mode), _size(objsz),
                  MruCache( nodes, objsz )  { init();  }

    virtual ~CachedFile()
        {   Flush();
            Fp->Close();
            if( tempused() )
                remove( _fname );
        }

    const char *Fname() const { return _fname; }
    int Mode() const { return _mode; }
    int FHandle() const { return Fp->Fh(); }
};

template <class T> class TCachedFile: public CachedFile
{
  protected:
    void Proc( const CacheNode * p)
        {   commit(p);
        }

  public:
    TCachedFile( int nodes,
                 const char *path = 0,
                 int mode = Clear )
        : CachedFile( nodes, sizeof(T), path, mode )  {}
    virtual ~TCachedFile() {}

    virtual int  ReadObject (T& obj, ulong tag)
        {
        return read_object( (void *) &obj, tag );
        }

    virtual int WriteObject (const T& obj, ulong tag)
        {
        return write_object( (const void *) &obj, tag );
        }
};

#endif  /* __CFILE_H    */

/* ----- EOF --------------------------------------- */
