int main(void)
{
  float flt_arr[ARR_SIZE];
  double dbl_arr[ARR_SIZE];
  double val;
  double x;
  int j, k;
  long i;


  /* seed random number generator from time */
  srand((unsigned int)time(0));


  /* initialize arrays for test 1: uniform random 0.0 - 1.0 */
  /*
   * Each call to rand() is guaranteed to give us at least 15
   * bits of randomness (RAND_MAX >= 32767) so four calls to
   * rand() should give us 15 * 4 = 60 bits of randomness.
   * Since double-precision numbers typically have 53 bits of
   * mantissa, this will do.
   */
  printf("\n%s     Simple      Extended"
         "    Sorted      Pairwise    Kahan\n", "Unif 0-1   ");
  for (j = 0; j < OUTER_ITER; j++)
  {
    for (i = 0; i < ARR_SIZE; i++)
      flt_arr[i] = dbl_arr[i]
                 =   (  rand() * (double)RAND_MAX * RAND_MAX * (double)RAND_MAX
                      + rand() * (double)RAND_MAX * RAND_MAX
                      + rand() * (double)RAND_MAX
                      + rand())
                   / (  RAND_MAX * (double)RAND_MAX * RAND_MAX * (double)RAND_MAX
                      + RAND_MAX * (double)RAND_MAX * RAND_MAX
                      + RAND_MAX * (double)RAND_MAX
                      + RAND_MAX);

    loop(flt_arr, dbl_arr, "Unif 0-1   ");
  }
  print_and_reset_minmaxerr();

  /* reinitialize for test 2: uniform random -1.0 - 1.0 */
  printf("\n%s     Simple      Extended"
         "    Sorted      Pairwise    Kahan\n", "Unif -1-1  ");
  for (j = 0; j < OUTER_ITER; j++)
  {
    for (i = 0; i < ARR_SIZE; i++)
      flt_arr[i] = dbl_arr[i]
                 =     (  rand() * (double)RAND_MAX * RAND_MAX * (double)RAND_MAX
                        + rand() * (double)RAND_MAX * RAND_MAX
                        + rand() * (double)RAND_MAX
                        + rand()) * 2.0
                     / (  RAND_MAX * (double)RAND_MAX * RAND_MAX * (double)RAND_MAX
                        + RAND_MAX * (double)RAND_MAX * RAND_MAX
                        + RAND_MAX * (double)RAND_MAX
                        + RAND_MAX)
                   - 1.0;

    loop(flt_arr, dbl_arr, "Unif -1-1  ");
  }
  print_and_reset_minmaxerr();


  /* reinitialize for test 3: more or less Gaussian */
  /*
   * Simple but not very accurate way to make a gaussian: just
   * sum lots (here 12) uniform random variables.
   */
  printf("\n%s     Simple      Extended"
         "    Sorted      Pairwise    Kahan\n", "Gaussian   ");
  for (j = 0; j < OUTER_ITER; j++)
  {
    for (i = 0; i < ARR_SIZE; i++)
    {
      val = 0.0;
      for (k = 0; k < 12; k++)
        val += rand();
      flt_arr[i] = dbl_arr[i] = val / (double)RAND_MAX - 6.0;
    }

    loop(flt_arr, dbl_arr, "Gaussian   ");
  }
  print_and_reset_minmaxerr();


  /* reinitialize for test 4: numerical integration to calculate pi */
  /*
   * The area of a circle is pi * radius^2.  When the radius is 1.0
   * the area is pi.  So we approximate pi as 4 times the area of
   * one quarter of the unit circle, and get the area of that
   * quadrant using numerical integration.
   */
  printf("\n%s     Simple      Extended"
         "    Sorted      Pairwise    Kahan\n", "Pi         ");
  for (j = 0; j < OUTER_ITER; j++)
  {
    for (i = 0; i < ARR_SIZE; i++)
    {
      x = (1 + 2 * i) / (double)(2 * ARR_SIZE);
      flt_arr[i] = dbl_arr[i] = sqrt(1.0 - x * x) * (4.0 / ARR_SIZE);
    }

    loop(flt_arr, dbl_arr, "Pi         ");
  }
  print_and_reset_minmaxerr();


  /*
   * Only print times to the nearest tenth of a second because
   * that's about how accurate typical computers are.
   */
  printf("\nTimes           Simple      Extended"
         "    Sorted      Pairwise      Kahan\n");
  printf("Float      %10.1f   %10.1f  %10.1f  %10.1f   %10.1f\n",
         f_clock / (double)CLOCKS_PER_SEC,
         fx_clock / (double)CLOCKS_PER_SEC,
         fs_clock / (double)CLOCKS_PER_SEC,
         fp_clock / (double)CLOCKS_PER_SEC,
         fk_clock / (double)CLOCKS_PER_SEC);
  printf("Double     %10.1f   %10.1f  %10.1f  %10.1f   %10.1f\n",
         d_clock / (double)CLOCKS_PER_SEC,
         dx_clock / (double)CLOCKS_PER_SEC,
         ds_clock / (double)CLOCKS_PER_SEC,
         dp_clock / (double)CLOCKS_PER_SEC,
         dk_clock / (double)CLOCKS_PER_SEC);


  return EXIT_SUCCESS;
}

