// Copyright 1993-1995 by Jon Dart.  All Rights Reserved.

#include "stdafx.h"
#include "bookentr.h"

Pool Book_Entry::allocator;

Book_Entry::Book_Entry( hash_t hc, byte rec, byte mv_indx, 
   BOOL last )
  : my_hash_code(hc & 0xffff), recommend(rec + (last ? 0x80 : 0)), move_index(mv_indx)
{
}

void Book_Entry::init( hash_t hc, byte rec, byte mv_indx, 
                       BOOL last)
{
  // The book only uses the low-order 32-bits of the hash code.
  my_hash_code = hc & 0xffff;
  recommend = rec;
  if (last)
     recommend |= 0x80;
  move_index = mv_indx;
}

BOOL Book_Entry::is_equal ( const Hashable &c) const
{
   Book_Entry *b = (Book_Entry*)&c;
   return (my_hash_code == b->my_hash_code);
}

BOOL Book_Entry::is_last() const
{
   return (recommend & 0x80) != 0;
}

void Book_Entry::set_last(BOOL b)
{
   if (b)
      recommend |= 0x80;
   else
      recommend &= ~0x80;
}

unsigned Book_Entry::get_recommend() const
{
   return (unsigned)(recommend & 0x0f);
}

