// Copyright 1994 by Jon Dart
#include "stdafx.h"
#include "bitmap.h"

#ifdef __BORLANDC__
#pragma -k-
#endif

static const int32 mask[] =
{
    1,
    1L << 1,
    1L << 2,
    1L << 3,
    1L << 4,
    1L << 5,
    1L << 6,
    1L << 7,
    1L << 8,
    1L << 9,
    1L << 10,
    1L << 11,
    1L << 12,
    1L << 13,
    1L << 14,
    1L << 15,
    1L << 16,
    1L << 17,
    1L << 18,
    1L << 19,
    1L << 20,
    1L << 21,
    1L << 22,
    1L << 23,
    1L << 24,
    1L << 25,
    1L << 26,
    1L << 27,
    1L << 28,
    1L << 29,
    1L << 30,
    1L << 31,
};

void Bitmap::clear()
{
    data[0] = data[1] = 0;
}

void Bitmap::set(int n)
{
    data[n >> 5] |= mask[n & 31];
}

void Bitmap::clear(int n)
{
    data[n >> 5] &= ~mask[n & 31];
}

int Bitmap::is_set(int n) const
{
    if (data[n >> 5] & mask[n & 31]) 
        return 1;
    else
        return 0;
}

void Bitmap::and( const Bitmap &src, Bitmap &dest) const
{
    dest.data[0] = src.data[0] & data[0];
    dest.data[1] = src.data[1] & data[1];
}

