// Copyright 1992 by Jon Dart.  All Rights Reserved.
#ifndef _PIECE_H
#define _PIECE_H

#include "types.h"
#include "color.h"

class Piece {
   public:
	   
   enum PieceType { Empty, Pawn, Knight, Bishop, Rook, Queen, King, Invalid };

   Piece()
   : my_piece(Empty)
   {
   }
   
   Piece(  const PieceType type, const ColorType color )
   {
      if (color == White)
         my_piece = 8 | type;
      else 
         my_piece = type;
   }
   
   Piece( const Piece &p )
   : my_piece(p.my_piece)
   {
   }
   
   operator int() const
   {
       return my_piece;
   }
    
   const PieceType Type() const
   {
       return (PieceType)(my_piece & 7);
   }
   
   const BOOL sliding() const;
   
   const ColorType Color() const
   {
       return (my_piece & 8) ? White : Black;
   }
   
   static const Piece &EmptyPiece();

   static const Piece &InvalidPiece();
   
   const int operator == ( const Piece &p) const
   {
       return p.my_piece == my_piece;
   }
   
   BOOL IsEmpty() const
   {
	return (Type() == Empty);   
   }
   
   unsigned Value() const;
   // value of the piece
	   
   static unsigned Value( PieceType type);
   // value of a piece
	   
   static Piece::PieceType Value( const char );
   // Convert a character representation of a piece into a PieceType.
   // Inverse of Image function, below.
	   
   static char Image(const Piece::PieceType p);
   // 1-character representation of piece
	   
   protected:
	   
   Piece( PieceType type );
   
   byte internal_value() const
   {
       return my_piece;
   }
   
   private:
	   
   byte my_piece;	   
};

#endif


