// Copyright 1994, 1995 by Jon Dart
#ifndef __EPDREC_H__
#define __EPDREC_H__

#include <fstream.h>

// This class encapsulates info about one EPD
// (Extended Position Description) record.

class EPD_Record
{
public:
    EPD_Record();
    ~EPD_Record();

    BOOL has_val(LPCSTR key) const;

    BOOL get_val(LPCSTR key, CString &val) const;

    void add(LPCSTR key, LPCSTR val);

    BOOL has_error() const
    {
        return err.GetLength() > 0;
    }

    const CString &get_error() const
    {
        return err;
    }

    void set_error(const CString &anErr)
    {
        err = anErr;
    }
    
    void getData(int i,CString &key,CString &val) const;
    
    int getSize() const
    {
       return cmds.GetSize();
    }
    
    void sort();
    
private:
    CPtrArray cmds;
    CString err;
};

#endif
