// Copyright 1993 by Jon Dart.  All Rights Reserved

#ifndef _ATTACK_ENTRY_H
#define _ATTACK_ENTRY_H

#include "types.h"
#include "piece.h"
#include <iostream.h>

class Attack_Entry
{
public:

    Attack_Entry();
    
    void add_attack(const Piece::PieceType p);
    
    void remove_attack(const Piece::PieceType p);
    
    Piece::PieceType remove_min_attacker();
    
    Piece::PieceType min_attacker() const;
    
    BOOL any_attacks() const
    {
	    return info != 0;
    }
    
    void clear()
    {
	    info = 0;
    }
    
    int operator == ( const Attack_Entry &e ) const
    {
	    return info == e.info;
    }

    int operator != ( const Attack_Entry &e ) const
    {
	    return info != e.info;
    }

    unsigned num_attacks() const;
    unsigned num_attacks(const Piece::PieceType p) const;
    
    // for debugging:
    friend ostream & operator << (ostream &o, Attack_Entry &entr);
private:    
    int16 info;
};

#endif

