// Copyright 1996 by Jon Dart.  All Rights Reserved.
// ADVANCED.CPP : implementation file
//

#include "stdafx.h"
#include "arasan.h"
#include "search.h"
#include "ADVANCED.H"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// AdvancedOptionsPage property page

IMPLEMENT_DYNCREATE(AdvancedOptionsPage, CPropertyPage)

AdvancedOptionsPage::AdvancedOptionsPage() : CPropertyPage(AdvancedOptionsPage::IDD)
{
	//{{AFX_DATA_INIT(AdvancedOptionsPage)
	m_ForcedExtensions = FALSE;
	m_History = FALSE;
	m_PawnPushExtensions = FALSE;
	m_HashSize = _T("");
	m_CheckExtensions = FALSE;
	m_Nulls = -1;
	m_Killers = -1;
	m_AutoSize = FALSE;
	//}}AFX_DATA_INIT
}

AdvancedOptionsPage::~AdvancedOptionsPage()
{
}

void AdvancedOptionsPage::DoDataExchange(CDataExchange* pDX)
{
	CPropertyPage::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(AdvancedOptionsPage)
	DDX_Control(pDX, IDC_HISTORY, m_HistoryCheckBox);
	DDX_Control(pDX, IDC_NULL_BOX, m_NullsBox);
	DDX_Control(pDX, IDC_KILLERS_BOX, m_KillersBox);
	DDX_Control(pDX, IDC_EXTENSIONS_BOX, m_ExtensionsBox);
	DDX_Control(pDX, IDC_AUTO_SIZE, m_AutoSizeCheckBox);
	DDX_Control(pDX, IDC_HASH_SIZE_EDIT, m_HashSizeEdit);
	DDX_Check(pDX, IDC_FORCED, m_ForcedExtensions);
	DDX_Check(pDX, IDC_HISTORY, m_History);
	DDX_Check(pDX, IDC_PAWN_PUSH, m_PawnPushExtensions);
	DDX_Text(pDX, IDC_HASH_SIZE_EDIT, m_HashSize);
	DDX_Check(pDX, IDC_CHECK, m_CheckExtensions);
	DDX_Radio(pDX, IDC_NULL0, m_Nulls);
	DDX_Radio(pDX, IDC_0KILLERS, m_Killers);
	DDX_Check(pDX, IDC_AUTO_SIZE, m_AutoSize);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(AdvancedOptionsPage, CPropertyPage)
	//{{AFX_MSG_MAP(AdvancedOptionsPage)
	ON_BN_CLICKED(IDC_RESET_BUTTON, OnResetButton)
	ON_BN_CLICKED(IDC_AUTO_SIZE, OnAutoSize)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// AdvancedOptionsPage message handlers

BOOL AdvancedOptionsPage::OnInitDialog() 
{
	CPropertyPage::OnInitDialog();
	
	if (m_AutoSize)
            OnAuto();
	
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void AdvancedOptionsPage::OnAuto() 
{
    long size = Search::calc_hash_size();
    static char msg[20];
    wsprintf(msg,"%ld",size);
    m_HashSizeEdit.SetWindowText(msg);
    m_HashSizeEdit.EnableWindow(FALSE);
}

void AdvancedOptionsPage::OnFixed() 
{
    m_HashSizeEdit.EnableWindow();	
}

void AdvancedOptionsPage::SetCheckButtonState(DWORD id,BOOL state)
{
    ((CButton*)GetDlgItem(id))->SetCheck(state);
}

void AdvancedOptionsPage::OnResetButton() 
{
    // Update the controls to their default state.
    // Do not update the data variables until/unless
    // user clicks Ok.
    m_AutoSizeCheckBox.SetCheck(TRUE);
    OnAuto();
    SetCheckButtonState(IDC_CHECK,TRUE);
    SetCheckButtonState(IDC_FORCED,TRUE);
    SetCheckButtonState(IDC_PAWN_PUSH,TRUE);
    m_HistoryCheckBox.SetCheck(TRUE);
    SetCheckButtonState(IDC_2KILLERS,TRUE);
    SetCheckButtonState(IDC_1KILLER,FALSE);
    SetCheckButtonState(IDC_0KILLERS,FALSE);
    SetCheckButtonState(IDC_NULL2,TRUE);
    SetCheckButtonState(IDC_NULL1,FALSE);
    SetCheckButtonState(IDC_NULL0,FALSE);
}

void AdvancedOptionsPage::OnAutoSize() 
{
    if (m_AutoSizeCheckBox.GetCheck())
        OnAuto();
    else
        OnFixed();
}
