/*

psstli.c


*/



#include "pss.h"





typedef struct oSapBroad {
   WORD          checksum;             /* high-low 1's complement */
   WORD          length;               /* high-low unsigned int */
   BYTE          transportControl;
   BYTE          packetType;
   IPXAddress    destination;
   IPXAddress    source;
   WORD          sapType;        /* 2 or 4 */
   WORD          serverType;           /* assigned by Novell */
   BYTE          serverName[48];       /* VAP name */
   IPXAddress    serverAddress;        /* server internetwork address */
   WORD          interveningNetworks;  /* # of networks packet must traverse */
} SAPBROADPKT, far * LPSAPBROADPKT;


typedef struct oBroadPkt {
   ECB         sapECB;
   SAPBROADPKT sapPkt;
} SAPBROAD, far * LPSAPBROAD;





typedef struct oSapQueryPkt {
   WORD          checksum;             /* high-low 1's complement */
   WORD          length;               /* high-low unsigned int */
   BYTE          transportControl;
   BYTE          packetType;
   IPXAddress    destination;
   IPXAddress    source;
   WORD          sapType;            /* high-low, 1 or 3 */
   WORD          serverType;           /* high-low, assigned by Novell */
} SAPQRYPKT, far * LPSAPQRYPKT;

typedef struct oQryPkt {
   ECB       sapECB;
   SAPQRYPKT sapPkt;
} SAPQRY, far * LPSAPQRY;



static ECB        sapTimer;
static WORD       sapSocket,typeSvr;
static SAPQRY     sapQry;
static SAPBROAD   sapBroad,sapResp;




static void _loadds _far advertiser(void){
   IPXSendPacket( &sapBroad.sapECB );
   IPXScheduleIPXEvent( (WORD)(60*18.2), &sapTimer );
   return;
}



static void _loadds _far responder(void){

   if( sapQry.sapPkt.sapType == NWWordSwap(3) ){
      if( sapQry.sapPkt.serverType == NWWordSwap( typeSvr ) ){

         memcpy( (LPBYTE)&sapResp.sapECB.immediateAddress, (LPBYTE)&sapQry.sapECB.immediateAddress, 6 );
         memcpy( (LPBYTE)&sapResp.sapPkt.destination, (LPBYTE)&sapQry.sapPkt.source, sizeof(IPXAddress));

         IPXSendPacket( &sapResp.sapECB );
      }
   }

   IPXListenForPacket( &sapQry.sapECB );
   return;
}


void  SAPEnd(void){

   if( sapSocket ){
      IPXCancelEvent( &sapTimer );
      IPXCancelEvent( &sapQry.sapECB );
      IPXCloseSocket( sapSocket );
   }
   sapSocket= 0;
   return;
}



BOOL  SAPStart( LPBYTE svrName, WORD svrType, LPADDR svrAddr ){

   sapSocket= NWWordSwap( SAP_SOCKET );
   if( IPXOpenSocket( (LPBYTE)&sapSocket , SHORT_LIVED) != SUCCESSFUL ){
      sapSocket= 0;
      return FALSE;
   }

   typeSvr = svrType;

   /*
      initialize sap timer
   */
   sapTimer.ESRAddress= (void (far *)())advertiser;
   sapTimer.inUseFlag = 0;
   sapTimer.socketNumber= sapSocket;


   /*
      initialize local sap query ECB
   */

   sapQry.sapECB.ESRAddress= (void (far *)())responder;
   sapQry.sapECB.inUseFlag = 0;
   sapQry.sapECB.socketNumber= sapSocket;
   sapQry.sapECB.fragmentCount= 1;
   sapQry.sapECB.fragmentDescriptor[0].address= (void far *)&sapQry.sapPkt;
   sapQry.sapECB.fragmentDescriptor[0].size= sizeof(SAPQRYPKT);



   /*
      initialize sap broadcast packet
   */
   sapBroad.sapECB.ESRAddress     = NULL;
   sapBroad.sapECB.inUseFlag      = 0;
   sapBroad.sapECB.socketNumber   = sapSocket;
   memset( (LPBYTE)sapBroad.sapECB.immediateAddress, 255, 6);
   sapBroad.sapECB.fragmentCount  = 1;
   sapBroad.sapECB.fragmentDescriptor[0].address= (void far *)&sapBroad.sapPkt;
   sapBroad.sapECB.fragmentDescriptor[0].size= sizeof(SAPBROADPKT);
   
   sapBroad.sapPkt.length      = NWWordSwap( sizeof(SAPBROADPKT) );
   sapBroad.sapPkt.packetType  = 4;

   memcpy( (LPBYTE)&sapBroad.sapPkt.source, (LPBYTE)svrAddr, sizeof(IPXAddress));
   *((LPWORD)sapBroad.sapPkt.source.socket)= sapSocket;

   memset( (LPBYTE)&sapBroad.sapPkt.destination.network, 0, 4);
   memset( (LPBYTE)&sapBroad.sapPkt.destination.node,  255, 6);
   *((LPWORD)sapBroad.sapPkt.destination.socket)= NWWordSwap( SAP_SOCKET );

   sapBroad.sapPkt.sapType    = NWWordSwap(2);
   sapBroad.sapPkt.serverType = NWWordSwap(svrType);
   strcpy( (LPBYTE)sapBroad.sapPkt.serverName, svrName );
   memcpy( (LPBYTE)&sapBroad.sapPkt.serverAddress, (LPBYTE)svrAddr, sizeof(IPXAddress));
   sapBroad.sapPkt.interveningNetworks= 1;



   /*
      initialize local sap query response packet
   */
   memcpy( (LPBYTE)&sapResp, (LPBYTE)&sapBroad, sizeof( SAPBROAD ));

   sapResp.sapECB.fragmentDescriptor[0].address= (void far *)&sapResp.sapPkt;
   sapResp.sapPkt.sapType = NWWordSwap(4);


   IPXListenForPacket( &sapQry.sapECB );
   advertiser();
   return TRUE;
}





















static void DropConnect( LPCONN s1 ){
   s1->Online= FALSE;
   if( s1->inf ) fclose(s1->inf);

   t_unbind( s1->socket );
   t_close( s1->socket );
   return;
}





static int checkEndpoint( TLIINT	td ){
	int	v;
	
	v = t_look(td);
	
	if( v== T_DISCONNECT || v== T_ORDREL )
		v = FALSE;
	else
		v = TRUE;
		
	return v;
}











static int checkConnects(void){
	IPX_ADDR    spx_addr;
	SPX_OPTS    spx_options;
   struct t_call tcall;

   int         rval= 0, i;
   LPCONN      s1;
   TLIINT      nfd,listenResult;


	tcall.addr.buf = (LPBYTE)& spx_addr;
	tcall.addr.maxlen = tcall.addr.len = sizeof( spx_addr );

	spx_options.spx_connectionID[ 0 ] = 0;
	spx_options.spx_connectionID[ 1 ] = 0;
	spx_options.spx_allocationNumber[ 0 ] = 0;
	spx_options.spx_allocationNumber[ 1 ] = 0;

	tcall.opt.buf = (LPBYTE)& spx_options;
	tcall.opt.maxlen = tcall.opt.len = sizeof( spx_options );

	tcall.udata.buf = NULL;
   tcall.udata.maxlen = tcall.udata.len = 0;


   listenResult = t_listen( gl->upgfd, &tcall );
   
   /* Step 5 */

   if ( listenResult != -1 ){
      rval = 1;

      if( (nfd = t_open( NET_TRANSPORT, O_RDWR, NULL )) == -1 ) {
   		t_error( "t_open failed" );
         rval = -1;
      }


      if( rval>0 ){
         if(t_bind( nfd, NULL, NULL) == -1 ){
      		t_error( "t_bind failed" );
            t_close( nfd );
            rval = -1;
         }
      }

      if( rval>0 ){
         if( t_accept( gl->upgfd, nfd, &tcall ) == -1 ){
		   	t_error( "t_accept failed" );
            t_unbind(nfd);
            t_close( nfd );
            rval = -1;
         }
      }


      if( rval>0 ){
         t_nonblocking(nfd);

         for(i=0; i< NUM_UPGCONNECTS; i++){
            s1= &gl->upgConnects[i];
            if( !s1->Online ){
               s1->Online= TRUE;
               s1->socket= nfd;
               s1->state = UST_SENDADDR;
               s1->mode  = MODE_PROCESS;
               s1->inf   = NULL;
               i= -1;
               break;
            }
         }
         if( i!= -1 ){
		   	t_error( "no free connects!" );
            t_unbind(nfd);
            t_close( nfd );
            return -1;
         }
      }
   }
   else rval = -1;


   return rval;
}










static void SetSend( LPCONN s1 ){
   s1->nBytes2Send= sizeof(UPGCMD);
   s1->nBytesSent = 0;
   s1->mode= MODE_SEND;
   return;
}


static void SetRecv( LPCONN s1 ){
   s1->nBytes2Read= sizeof(UPGCMD);
   s1->nBytesRead= 0;
   s1->mode= MODE_RECV;
   return;
}







void upgCheck(void){
   LPCONN      s1;
   LPUPGCMD    cmd;
   int         i,flag,len;


   checkConnects();

   for(i=0; i< NUM_UPGCONNECTS; i++){
      s1 = &gl->upgConnects[i];

      if( s1->Online ){

         cmd= (LPUPGCMD)s1->data;

         if( s1->mode== MODE_PROCESS ){

            switch( s1->state ){
               case UST_SENDADDR:
                  memcpy( cmd, &gl->addrMe, sizeof(IPXAddress));
                  SetSend(s1);
                  break;

               case UST_CHKVERSION:
                  SetRecv(s1);
                  break;

               case UST_UPGRADECMD:
                  cmd->cmd= UCMD_UPGRADE;
                  cmd->len= 0;
                  SetSend(s1);
                  break;

               case UST_UPGRADERESP:
                  SetRecv(s1);
                  break;

               case UST_DATA:
                  if( !feof( s1->inf ) ){
                     cmd->cmd= UCMD_DATA;
                     cmd->len= fread( cmd->buff, 1, UPG_TXNBUFF, s1->inf);
                  }
                  else{
                     fclose(s1->inf);
                     s1->inf= NULL;

                     cmd->cmd= UCMD_EOF;
                     cmd->len= 0;
                  }
                  SetSend(s1);
                  break;


               case UST_DISCONNECT:
                  cmd->cmd= UCMD_DISCONNECT;
                  cmd->len= 0;
                  SetSend(s1);
                  break;
            }
         }





         else if( s1->mode == MODE_RECV ){
         
            switch( t_look( s1->socket ) ){

               case T_DATA:
		            while( s1->nBytes2Read ){
                     if( (len = t_rcv( s1->socket, s1->data + s1->nBytesRead, s1->nBytes2Read, &flag )) <= 0 ) break;
                     
                     s1->nBytesRead += len;
                     s1->nBytes2Read -= len;
                  }
                  if( s1->nBytes2Read==0 ){
                     s1->mode = MODE_PROCESS;

                     switch( s1->state ){

                        case UST_CHKVERSION:
                           if( strcmp( cmd->buff, PSC_INTERNAL_ID ) != 0 )
                              s1->state= UST_UPGRADECMD;
                           else
                              s1->state= UST_DISCONNECT;
                           break;


                        case UST_UPGRADERESP:
                           if( !(BOOL)cmd->len )
                              DropConnect(s1);
                           else{
                              s1->state= UST_DATA;

                              if( (s1->inf= fopen("psc.exe","rb")) == NULL )
                                 DropConnect(s1);
                           }
                           break;
                     }
                  }
                  break;



               case T_DISCONNECT:
               case T_ORDREL:
                  DropConnect( s1 );
                  break;

            }
         }




         else if( s1->mode == MODE_SEND ){
            if( !checkEndpoint(s1->socket) ){
               DropConnect( s1 );
            }
            else{
               while( s1->nBytes2Send ){
                  if( (len = t_snd( s1->socket, s1->data + s1->nBytesSent, s1->nBytes2Send, 0 )) <= 0 ) break;
                  s1->nBytesSent += len;
                  s1->nBytes2Send -= len;
               }
               if( s1->nBytes2Send == 0 ){
                  s1->mode= MODE_PROCESS;

                  switch( s1->state ){

                     case UST_SENDADDR:
                        s1->state= UST_CHKVERSION;
                        break;

                     case UST_UPGRADECMD:
                        s1->state= UST_UPGRADERESP;
                        break;

                     case UST_DATA:
                        if( !s1->inf ) DropConnect(s1);
                        break;

                     case UST_DISCONNECT:
                        DropConnect(s1);
                        break;
                  }
               }
            }
         }
      }
   }

   return;
}




















static int tliSetup(void){
   struct t_bind tbindIn, tbindOut;
	IPX_ADDR    spx_addrIn, spx_addrOut;
   

   /* Step 1 */

	if( (gl->upgfd = t_open( NET_TRANSPORT, O_RDWR, NULL )) == -1 ){
		t_error( "t_open of master socket failed" );
		return FALSE;
	}


	/* Step 2 */

   memset( &spx_addrIn, 0, sizeof(IPXAddress) );

	tbindIn.addr.maxlen = tbindIn.addr.len = sizeof( spx_addrIn );
	tbindIn.addr.buf = (LPBYTE) & spx_addrIn;
	tbindIn.qlen = 5;

	tbindOut.addr.maxlen = tbindOut.addr.len = sizeof( spx_addrOut );
	tbindOut.addr.buf = (LPBYTE) & spx_addrOut;

	if( t_bind( gl->upgfd, &tbindIn, &tbindOut ) == -1 ){
		t_error( "t_bind failed" );
      t_close( gl->upgfd );
	   return FALSE;
	}

   gl->upgServerSocket= *((LPWORD)&spx_addrOut.ipxa_socket);

   t_nonblocking(gl->upgfd);

   return TRUE;
}




static void tliShutdown(){
   LPCONN   s1;
   int   i;

   for(i=0; i< NUM_UPGCONNECTS; i++){
      s1 = &gl->upgConnects[i];
      if( s1->Online ) DropConnect(s1);
   }

   t_unbind( gl->upgfd );
   t_close( gl->upgfd );

   IPXCloseSocket( gl->upgServerSocket );
   return;
}









int upgSetup(void){
   LPCONN      s1;
   IPXAddress  svrAddr;
   int   i;

   for(i=0; i< NUM_UPGCONNECTS; i++){
      s1 = &gl->upgConnects[i];
      s1->Online = FALSE;
      s1->inf    = NULL;
   }
   
   if( !tliSetup() ) return FALSE;

   memcpy( (LPBYTE)&svrAddr, (LPBYTE)&gl->addrMe, sizeof(IPXAddress));
   *((LPWORD)svrAddr.socket) = gl->upgServerSocket;

   if( !SAPStart( gl->upgServerName, gl->upgServerType, &svrAddr ) ){
      tliShutdown();
      return FALSE;
   }

   return TRUE;
}





int upgShutdown(void){
   SAPEnd();
   tliShutdown();
   return TRUE;
}









/* eof, psstli.c */


