#include "xheaders.h"

#include XStaticText_i
#include XRect_i
#include XColor_i
#include XStaticIcon_i
#include XStaticText_i
#include XStaticFrame_i
#include XStaticBitmap_i
#include XGroupBox_i

#include "stdio.h"

XStatic :: XStatic( HWND hwnd )
{
  winhandle = hwnd;
  WinSetWindowPtr( hwnd, 0, this);
}


XStatic :: XStatic( ULONG style, char * title, PSZ classname, XWindow * ow, XRect * r, LONG id)
{
  LONG x=0, y=0, cx=0, cy=0;

  if( r )
     {
        x= r->GetX();
        y= r->GetY();
        cx= r->GetWight();
        cy= r->GetHight();
     }
  char buffer[100], *p ;

  if(( style & SS_ICON || style & SS_BITMAP ) && id > 0)
   {
     sprintf( buffer, "#%i", id);
     p = buffer;
   }
  else
     p = title;
  OOL_WINDOWHANDLE handle = ow->GetHandle();
  winhandle = WinCreateWindow( handle, classname, (PSZ) p, style, x, y,
                                cx, cy, handle, HWND_TOP, id, NULL, NULL);
}


XStaticText :: XStaticText( HWND hwnd):XStatic( hwnd )
{
}


XStaticText :: XStaticText( XWindow * w, const char * text, XRect * r, LONG style ): XStatic( SS_TEXT | style, (char*) text, WC_STATIC, w, r)
{
  XColor color;

  w->GetBackgroundColor( &color);
  SetBackgroundColor( &color);
}


XStaticIcon :: XStaticIcon( HWND hwnd):XStatic( hwnd )
{
}


XStaticIcon :: XStaticIcon( XWindow * w, XRect * r, LONG id, LONG style ): XStatic( SS_ICON | WIN_VISIBLE | style , "", WC_STATIC, w, r, id)
{
}


XStaticBitmap :: XStaticBitmap( HWND hwnd):XStatic( hwnd )
{
}


XStaticBitmap :: XStaticBitmap( XWindow * w, XRect * r, LONG id, LONG style ): XStatic( SS_BITMAP | WIN_VISIBLE | style , "", WC_STATIC, w, r, id)
{
}


XStaticFrame :: XStaticFrame( HWND hwnd):XStatic( hwnd )
{
}


XStaticFrame :: XStaticFrame( XWindow * w, XRect * r ): XStatic( SS_FGNDFRAME | WIN_VISIBLE, "", WC_STATIC, w, r, 0)
{
}


XGroupBox :: XGroupBox( HWND hwnd): XStatic( hwnd )
{ ;}

XGroupBox :: XGroupBox( XWindow * owner, XRect * rec, const char * string): XStatic(SS_GROUPBOX | WS_VISIBLE, (char*) string, WC_STATIC, owner, rec)
{ ;}

