#define INCL_OS2MM
#define INCL_MMIOOS2
#define INCL_MMIO_CODEC
#define INCL_MCIOS2
#define INCL_MACHDR

#include "xheaders.h"

#include XVideo_i
#include XFrameWindow_i
#include XMessageBox_i
#include XSound_i
#include XControlEvent_i

#include "os2me.h"
#include "string.h"
#include "stdlib.h"
#include "stdio.h"


#ifndef WC_GRAPHICBUTTON
   #define WC_GRAPHICBUTTON ((PSZ)0xffff0040L)
#endif

//defines for sound-class, it can handle *.mid and *.wav
#define MIDI 1
#define WAVE 2

ULONG mediaCounter = 0;


LONG XMediaWindow :: SendMCIString( USHORT notify )
{
   char errorBuffer[CCHMAXPATH];

   return mciSendString( (PSZ) commandString, (PSZ) errorBuffer, (USHORT) CCHMAXPATH, owner->GetHandle(), notify);
}


XMediaWindow :: XMediaWindow( XFrameWindow * res): XObjectWindow( res)
{
   mediaId = ++mediaCounter;
   errorEnabled = FALSE;
   owner = res;
   commandString = (char*) malloc( CCHMAXPATH + 100);
}


XMediaWindow :: ~XMediaWindow()
{
   free(commandString);
}


XVideo :: XVideo( XFrameWindow * ow): XMediaWindow(ow)
{
   sprintf(idString, "OOL_Movie%u", mediaId);
}


LONG XVideo :: CloseDevice( void )
{
   strcpy( commandString, "close digitalvideo");
   return SendMCIString( );
}


LONG XVideo :: OpenDevice( void )
{
   strcpy(commandString,"open digitalvideo alias ");
   strcat(commandString, idString);
   strcat(commandString, " wait shareable");
   return SendMCIString();
}


LONG XVideo :: SetViewPort( XFrameWindow * w)
{
   SWP swp;

   CHAR    szHandle[10] = "";
   CHAR    szcx[5]      = "";
   CHAR    szcy[5]      = "";

   strcpy( commandString, "window ");
   strcat( commandString, idString);
   strcat( commandString, " handle ");

   sprintf(szHandle, "%u", WinQueryWindow( w->GetHandle(), QW_PARENT));
   strcat( commandString, szHandle);
   strcat( commandString, " ");
   strcat( commandString, "wait");

   LONG res = SendMCIString();
   if(res) return res;

   strcpy( commandString, "put ");
   strcat( commandString, idString);
   strcat( commandString, " destination at ");
   char str[20];
   WinQueryWindowPos( w->GetHandle(), &swp);
   sprintf(str, "%i", swp.x);
   strcat( commandString, str);
   strcat(commandString, " ");
   sprintf(str, "%i", swp.y);
   strcat( commandString, str);
   strcat(commandString, " ");

   sprintf( szcx, "%i", swp.cx + swp.x);
   sprintf(szcy, "%i", swp.cy+swp.y);
   strcat( commandString, szcx);
   strcat( commandString, " ");
   strcat( commandString, szcy);
   strcat( commandString, " wait");

   return SendMCIString( );
}


LONG XVideo :: SetVolume( USHORT volumePercent)
{
   strcpy( commandString, "set ");
   strcat( commandString, idString);
   strcat( commandString, " audio volume ");
   char bu[4];
   sprintf( bu, "%i", volumePercent);
   strcat( commandString, bu);
   strcat( commandString, " wait");
   return SendMCIString();
}


LONG XMediaWindow :: SetDataFile( char * p)
{
  strcpy( commandString, "load ");
  strcat( commandString, idString);
  strcat( commandString, " ");
  strcat( commandString, p);
  strcat( commandString, " wait");
  return SendMCIString();
}


XVideo :: ~XVideo ()
{
   strcpy( commandString, "close ");
   strcat( commandString, idString);
   SendMCIString();
}


LONG XMediaWindow :: Play( void )
{
   strcpy( commandString, "play ");
   strcat( commandString, idString);
   strcat( commandString, " notify");
   return SendMCIString( MEDIA_PLAYED );
}


LONG XMediaWindow :: Pause( void )
{
   strcpy( commandString, "pause ");
   strcat( commandString, idString);
   strcat( commandString, " notify");
   return SendMCIString( MEDIA_PAUSED );
}


LONG XMediaWindow :: Rewind( void )
{
   strcpy( commandString, "seek ");
   strcat( commandString, idString);
   strcat( commandString, " to start notify");
   return SendMCIString( MEDIA_REWINDED );
}


LONG XMediaWindow :: Acquire( void )
{
   strcpy( commandString, "acquire ");
   strcat( commandString, idString);
   return SendMCIString( );
}


LONG XSound :: SetVolume( USHORT volPercent )
{
   if( type == 0)
      return 0;

   strcpy( commandString, "set ");
   strcat( commandString, idString);
   if(type == WAVE)
      strcat( commandString, " audio");
   strcat( commandString, " volume ");
   char bu[4];
   sprintf( bu, "%i", volPercent);
   strcat( commandString, bu);
   strcat( commandString, " wait");
   return SendMCIString();
}



LONG XSound :: SetDataFile( char * p)
{
   if( (strstr(p, ".MID") && type != MIDI ) || (strstr( p, ".WAV") && type != WAVE ))
      OpenDevice( p );

   return XMediaWindow :: SetDataFile( p );
}


XSound :: ~XSound()
{
   if( type != 0)
      {
         strcpy( commandString, "close ");
         strcat( commandString, idString);
         type = 0;
         SendMCIString( );
      }
}


XSound :: XSound ( XFrameWindow * w):XMediaWindow( w )
{
   sprintf(idString, "OOL_Audio%u", mediaId);
}



LONG XSound :: OpenDevice( char * p )
{
   LONG res;

   if( type != 0)
      {
         strcpy( commandString, "close ");
         strcat( commandString, idString);
         type = 0;
         SendMCIString();
      }

   if( p )
      {
          if( strstr( p, ".WAV"))
            {
               type = WAVE;
               strcpy( commandString,"open waveaudio alias ");
            }
          else
            if( strstr( p, ".MID"))
              {
                 strcpy( commandString,"open sequencer alias ");
                    type = MIDI;
              }
      }

   if( type )
      {
           strcat(commandString, idString);
           strcat(commandString, " wait shareable");
           if( (res = SendMCIString()) != 0)
              return res;
           strcpy( commandString, "capability ");
           strcat( commandString, idString);
           strcat( commandString, " can play wait");
           res = SendMCIString( );
      }
   return res;
}

