#include "xgraphbt.h"

#include "string.h"
#include "stdlib.h"


#ifdef OOL_FOR_OS2_X86
   #define INCL_OS2MM
   #define INCL_MMIOOS2
   #define INCL_MMIO_CODEC
   #define INCL_MCIOS2
   #define INCL_MACHDR

   #include "os2me.h"
#endif

#ifndef WC_GRAPHICBUTTON

    #define GB_ERROR           -1
    #define GB_UP               1
    #define GB_DOWN             2
    #define GB_DISABLE          3
    #define GB_HILITE           4
    #define GB_OUTOFHILITE      5
    #define GB_TOGGLE          10
    #define GB_CURRENTSTATE    11
    #define GB_ANIMATIONBEGIN  12
    #define GB_ANIMATIONEND    13
    #define GB_MAXINDEX        14
    #define GB_TEXTBELOW        1
    #define GB_TEXTABOVE        2
    #define GB_INDEX_FORWARD   -1
    #define GB_INDEX_BACKWARD  -2
    #define GB_INDEX_FIRST     -3
    #define GB_INDEX_LAST      -4
    #define GB_RESOURCE         1
    #define GB_STRUCTURE        0

    #define GBM_SETGRAPHICDATA        0x052A
    #define GBM_ANIMATE               0x052B
    #define GBM_SETANIMATIONRATE      0x052C
    #define GBM_QUERYANIMATIONACTIVE  0x052D
    #define GBM_QUERYANIMATIONRATE    0x052E
    #define GBM_SETBITMAPINDEX        0x052F
    #define GBM_QUERYBITMAPINDEX      0x0530
    #define GBM_SETSTATE              0x0531
    #define GBM_QUERYSTATE            0x0532
    #define GBM_SETTEXTPOSITION       0x0533
    #define GBM_QUERYTEXTPOSITION     0x0534

    #define GBN_BUTTONUP      0x0524
    #define GBN_BUTTONDOWN    0x0525
    #define GBN_BUTTONHILITE  0x0526

    #define GBS_TWOSTATE         0x1000
    #define GBS_AUTOTWOSTATE     0X2000
    #define GBS_ANIMATION        0x4000
    #define GBS_AUTOANIMATION    0x8000
    #define GBS_DISABLEBITMAP    0x0010
    #define GBS_HILITEBITMAP     0x0020
    #define GBS_3D_TEXTRECESSED  0x0040
    #define GBS_3D_TEXTRAISED    0x0080

    #define WC_GRAPHICBUTTON ((PSZ)0xffff0040L)

    /* use 8-bit alignment */
    #pragma pack(1)

    typedef struct _GBTNCDATA {
        USHORT  usReserved;
        PSZ     pszText;
        HMODULE hmod;
        USHORT  cBitmaps;
        USHORT  aidBitmap[1];
    } GBTNCDATA;

    typedef GBTNCDATA* PGBTNCDATA;

    /* use 32-bit alignment again */
    #pragma pack(4)

    BOOL WinRegisterGraphicButton(VOID);

#endif



void XGraphicButton :: Select( BOOL select)
{
  SHORT sel = select ? 2 : 1;
  WinSendMsg( winhandle,  GBM_SETSTATE, MPFROMSHORT(sel), 0);
}


BOOL XGraphicButton :: IsSelected( void )
{
   if( SHORT1FROMMR(WinSendMsg( winhandle,  GBM_QUERYSTATE, 0, 0)) == 2 )
      return TRUE;
   else
      return FALSE;
}


void XGraphicButton :: Toggle( void )
{
   WinSendMsg( winhandle,  GBM_SETSTATE, MPFROMSHORT(10), 0);
}


XGraphicButton :: XGraphicButton(HWND hwnd): XSettingButton( hwnd )
{ ;}


XGraphicButton :: XGraphicButton( XWindow * owner, XRect * rec, USHORT id, ULONG style, const char * s, SHORT bitmapIdCount, SHORT * bitmapIdList) :XSettingButton( owner, rec, id, style, "", (unsigned char*) WC_GRAPHICBUTTON)
{
   PGBTNCDATA  pgbtn;
   LONG lSize;
   SHORT i;

   lSize = sizeof(GBTNCDATA) + sizeof(USHORT) * (bitmapIdCount- 1);
   pgbtn = (PGBTNCDATA) malloc(lSize);

   memset(pgbtn, 0, lSize);

   pgbtn->pszText     = (PSZ) s;
   pgbtn->cBitmaps    = bitmapIdCount;
   for(i=0; i < bitmapIdCount; i++)
      pgbtn->aidBitmap[i] = bitmapIdList[i];

   WinSendMsg( winhandle,  GBM_SETGRAPHICDATA, MPFROMP(pgbtn), 0);
}



BOOL XGraphicButton :: Animate( BOOL start, BOOL fromBeginning)
{
   return ( BOOL) WinSendMsg( winhandle,  GBM_ANIMATE, MPFROMSHORT(start), MPFROMSHORT(fromBeginning));
}


BOOL XGraphicButton :: IsAnimationActive( void )
{
   return (BOOL) WinSendMsg( winhandle,  GBM_QUERYANIMATIONACTIVE, 0, 0);
}


LONG XGraphicButton :: QueryAnimationRate(void )
{
   return (LONG) WinSendMsg( winhandle,  GBM_QUERYANIMATIONRATE, 0, 0);
}


BOOL XGraphicButton :: SetAnimationRate( LONG rate)
{
   return (BOOL) WinSendMsg( winhandle,  GBM_SETANIMATIONRATE, (MPARAM) rate, 0);
}


