#ifndef __OOL_XRESLIB_H__
#define __OOL_XRESLIB_H__

/*===========================================================================*/
/* OOL ------------------- the Open Object Library ------ OS/2 version 0.01a */
/*===========================================================================*/
/*                              class: XResourceLibrary                      */
/*                       derived from: XObject                               */
/*                        last update: 4/96                                  */
/*                      programmed by: Stefan von Brauk                      */
/*===========================================================================*/



#include "xobject.h"


class XProcess;
class XWindow;
class XString;

class _export_ XResourceLibrary: public XObject
{
      friend class XToolBar;
      friend class XDialog;
      friend class XFrameWindow;
      friend class XObjectWindow;
      friend class XMenuBar;
      friend class XPopupMenu;
      friend class XHelpInstance;
      friend class XBitmap;
   private:
      HMODULE moduleHandle;
      XProcess * proc;
   public:
      XResourceLibrary( XProcess *, char * path = NULL);
      ~XResourceLibrary();
      BOOL LoadString( XString * string, unsigned long resId);
      OOL_WINDOWHANDLE LoadMenu( XWindow * f, unsigned long id);
      OOL_BITMAPHANDLE LoadBitmap( XWindow * w, LONG id, LONG stretchX=0, LONG stretchY=0);
      OOL_ICONHANDLE LoadIcon( LONG iconId);
      void QueryBitmapSize( OOL_BITMAPHANDLE hbm, LONG& cx, LONG& cy);
};


#endif
