#ifndef __OOL_XCONTOBJECT_H__
#define __OOL_XCONTOBJECT_H__

/*===========================================================================*/
/* OOL ------------------- the Open Object Library ------ OS/2 version 0.01a */
/*===========================================================================*/
/*                              class: XContainerObject                      */
/*                       derived from: XObject                               */
/*                        last update: 5/96                                  */
/*                      programmed by: Stefan von Brauk                      */
/*===========================================================================*/



#include "xobject.h"
#include "xcontain.h"


class XContainerControl;
class XString;
class XTime;
class XDate;

class _export_ XContainerObject: public XObject
{
      friend XContainerControl;
   private:
   public:
      RECORDCORE * core;
   public:
      XContainerObject( XContainerControl * owner, SHORT columns = 0);
      virtual ~XContainerObject();
      LONG QueryEmphasis( void );
      OOL_BITMAPHANDLE QueryBitmapHandle( void );
      OOL_ICONHANDLE QueryIconHandle( void );
      void QueryTitle( XString *);
      void SetBitmapHandle( OOL_BITMAPHANDLE handle);
      void SetColumnData( SHORT column, char * data);
      void SetColumnData( SHORT column, LONG data);
      void SetColumnData( SHORT column, XDate * data);
      void SetColumndata( SHORT column, XTime * data );
      void SetIconHandle( OOL_ICONHANDLE handle);
      void SetTitle( char * t);
      virtual SHORT Sort( XContainerObject*) { return 0; }
};


#endif
