#ifndef __OOL_XCONTCOL_H__
#define __OOL_XCONTCOL_H__


/*===========================================================================*/
/* OOL ------------------- the Open Object Library ------ OS/2 version 0.01a */
/*===========================================================================*/
/*                              class: XContainerColumn                      */
/*                       derived from: XObject                               */
/*                        last update: 4/96                                  */
/*                      programmed by: Stefan von Brauk                      */
/*===========================================================================*/


#include "xobject.h"

class XContainerControl;

#ifdef OOL_FOR_OS2_X86

   //settings
   #define COL_LEFT			0x00000001
   #define COL_RIGHT			0x00000002
   #define COL_CENTER			0x00000004

   #define COL_TOP				0x00000008
   #define COL_VCENTER			0x00000010
   #define COL_BOTTOM			0x00000020

   #define COL_INVISIBLE			0x00000040

   #define COL_SEPARATOR			0x00000200
   #define COL_HORZSEPARATOR		0x00000400

   #define COL_BITMAPORICON		0x00000100
   #define COL_STRING			0x00000800
   #define COL_DATE			0x00002000
   #define COL_TIME			0x00004000
   #define COL_ULONG			0x00020000

   #define COL_FIREADONLY			0x00008000
   #define COL_FITITLEREADONLY		0x00010000

#endif

class _export_ XContainerColumn: public XObject
{
      friend XContainerControl;
      friend class XContainerInfo;
   private:
      FIELDINFO * info;
      XContainerControl * owner;
   public:
      XContainerColumn( XContainerControl * owner, void * titleData, SHORT dataColumn, LONG dataSettings = CFA_STRING|CFA_FIREADONLY , LONG titleSettings = CFA_LEFT | CFA_FITITLEREADONLY, LONG wight = 0);
      virtual ~XContainerColumn();
      XContainerColumn * GetNetxColumn( void );
      LONG QueryDataAttributes( void );
      LONG QueryTitleAttributes( void );
      void * QueryTitleData( void );
      void SetDataAttributes( LONG attr );
      void SetTitleAttributes( LONG attr );
      void SetTitleData( void * p);

};

#endif
