#ifndef __OOL_XCONTDRAGEVENT_H__
#define __OOL_XCONTDRAGEVENT_H__

/*===========================================================================*/
/* OOL ------------------- the Open Object Library ------ OS/2 version 0.01a */
/*===========================================================================*/
/*                              class: XContainerDragEvent                   */
/*                       derived from: XContainerEvent                       */
/*                        last update: 5/96                                  */
/*                      programmed by: Stefan von Brauk                      */
/*===========================================================================*/

#include "xcntevnt.h"
#include "xdragitm.h"

/*DOC
CLASS XContainerDragEvent
darg/drop events in a container generate a XContainerDragEvent which is derived
from XContainerEvent and has the same functionality like XDragEvent (see there for
further information).
*/
class _export_  XContainerDragEvent: public XContainerEvent
{
      friend MRESULT HandleFrameDefault( XFrameWindow * w, ULONG msg, MPARAM mp1, MPARAM mp2, BOOL& handled);
      friend MRESULT HandleDefault( XWindow * w, ULONG msg, MPARAM mp1, MPARAM mp2, BOOL& handled);
   private:
   public:
      XContainerDragEvent( XWindow *, MPARAM, MPARAM);
      SHORT accept;
      SHORT operation;
      DRAGINFO * dragInfo;
      ~XContainerDragEvent();
   public:
      BOOL QueryDragItem( XDragItem * itm, SHORT index);
      SHORT QueryDragItemCount( void );
      BOOL QueryDropPos( XPoint * p);
      OOL_WINDOWHANDLE QuerySourceWindow( void );
      SHORT QueryDragOperation(void);
      void SetAcceptMode( SHORT);
      void SetOperation( SHORT);
};


#endif
