// (C) 1996 Jens von Pilgrim


/*DOC
CLASS XString
Author: Jens von Pilgrim

Last change:   08.07.1996
*/

/*
History
  16.08.1995: - FastFind noch nicht ausgereift!
  26.03.1996: - XString arbeitet jetzt schneller (Lnge wird gespeichert),
                 nicht mehr "direkt" kompatibel zu pszChar!
              - assert-Abfrage wird nur bei definierten DEBUG durchgefhrt
  27.03.1996: - neuer () Operator: Liefert char-Zeiger zurck,
                optionaler Parameter: Count analog zu Left()
              - Cast-Operatoren fr
                XString -> int, const int, long, const long, double, const double
                sowie
              - Konstruktoren fr Zahlen: XString(int|long [,radix])
  01.04.1996: - Copy-Konstruktor ohne Speicherreservierung fr den Char-String
                => vorsicht! Schnell aber gefhrlich!
  29.05.1996: - Strip-Funktion
              - [] - Operator
              - DelSubString
  05.06.1996: - Replace
              - Bug in Find behoben ( ./ in .../ nicht gefunden!
  06.06.1996: - Umstellung: signed nach size_t bei
                Find und m_Length (und allgemein wo From oder To oder so auftauchen!)
              => Umsetllung von Find:
                statt: Positon = Find(Was, Von, Bis) nun:
                 gefunden = Find(Pos, Was, Von, Bis)
                Ergebnis: BOOL (True: Found, False: Not found)
  07.06.1996: - operatoren <, <=, >, <= funktionieren jetzt RICHTIG!
  13.07.1996: - StrCmp() liefert int-Wert von strcmp zum durchreichen
              - Beschleunigung von +=, Strip (u.U.), Get- und ReleaseBuffer
                durch realloc statt malloc!


****************************************************************************/


#ifndef _XSTRING_H_
#define _XSTRING_H_

#include "string.h"
#include "xobject.h"


#ifndef XLEFT
  #define XALL 0
  #define XLEFT 1
  #define XRIGHT 2
  #define XBOTH 3
#endif


class XString : public XObject
{

  public:

    XString();
    XString(const XString &aString);
    XString(char *pszChar, int DUPLICATE);
    XString(char *pszChar);
    XString(char aChar);

    XString(int aNumber, int Radix = 10);
    XString(long aNumber, int Radix = 10);

    virtual ~XString();

/////////////////////////
// from XCollectable
//    virtual XCollectable* Copy(XCollectable *inSource);
//    virtual int operator ==(XCollectable &inThen);
//    virtual int operator <(XCollectable &inThen);



/////////////////////////
//  cast - operators
    operator char *() { return m_pszChar; };
    operator const char *() { return m_pszChar; };
    operator int();
    operator long();
    operator double();
    operator const int();
    operator const long();
    operator const double();

    char* operator() ();
    char* operator() (size_t inCount); // == Left(inCount)
    char operator[](size_t inZeroIndex);
    char At(size_t inZeroIndex);

    XString operator =(const XString &aString);

    virtual int operator ==(const char *inCharPtr) ;
    virtual int operator ==(const XString &inThen) ;
    virtual int operator !=(const XString &inThen) ;
    virtual int operator <=(const XString &inThen);
    virtual int operator >=(const XString &inThen);
    virtual int operator >(const XString &inThen);
    virtual int operator <(const XString &inThen);
    virtual int StrCmp(const XString &inThen);

/////////////////////////
// Friends
    friend XString operator +(const XString Str1, const char *pszChar2);
    friend XString operator +(const char *pszChar1, const XString Str2);
    friend XString operator +(XString Str1, XString Str2);

    XString operator +=(const XString &Str);
    XString operator +=(const char *Str);

    virtual XString Mid(size_t From, size_t Count);
    virtual XString Left(size_t Count);
    virtual XString Right(size_t Count);
    virtual  size_t GetLength();
    int IsEmpty() { return GetLength()>0; };

    BOOL Find(size_t &outPos, const XString &SubString, size_t From = 0, size_t inTo = 0);
    BOOL FindRev(size_t &outPos, const XString &SubString, size_t From = 0, size_t inTo = 0);
//    int FastFind(size_t &outPos, const XString &SubString, XString &SearchTab, size_t From=0);

    int Strip(int inWhere = XBOTH, char inChar = ' ');
    int DelSubString(XString inSubString);
    int DelSubString(size_t inFrom, size_t inCount=1);

    int Replace(XString inSearch, XString inReplace, int inTimes=XALL, size_t inFrom=0, size_t inTo=0);

//    char* GetBuffer(int Size);

    char* GetBuffer(size_t Size=0);
    int ReleaseBuffer(size_t Length=0);


  public:
    char *m_pszChar;
    size_t  m_Length;

};


/*DOC XString::IsEmpty
GROUP Comperasion
RETURNS True, if the String is empty

False, else
REMARKS If the string is not allocated (f.e. a Stringpointer before calling new) is NOT empyt! If
you call any String-Function before calling the Constructor, most functions fail and the program
will exit by a failed assert!
*/


#endif


