#include "xheaders.h"

#include XFrameWindow_i
#include XFrame_i
#include XFrameControl_i
#include XScrollBar_i
#include XRect_i

#include <stdlib.h>


XWindow * XFrame :: QueryWindow( ULONG id )
{
  if( id == WIN_PARENT )
     return frame;
  else
     return XWindow::QueryWindow( id );
}


XFrame :: ~XFrame()
{
  SHORT i;

  for(i=0; i < controls; i++)
     delete cont[i];
}


XFrame :: XFrame(XFrameWindow * f):XControl ( f->frame )
{
   cont = NULL;
   controls = 0;
   adds = 0;
   frame = f;
}


XFrame :: XFrame( HWND hwnd): XControl( hwnd)
{
   cont = NULL;
   controls = 0;
   adds = 0;
   frame = NULL;
}


void XFrame :: AddFrameControl( XFrameControl * f)
{
   controls += 1;
   cont = (XFrameControl**) realloc( cont, controls*sizeof(void*));
   cont[controls-1] = f;
   if( frame->dlgHandle)
     {
        XRect rec1;
        frame->GetSize( &rec1);
        rec1.SetHight( rec1.GetHight() + f->cy);
        frame->SetSize( &rec1 );
     }
}


MRESULT XFrame :: HandleMessage( ULONG msg, MPARAM mp1, MPARAM mp2 )
{
  SHORT countSwp;

  switch(msg)
   {
     case WM_QUERYFRAMECTLCOUNT:
        return MRFROMSHORT((ULONG) oldfunc(winhandle, msg, mp1, mp2) + controls+ adds);
     case WM_FORMATFRAME :
        {
          SHORT i=0;
          PSWP  pswp, sav;

          countSwp = (int) oldfunc( winhandle, msg, mp1, mp2);

          pswp=(PSWP)mp1;

          sav = &pswp[countSwp-1];

          for(i=0; i < controls; i++)
             cont[i]->AdjustSize( &pswp[countSwp+i], sav );

          if( frame )
            {
              if( frame->vert)
                {
                   sav->cx -= 15;
                   SHORT y = sav->y;
                   if( frame->horz)
                      y += 15;
                   pswp[countSwp+i].x = sav->cx + sav->x;
                   pswp[countSwp+i].cx = 15;
                   pswp[countSwp+i].y = y;
                   pswp[countSwp+i].cy = sav->y + sav->cy - y;
                   pswp[countSwp+i].hwnd = frame->vert->winhandle;
                   pswp[countSwp+i].fl = SWP_SIZE|SWP_MOVE;
                   i+=1;
                }
              if( frame->horz)
                {
                   pswp[countSwp+i].x = sav->x;
                   pswp[countSwp+i].cx = sav->cx;
                   pswp[countSwp+i].y = sav->y;
                   pswp[countSwp+i].cy = 15;
                   pswp[countSwp+i].hwnd = frame->horz->winhandle;
                   pswp[countSwp+i].fl = SWP_SIZE|SWP_MOVE;
                   i++;
                   sav->y += 15;
                   sav->cy -= 15;
                }
              if( frame->dummy)
                {
                   pswp[countSwp+i].x = sav->cx+sav->x;
                   pswp[countSwp+i].cx = 15;
                   pswp[countSwp+i].y = sav->y-15;
                   pswp[countSwp+i].cy = 15;
                   pswp[countSwp+i].hwnd = frame->dummy;
                   pswp[countSwp+i].fl = SWP_SIZE|SWP_MOVE;
                   i++;
                }
              if( frame->clientWindow)
                {
                   pswp[countSwp+i].x = sav->x;
                   pswp[countSwp+i].cx = sav->cx;
                   pswp[countSwp+i].y = sav->y;
                   pswp[countSwp+i].cy = sav->cy;
                   pswp[countSwp+i].hwnd = frame->clientWindow->winhandle;
                   pswp[countSwp+i].fl = SWP_SIZE|SWP_MOVE;
                }
           }
        }
       return MRFROMSHORT(countSwp+controls+ adds);
     default:
        return FALSE;
   }
 return( FALSE );
}

