#ifndef __OOL_XPOINT_H__
#define __OOL_XPOINT_H__

/*===========================================================================*/
/* OOL ------------------- the Open Object Library ------ OS/2 version 0.01a */
/*===========================================================================*/
/*                              class: XPoint                                */
/*                       derived from: XObject                               */
/*                        last update: 4/96                                  */
/*                      programmed by: Stefan von Brauk                      */
/*===========================================================================*/



#include "xobject.h"
#include "string.h"

class _export_ XPoint: public XObject
{
    friend class XControl;
    friend class XWindow;
    friend class XFrameWindow;
    friend class XGraphicObject;
    friend class XLine;
    friend class XText;
    friend class XBox;
    friend class XMarker;
  private:
    POINTL p;
  public:
    XPoint( long xPoint = 0, long yPoint = 0) { p.x = xPoint; p.y = yPoint; }
    XPoint( XPoint * pp) { memcpy( &p, &pp->p, sizeof(p)); }
    virtual ~XPoint() {;}
    long GetX( void ) { return p.x; }
    long GetY( void ) { return p.y; }
    void SetX( long newX ) {p.x = newX; }
    void SetY( long newY ) {p.y = newY; }
};

#endif
