#ifndef __OOL_XGRAPHDEV_H__
#define __OOL_XGRAPHDEV_H__

/*===========================================================================*/
/* OOL ------------------- the Open Object Library ------ OS/2 version 0.01a */
/*===========================================================================*/
/*                              class: XGraphicDevice                        */
/*                       derived from: XObject                               */
/*                        last update: 4/96                                  */
/*                      programmed by: Stefan von Brauk                      */
/*===========================================================================*/


#include "xobject.h"


class XWindow;
class XGraphicObject;
class XColor;
class XPoint;

class _export_ XGraphicDevice: public XObject
{
      friend class XLine;
      friend XGraphicObject;
      friend class XFont;
      friend class XText;
      friend class XBox;
      friend class XMarker;
      friend class XBitmap;
      friend class XBitmapShadow;
   private:
      HAB hab;
      HPS hps;
      HWND hwnd;
      LONG backCol;
      XGraphicObject * first, *last;
      LONG aktColor, xOffset, yOffset;
      char aktLineEnding;
      char aktLineJoining;
      SHORT aktLineWidth;
      SHORT aktFontSize;
      char aktFont;
      void SetPaintColor( LONG);
      char fontId;
      SHORT markerType;
      LONG wight, hight;
   public:
      XGraphicDevice( XWindow*, BOOL createInMemory = FALSE);
      virtual ~XGraphicDevice();
      void AddObject ( XGraphicObject*);
      void Copy( XGraphicDevice * source, XPoint * targetLeft, XPoint * targetRight, XPoint * sourceLeft, XPoint * sourceRight = NULL);
      void Draw( void );
      XGraphicObject * FindObject( LONG x, LONG y, XGraphicObject * searchBehind = NULL);
      BOOL RemoveObject( XGraphicObject*, BOOL destroyObject = TRUE);
      void ResetFont( void );
      void SetBackgroundColor( XColor * c);
      void SetFont( XFont * );
      void SetHight( LONG h) { hight = h; }
      void SetLineEnd( char lineEnding);
      void SetLineJoin( char lineJoin );
      void SetLineWidth( SHORT width);
      void SetWight( LONG h) { wight = h; }
      void SetXOffset(LONG);
      void SetYOffset(LONG);
};

#endif
