#ifndef __OOL_XFRAMEWND_H__
#define __OOL_XFRAMEWND_H__

/*===========================================================================*/
/* OOL ------------------- the Open Object Library ------ OS/2 version 0.01a */
/*===========================================================================*/
/*                              class: XFrameWindow                          */
/*                       derived from: XWindow                               */
/*                        last update: 5/96                                  */
/*                      programmed by: Stefan von Brauk                      */
/*===========================================================================*/


#include "xwindow.h"

class XResource;
class XRect;
class XScrollBar;
class XString;
class XControlEvent;
class XMenu;
class XProcess;

#ifdef OOL_FOR_OS2_X86
   #define FRM_TITLEBAR         0x00000001
   #define FRM_SYSMENU          0x00000002
   #define FRM_SIZEBORDER       0x00000008
   #define FRM_MINBUTTON        0x00000010
   #define FRM_MAXBUTTON        0x00000020
   #define FRM_CENTER           0x00080000
   #define FRM_DIALOGBORDER     0x00000100
   #define FRM_BORDER           0x00000200
   #define FRM_TASKLIST         0x00000800
   #define FRM_NOBYTEALIGN      0x00001000
   #define FRM_NOMOVEWITHOWNER  0x00002000
   #define FRM_ICON             0x00004000
   #define FRM_ACCELTABLE       0x00008000
   #define FRM_SYSMODAL         0x00010000
   #define FRM_SCREENALIGN      0x00020000
   #define FRM_MOUSEALIGN       0x00040000
   #define FRM_HIDEBUTTON       0x01000000
   #define FRM_HIDEMAX          0x01000020
   #define FRM_AUTOICON         0x40000000
#endif



class _export_ XFrameWindow: public XWindow{
      friend class XMenuBar;
      friend class XPopupMenu;
      friend class XFrameControl;
      friend class XHelpInstance;
      friend class XObjectWindow;
      friend class XFrame;
      friend class XToolBar;
      friend MRESULT EXPENTRY DProc(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2);
      friend MRESULT EXPENTRY WindowProc(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2);
      friend MRESULT HandleFrameDefault( XFrameWindow * w, ULONG msg, MPARAM mp1, MPARAM mp2, BOOL& handled);
      friend MRESULT EXPENTRY ScrollProc(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2);
   protected:
      XScrollBar * vert, *horz;
      virtual MRESULT HandleMessage( ULONG msg, MPARAM mp1, MPARAM mp2) { return 0; }
   public:
      static long defaultStyle;          //default setting for a framewindow
      static long defaultClientStyle;    //default setting for windows wich are displayed as a clientwindow of a framewindow
      static long defaultDialogStyle;    //default setting for windows wich are displayed as a dialog
   protected:
      OOL_WINDOWHANDLE dummy;
      XFrame * frameWin;
      XWindow * clientWindow;
      XFrameWindow * lockingWin;
      OOL_WINDOWHANDLE frame, dlgHandle;
      BOOL enabled;
      PFNWP oldfunc;
      LONG backCol;
   public:
      XFrameWindow( XResource * resource,
                     const char * title =NULL,
                     ULONG createstyle = defaultStyle,
                     XRect * rec = NULL,
                     XFrameWindow * parent=NULL,
                     BOOL buildFromResources = FALSE);
      virtual ~XFrameWindow();
      void Activate( void );
      virtual void DoCommand( LONG);
      virtual void DoControl( XControlEvent*);
      virtual void Draw ( void );
      void Enable( BOOL enable = TRUE);
      void EnableWindowUpdate ( BOOL enable = TRUE );
      void FillBackground( void );
      void GetClientSize( XRect *);
      OOL_WINDOWHANDLE GetHandle();
      void GetSize( XRect* rect);
      LONG GetText( XString * buffer );
      XWindow * GetWindow( ULONG id);
      void Hide(void);
      virtual void InitMenu( XMenu *);
      virtual BOOL QueryForClose( void );
      XProcess * QueryProcess( void );
      void SetBackgroundColor( XColor*);
      void SetBottom(void);
      void SetClient( XWindow * c);
      void SetIcon( LONG iconHandle);
      void SetSize( XRect * rect);
      void SetText(const char * buffer);
      void SetTop(void);
      void Show(void);
      void ShowModal( XFrameWindow *  );
};


#endif
