#ifndef __OOL_XCONTAINEREVENT_H__
#define __OOL_XCONTAINEREVENT_H__

/*===========================================================================*/
/* OOL ------------------- the Open Object Library ------ OS/2 version 0.01a */
/*===========================================================================*/
/*                              class: XContainerEvent                       */
/*                       derived from: XEvent                                */
/*                        last update: 5/96                                  */
/*                      programmed by: Stefan von Brauk                      */
/*===========================================================================*/

#include "xcntrevn.h"


#ifdef OOL_FOR_OS2_X86

   //message-ids

   #define CON_BEGINEDIT    CN_BEGINEDIT
   #define CON_COLLAPSTREE  CN_COLLAPSTREE
   #define CON_CONTEXTMENU  CN_CONTEXTMENU
   #define CON_DRAGOVER     CN_DRAGOVER
   #define CON_DROP         CN_DROP
   #define CON_EMPHASIS     CN_EMPHASIS
   #define CON_ENDEDIT      CN_ENDEDIT
   #define CON_ENTER        CN_ENTER
   #define CON_EXPANDTREE   CN_EXPANDTREE
   #define CON_INITDRAG     CN_INITDRAG
   #define CON_PAINTBACKGOUND CM_PAINTBACKGROUND
#endif


class XContainerObject;

/*DOC
CLASS XContainerEvent
Events in conatiner generate a XContainerEvent, if you want to catch these
events you must geerate a XContainerHandler. Possible event-id are:

   CON_BEGINEDIT         the user start to edit a field
   CON_COLLAPSTREE       in tree-view the tree or a part of it is collapsed
   CON_CONTEXTMENU       a context-menu is requested
   CON_DRAGOVER          one or more objects fly over the container
   CON_DROP              one or more objects are dropped
   CON_EMPHASIS          the emphasis of an item has changed
   CON_ENDEDIT           the user stopped to edit a field
   CON_ENTER             ENTER was pressed
   CON_EXPANDTREE        in tree-view the tree or a part of it is expanded
   CON_INITDRAG          a drag-operation is requested
   CON_PAINTBACKGOUND    the background of the container must be redrawn

On drag-events a XContainerDragEvent s posted, you can typecast in XContainerHandler.
*/

class _export_ XContainerEvent: public XControlEvent
{
      friend MRESULT HandleFrameDefault( XFrameWindow * w, ULONG msg, MPARAM mp1, MPARAM mp2, BOOL& handled);
      friend MRESULT HandleDefault( XWindow * w, ULONG msg, MPARAM mp1, MPARAM mp2, BOOL& handled);
   protected:
      RECORDCORE * core;
      XContainerEvent( XWindow * w, MPARAM mp1, MPARAM mp2);
   public:
      XContainerObject * GetObject( void );
};


#endif
