#include "xheaders.h"

#include XResource_i
#include XResourceLibrary_i
#include XApplication_i
#include XWindow_i
#include XString_i
#include XMessageBox_i


OOL_ICONHANDLE XResourceLibrary :: LoadIcon( LONG iconId)
{
   return WinLoadPointer( HWND_DESKTOP, moduleHandle, iconId );
}


/*DOC
CLASS XResource
FUNCTION XResource
GROUP constructors/destructors
REMARKS Constructs a resource. Resources are defined by an ID and
a XResourceLibrary which contains the resource.

Parameters:    ULONG theResourceID       the ID of the resource
               XResourceLibrary * theLib pointer to the library which
                                         contains the resource
Returns:       -
*/
XResource :: XResource( unsigned long resId, XResourceLibrary * l)
{
   id = resId;
   library = l;
}


void XResourceLibrary :: QueryBitmapSize( OOL_BITMAPHANDLE hbm, LONG& cx, LONG& cy)
{
  BITMAPINFOHEADER l;
  l.cbFix = sizeof( BITMAPINFOHEADER);

  GpiQueryBitmapParameters( hbm, &l);

  cx = l.cx;
  cy = l.cy;
}


OOL_BITMAPHANDLE XResourceLibrary :: LoadBitmap( XWindow * w, LONG id, LONG stretchX, LONG stretchY)
{
   return GpiLoadBitmap( WinGetPS( w->GetHandle()), moduleHandle, id, stretchX, stretchY);
}


/*DOC
CLASS XResourceLibrary
FUNCTION XResourceLibrary
GROUP constructors/destructors
REMARKS Constructs a resource library.

Parameters:    XProcess * theOwner       A pointer to the owning process. Every
                                         resource which is build from the library will
                                         be owned by this process
               char * thePath            path of the library without extension ".DLL".
                                         If the path is empty, a resource library will
                                         be generated with the resources which are
                                         linked to the exe-file.
                                         If the file cannot be found an error ocures.
                                         Default is NULL.
Returns:       -
*/
XResourceLibrary :: XResourceLibrary( XProcess * app, char * path)
{
  char errorBuffer[100];
  proc = app;
  if( path)
     {
        if( DosLoadModule( (PSZ) errorBuffer, 100, (PSZ) path, &moduleHandle) != 0)
          {
            XMessageBox( "error loading resourcefile - file not found");
            return;
            //throw( XException("error loading resourcefile - file not found", -10));
          }
     }
  else
     moduleHandle = 0;
}


/*DOC
CLASS XResource
FUNCTION XResource
GROUP load resources
REMARKS loads a string out of the library.

Parameters:    XString * string          variable which will get the string
               ULONG theResourceID       the ID of the string
Returns:       -
*/
BOOL XResourceLibrary :: LoadString( XString * string, unsigned long resId )
{
   char s[255];
   SHORT len;

   if( (len=WinLoadString( proc->hab, moduleHandle, resId, 255, (PCH) s)) == 0)
      {
         string->GetBuffer();
         return FALSE;
      }
   else
     *string = s;
   return TRUE;
}


HWND XResourceLibrary :: LoadMenu( XWindow * fr, unsigned long id)
{
  return WinLoadMenu( fr->GetHandle(), moduleHandle, id);
}


/*DOC
CLASS XResourceLibrary
FUNCTION XResourceLibrary
GROUP constructors/destructors
REMARKS destructs a resource library.
*/
XResourceLibrary :: ~XResourceLibrary()
{
   if( moduleHandle)
      DosFreeModule(moduleHandle);
}
