#include "xmle.h"

#include <string.h>
#include <stdlib.h>

#include "xstring.h"


void XMLESearch :: QuerySearchItem( XString * s)
{
   strcpy( s->GetBuffer( sStruct.cchFind + 1), sStruct.pchFind);
   s->ReleaseBuffer();
}


void XMLESearch :: QueryReplaceItem( XString * s)
{
   strcpy( s->GetBuffer( sStruct.cchReplace + 1), sStruct.pchReplace);
   s->ReleaseBuffer();
}


XMLESearch :: XMLESearch()
{
   memset( &sStruct, 0, sizeof(sStruct));
   mode = MLFSEARCH_SELECTMATCH;
   sStruct.iptStop = -1;
   sStruct.cb = sizeof(sStruct);
}


LONG XMLESearch :: GetStartPoint ( void )
{
   return sStruct.iptStart;
}


void XMLESearch :: SetCaseSensitive( BOOL set)
{
  if(set)
     mode |= MLFSEARCH_CASESENSITIVE;
  else
     if( mode & MLFSEARCH_CASESENSITIVE)
        mode ^= MLFSEARCH_CASESENSITIVE;
}


void XMLESearch :: SetReplaceAll( BOOL set)
{
  if(set)
     mode |= MLFSEARCH_CHANGEALL;
  else
     if( mode & MLFSEARCH_CHANGEALL)
        mode ^= MLFSEARCH_CHANGEALL;
}


void XMLESearch :: SetSearchItem( char * item)
{
   SHORT i = strlen(item) + 1;
   sStruct.pchFind = (char*) realloc( sStruct.pchFind, i);
   memcpy( sStruct.pchFind, item, i);
   sStruct.cchFind = i-1;
}


void XMLESearch :: SetReplaceItem( char * item)
{
   SHORT i = strlen(item) + 1;
   sStruct.pchReplace = (char*) realloc( sStruct.pchReplace, i);
   memcpy( sStruct.pchReplace, item, i);
   sStruct.cchReplace = i-1;
}


void XMLESearch :: SetSearchStartPoint( LONG x)
{
   sStruct.iptStart = x;
}


void XMLESearch :: SetSearchEndPoint( LONG x)
{
   sStruct.iptStop = x;
}


XMLESearch :: ~XMLESearch()
{
   free(sStruct.pchReplace);
   free(sStruct.pchFind);
}


XMultiLineEdit :: XMultiLineEdit(HWND hwnd): XControl( hwnd )
{ ;}


XMultiLineEdit :: XMultiLineEdit(XWindow * owner, XRect * rec, USHORT id, ULONG style, const char *string ): XControl(rec, style, owner, string, WC_MLE, id)
{ ; }


void XMultiLineEdit :: QuerySel(LONG& start, LONG& end)
{
   MRESULT mr = WinSendMsg( winhandle, MLM_QUERYSEL, (MPARAM ) MLFQS_MINMAXSEL, 0);
   start = SHORT1FROMMR( mr );
   end = SHORT2FROMMR( mr );
}


void XMultiLineEdit :: SetLimit( USHORT limit)
{
   WinSendMsg( winhandle, MLM_SETTEXTLIMIT, (MPARAM ) limit, 0);
}


void XMultiLineEdit ::EnableOverWrite( BOOL overWrite)
{
  BOOL o = FALSE;
  if( overWrite == FALSE)
    o = TRUE;
  WinSendMsg( winhandle, EM_SETINSERTMODE, MPFROMSHORT ( o ), 0);
}


BOOL XMultiLineEdit ::CanUndo( void )
{
   return SHORT1FROMMR(WinSendMsg( winhandle,  MLM_QUERYUNDO, 0, 0));
}


void XMultiLineEdit ::InsertString( const char * p)
{
   WinSendMsg( winhandle, MLM_INSERT, MPFROMP(p), 0);
}


BOOL XMultiLineEdit ::HasChanged( void )
{
   return (BOOL) WinSendMsg( winhandle, MLM_QUERYCHANGED, 0,  0);
}


LONG XMultiLineEdit ::QueryTextLength( void)
{
   return (LONG) WinSendMsg( winhandle,  MLM_QUERYTEXTLENGTH, 0, 0) + (LONG) WinSendMsg( winhandle, MLM_QUERYLINECOUNT,0,0);
}


void XMultiLineEdit ::SelectText( unsigned short start, unsigned short end)
{
   WinSendMsg( winhandle, MLM_SETSEL, MPFROM2SHORT ( start, end), 0);
}


void XMultiLineEdit ::ShowFirstChar( SHORT firstChar)
{
   WinSendMsg( winhandle,  MLM_SETFIRSTCHAR, MPFROMSHORT(firstChar), 0);
}


BOOL XMultiLineEdit ::Undo( void )
{
   return SHORT1FROMMR(WinSendMsg( winhandle, MLM_UNDO, 0, 0));
}


BOOL XMultiLineEdit :: Search( XMLESearch * s)
{
   return SHORT1FROMMR( WinSendMsg( winhandle, MLM_SEARCH, (MPARAM) s->mode, MPFROMP(&s->sStruct)));
}


void XMultiLineEdit :: SetSel( LONG from, LONG to)
{
   WinSendMsg( winhandle, MLM_SETSEL, (MPARAM) from, (MPARAM) to);
}

