#include "xheaders.h"

#include XFileDialog_i
#include XString_i
#include XWindow_i
#include XFile_i

#include "stdlib.h"
#include "string.h"


/*DOC
CLASS XFileDialog
FUNCTION XFileDialog
GROUP constructors/destructors
REMARKS open the system defined file-dialog
Parameters: XWindow * theOwner           owner-window
            char * fileMask              the file-mask to be displayed (default is <*.*>)
            char * theTitle              title of the dialog (default is NULL)
            char * filetype              file-type to be displayed (default is NULL)
            LONG options                 options, valid values are
                                             FD_OPEN         open-dialog
                                             FD_CENTER       dialog is centered
                                             FDS_SAVEAS_     saveas-dialog
                                             FD_MULTIPLESEL  multiple file-selection
                                         (default is FD_OPEN | FD_CENTER, can be ored)
Returns:    -
*/
XFileDialog :: XFileDialog( XWindow * owner, char * f, char * title, char * fileType, LONG options)
{
   FILEDLG fild;

   fileName = NULL;
   memset (&fild, 0, sizeof (FILEDLG));
   fild.cbSize     = sizeof (FILEDLG);
   fild.fl         = options;
   fild.pszTitle = (PSZ) title;
   fild.pszIType = (PSZ) fileType;
   strcpy(fild.szFullFile, f);

   WinFileDlg (HWND_DESKTOP, owner->GetHandle(), &fild);
   pap = fild.papszFQFilename;
   numbers = fild.ulFQFCount;
   command = fild.lReturn;
   fileName = (char*) malloc( strlen (fild.szFullFile) + 1);
   strcpy (fileName, fild.szFullFile);
}


/*DOC
CLASS XFileDialog
FUNCTION GetFileName
GROUP misc
REMARKS if the file-dialog is proceeded you can ask for the
selected filename. If FD_MULTIPLESEL is specified, at first ask with QueryFileCont
for the number of files selected.
Parameters: XString * buffer                the buffer which will contain the filename
            SHORT index                     zero-based index of filename to get
                                            (default is 0)
Returns:    -
*/
void XFileDialog :: GetFileName ( XString * st, SHORT index)
{
  if( index == 0)
     *st = fileName;
  else
     *st = (char*) *pap[index];
}


XFileDialog :: ~XFileDialog()
{
   WinFreeFileDlgList(pap);
   free( fileName);
}


/*DOC
CLASS XFile
FUNCTION XFile
GROUP constructors/destructors
REMARKS open a file
Parameters: char * path                  the path o the file
            ULONG size                   size to open (only if a file is created)
            ULONG modeForOpen            how to open, possible values are:
                                            XFILE_REPLACE_EXISTING  override existing filea
                                            XFILE_OPEN_EXISTING     open if file exists
                                            XFILE_FAIL_EXISTING     cancel if the file exists
                                            XFILE_FAIL_IF_NEW       cancel if the file doesnt exist
                                            XFILE_CREATE_IF_NEW     create a new file if it doesnt exist
                                         (can be ored)
            ULONG accessMode             mode for file-sharing and access, possible values are:
                                            XFILE_SHARE_DENYREAD
                                            XFILE_SHARE_DENYWRITE
                                            XFILE_SHARE_DENYREADWRITE
                                            XFILE_SHARE_DENYNONE
                                            XFILE_READONLY
                                            XFILE_WRITEONLY
                                            XFILE_READWRITE
                                         (cna be ored)
            EAOP2 * eaList               list with extended attributes (default is NULL)
Returns:    ULONG                        result returned by the OS
*/
ULONG XFile :: Open(char * filename, ULONG size, ULONG modeifexist, ULONG modeopen, EAOP2 * ealist)
{
 ULONG aktion;

 return DosOpen((PSZ) filename, &handle, &aktion, size, 0, modeifexist, modeopen, ealist);
}


////////////////docs only
/*DOC
CLASS XFileDialog
FUNCTION GetCommand
GROUP misc
REMARKS returns the action of the user
Parameters: -
Returns:    SHORT                        result: USER_OK or USER_CANCEL
*/

/*DOC
CLASS XFileDialog
FUNCTION QueryFileCount
GROUP misc
REMARKS returns the number of files selected
Parameters: -
Returns:    SHORT                        count of files
*/

/*DOC
CLASS XFile
FUNCTION Read
GROUP I/O
REMARKS read from a file
Parameters: PVOID buffer                 pointer to memory
            ULONG size                   count of bytes to read
Returns:    ULONG                        count of bytes which are read
*/


/*DOC
CLASS XFile
FUNCTION Write
GROUP I/O
REMARKS write to a file
Parameters: PVOID buffer                 pointer to memory
            ULONG size                   count of bytes to write
Returns:    ULONG                        count of bytes which are written
*/


/*DOC
CLASS XFile
FUNCTION Close
GROUP open/close
REMARKS close the file
Parameters: -
Returns:    -
*/


/*DOC
CLASS XFile
FUNCTION Remove
GROUP misc
REMARKS delete a file
Parameters: char * path                  the path of the file to delete
Returns:    BOOL                         success
*/


/*DOC
CLASS XFile
FUNCTION QueryPointerPos
GROUP misc
REMARKS returns the position of the file-pointer relative to the beginning of the file
Parameters: -
Returns:    ULONG                        the position
*/


/*DOC
CLASS XFile
FUNCTION Seek
GROUP misc
REMARKS seek in the file
Parameters: ULONG position               position to seek to relative to relPos
            ULONG relPos                 position relative to:
                                             XFILE_BEGIN     relative to the beginning of the file (default)
                                             XFILE_CURRENT   relative to current position
                                             XFILE_END       relative to the end of the file
Returns:    ULONG                        count of bytes which are read
*/

