#include "xentry.h"


void XEntryField :: QuerySelectionBounds( SHORT& start, SHORT& end)
{
   MRESULT res = WinSendMsg( winhandle, EM_QUERYSEL, 0,  0);
   start = SHORT1FROMMR( res );
   end = SHORT2FROMMR( res);
}

void XEntryField :: SetLimit( unsigned short len)
{
  WinSendMsg( winhandle, EM_SETTEXTLIMIT, MPFROMSHORT(len), 0);
}


BOOL XEntryField :: HasChanged(void)
{
  return SHORT1FROMMR(WinSendMsg( winhandle, EM_QUERYCHANGED, 0, 0));
}

XEntryField :: XEntryField( HWND hwnd): XControl( hwnd )
{ ;}

void XEntryField :: EnableOverWrite( BOOL overWrite)
{
  if( overWrite)
     WinSendMsg( winhandle, EM_SETINSERTMODE, MPFROMSHORT( FALSE), 0);
  else
     WinSendMsg( winhandle, EM_SETINSERTMODE, MPFROMSHORT( TRUE), 0);
}



XEntryField :: XEntryField(XWindow * owner, XRect * rec, USHORT id, ULONG style, const char * string): XControl( rec, style|FS_NOBYTEALIGN, owner, string, WC_ENTRYFIELD, id)
{ ;}

void XEntryField :: SelectText( unsigned short start, unsigned short end)
{
  WinSendMsg( winhandle, EM_SETSEL, MPFROM2SHORT (start, end), 0);
}

void XEntryField :: ShowFirstChar( SHORT firstChar)
{  WinSendMsg( winhandle, EM_SETFIRSTCHAR, MPFROMSHORT(firstChar), 0); }



