#include "xheaders.h"

#include XControl_i
#include XRect_i
#include XPushButton_i
#include XDragHandler_i
#include XDragEvent_i
#include XMouseHandler_i
#include XMouseEvent_i
#include XFrame_i

#include <string.h>
#include <stdio.h>


MRESULT HandleDefault( XWindow * w, ULONG msg, MPARAM mp1, MPARAM mp2, BOOL& handled);


MRESULT ControlProc(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2)
{
   XControl * w = (XControl*) WinQueryWindowPtr( hwnd, 0);

   if( msg == WM_QUERYFRAMECTLCOUNT || msg == WM_FORMATFRAME )
     {
        XFrame * frameWin = (XFrame*) w;
        return frameWin->HandleMessage(msg, mp1, mp2);
     }

   if( w )
      {
          BOOL handled = FALSE;
          MRESULT mr = HandleDefault( w, msg, mp1, mp2, handled);

          if( handled )
             return mr;

          return w->oldfunc( hwnd, msg, mp1, mp2);
      }
   else
      return WinDefWindowProc( hwnd, msg, mp1, mp2);
}


XControl :: XControl ( HWND hwnd)
{
   winhandle = hwnd;
   WinSetWindowPtr(winhandle, 0, this);
   oldfunc = WinSubclassWindow(hwnd, (PFNWP) ControlProc);
}


typedef struct _FORECOLORPARAM
{
   ULONG   id;
   ULONG   cb;
   ULONG   ulColor;
} FORECOLORPARAM;


typedef struct _FONTPARAM
{
   ULONG   id;
   ULONG   cb;
   CHAR    szFontNameSize[20];
} FONTPARAM;


struct  _PRES                           // pres. params
{
   ULONG   cb;                         // length
   FORECOLORPARAM fcparam;             // foreground color
   FONTPARAM      fntparam;            // font name & size
}    pres;


XControl :: XControl( XRect * rec, ULONG style, XWindow * ow, const char * string, PSZ cl, USHORT id)
{
  HWND hwnd=0;
  char * s = (char*) string;
  if( ow)
     hwnd = ow->GetHandle();

  void * p = NULL;

  if( cl == WC_BUTTON && (style & BS_BITMAP || style & BS_ICON || style & BS_MINIICON))
     {
        pres.fcparam.id = PP_FOREGROUNDCOLORINDEX;
        pres.fcparam.cb = sizeof ( pres.fcparam.ulColor );
        pres.fcparam.ulColor = 16;

        pres.fntparam.id = PP_FONTNAMESIZE;
        pres.fntparam.cb = 20;
        strcpy ( pres.fntparam.szFontNameSize, "7.Helv" );

        pres.cb = sizeof ( pres.fcparam ) + sizeof ( pres.fntparam );
        p = (void*) &pres;
        char ti[50];
        if(style & BS_TEXT)
          sprintf( ti, "#%i\t%s", id, string);
        else
          sprintf( ti, "#%i", id);
        s = ti;
     }
  winhandle = WinCreateWindow(hwnd, cl, (PSZ) s, style, rec->x, rec->y, rec->cx, rec->cy, hwnd, HWND_TOP, id, NULL, p);
  WinSetWindowPtr(winhandle, 0, this);
  oldfunc = WinSubclassWindow(winhandle, (PFNWP) ControlProc);

  if(ow)
    WinPostMsg( hwnd, OOL_ADDCLIENT, (MPARAM) winhandle, 0);
}

