#include "xheaders.h"

#include XContainerInfo_i
#include XContainerObject_i
#include XString_i
#include XContainerControl_i
#include XContainerColumn_i
#include XDate_i
#include XTime_i

#include "string.h"


XContainerColumn :: ~XContainerColumn()
{
  if(owner && info)
     WinSendMsg(owner->GetHandle(), CM_FREEDETAILFIELDINFO, MPARAM(info), MPFROMSHORT(1));
}


/*DOC
CLASS XContainerColumn
FUNCTION XContainerColumn
REMARKS If a container should be displayed in detail-mode you must add columns to it. Therfore
you construct one or more XContainerColums, add these with XContainerControll::AddColumn
and finaly call XContainerControll::UpdateColumns.

Parameters:    XContainerControl  * theOwner   the owner of the column
Parameters:    void * theTitle                 the title of the column, the parameter can be a
                                               pointer to a string or contain a handle for a
                                               bitmap or icon
Parameters:    SHORT dataColumn                a zero-based index which points to the data-column
                                               which will be used in XContainerObject::SetColumnData()

Parameters:
<HTML>
<TABLE COLS=2>
LONG dataSettings               Information about the datas in the column

                                               <TABLE COLS = 2>
                                                   COL_LEFT            field is left-justified
                                                   COL_RIGHT           field is right-justified
                                                   COL_CENTER          field is horizontal centered
                                                   COL_TOP             field is top-justified
                                                   COL_VCENTER         field is vertictal centered
                                                   COL_BOTTOM          field is bottom-justified
                                                   COL_INVISIBLE       the column is invisible
                                                   COL_SEPARATOR       vertical separator
                                                   COL_HORZSEPARATOR   horizontal separator
                                                   COL_BITMAPORICON    the data contain a handle to a bitmap/icon
                                                   COL_STRING          the data contain a string
                                                   COL_DATE            the data contain a date
                                                   COL_TIME            the data contain a time-value
                                                   COL_ULONG           the data contain a ULONG value
                                                   COL_FIREADONLY      datas are readonly
                                               </TABLE><BR>
                                               Can be or-ed;
               LONG titleSettings              Information about the title of the column

                                                   COL_LEFT            title is left-justified
                                                   COL_RIGHT           title is right-justified
                                                   COL_CENTER          title is horizontal centered
                                                   COL_TOP             title is top-justified
                                                   COL_VCENTER         title is vertictal centered
                                                   COL_BOTTOM          title is bottom-justified
                                                   COL_SEPARATOR       vertical separator
                                                   COL_HORZSEPARATOR   horizontal separator
                                                   COL_BITMAPORICON    the title contain is a bitmap/icon
                                                   COL_FTITLEREADONLY  title is readonly

                                               Can be or-ed;<BR>
               LONG widthOfColumn              the width of the column in window-pixel. If zero
                                               the width of the column is set dynamicaly.
                                               Default is zero.
</TABLE>
</HTML>
*/

XContainerColumn :: XContainerColumn( XContainerControl * ow, void * titleData, SHORT dataColumn, LONG dataSettings, LONG titleSettings, LONG width)
{
  owner = ow;
  info = (FIELDINFO*) WinSendMsg( owner->GetHandle(), CM_ALLOCDETAILFIELDINFO, MPFROMSHORT(1), 0);

  info->flData = dataSettings;
  info->flTitle = titleSettings;
  info->offStruct = sizeof(RECORDCORE) + dataColumn * 4 + sizeof(void*);
  info->pUserData = this;
  if( width > 0)
     info->cxWidth = width;
  info->pTitleData = titleData;
}


void XContainerColumn :: SetTitleData( void * p)
{
  info->pTitleData = p;
}

void XContainerColumn :: SetTitleAttributes( LONG attr )
{
  info->flTitle = attr;
}


void XContainerColumn :: SetDataAttributes( LONG attr )
{
  info->flData = attr;
}


LONG XContainerColumn :: QueryDataAttributes( void )
{
  return info->flData;
}


LONG XContainerColumn :: QueryTitleAttributes( void )
{
  return info->flTitle;
}


void * XContainerColumn :: QueryTitleData( void )
{
  return info->pTitleData;
}


XContainerColumn * XContainerColumn :: GetNetxColumn( void )
{
  if( info->pNextFieldInfo)
     return (XContainerColumn*) info->pNextFieldInfo->pUserData;
  else
     return NULL;
}


XContainerObject :: ~XContainerObject()
{
}


OOL_ICONHANDLE XContainerObject :: QueryIconHandle( void )
{
   return core->hptrIcon;
}


OOL_BITMAPHANDLE XContainerObject :: QueryBitmapHandle( void )
{
   return core->hbmBitmap;
}


XContainerObject :: XContainerObject( XContainerControl * owner, SHORT columns)
{
   core = (RECORDCORE*) WinSendMsg(owner->GetHandle(), CM_ALLOCRECORD, MPFROMLONG(sizeof(void*) + columns * sizeof(void*)), MPFROMSHORT(1));
   RECORDCORE * pr = (RECORDCORE *) ((PBYTE) core + sizeof(RECORDCORE));
   void * pp = this;
   memcpy(pr, &pp, sizeof(void*));
}


void XContainerObject :: SetColumnData( SHORT column, char * data)
{
   char * b = (char *) ((PBYTE) core + sizeof(RECORDCORE) + sizeof(void*) + column * sizeof(void*));
   memcpy( b, &data, sizeof(PVOID));
}


void XContainerObject :: SetColumnData( SHORT column, LONG data)
{
   char * b = (char *) ((PBYTE) core + sizeof(RECORDCORE) + sizeof(void*) + column * sizeof(void*));
   memcpy(b, &data, sizeof(LONG));
}


void XContainerObject :: SetColumnData( SHORT column, XDate * data)
{
   char * b = (char *) ((PBYTE) core + sizeof(RECORDCORE) + sizeof(void*) + column * sizeof(void*));
   memcpy(b, &data->d, sizeof(LONG));
}


void XContainerObject :: SetColumndata( SHORT column, XTime * data)
{
   char * b = (char *) ((PBYTE) core + sizeof(RECORDCORE) + sizeof(void*) + column * sizeof(void*));
   memcpy(b, &data->t, sizeof(LONG));
}


void XContainerObject :: SetIconHandle( OOL_ICONHANDLE handle)
{
  core->hptrMiniIcon = core->hptrIcon = handle;
}


void XContainerObject :: SetBitmapHandle( OOL_BITMAPHANDLE handle)
{
  core->hbmBitmap = handle;
}


void XContainerObject :: SetTitle( char * t)
{
   core->pszIcon = core->pszName = core->pszTree = core->pszText = (PSZ) t;
}


LONG XContainerObject :: QueryEmphasis( void )
{
  return core->flRecordAttr;
}


void XContainerObject :: QueryTitle( XString * s)
{
   char * b = s->GetBuffer( strlen( (char*) core->pszIcon) + 1);
   strcpy( b, (char*) core->pszIcon);
}


SHORT EXPENTRY SortRecord( PRECORDCORE p1, PRECORDCORE p2, void * p3)
{
   XContainerObject * obj1, *obj2;

   PRECORDCORE pr = (PRECORDCORE) ((PBYTE) p1 + sizeof(RECORDCORE));
   memcpy(&obj1, pr, 4);

   pr = (PRECORDCORE) ((PBYTE) p2 + sizeof(RECORDCORE));
   memcpy(&obj2, pr, 4);

   return obj1->Sort( obj2 );
}


/*DOC
CLASS XContainerInfo
FUNCTION XContainerInfo
GROUP constructors/destructors
REMARKS constructor of XContainerInfo

Parameters:    char * theTitle           The title of the container.
                                         Default is empty.
               LONG theStyle             style of the container. Valid styles are:

                                             CO_TEXT                  the container is in text-mode
                                             CO_NAME                  the container is in name-mode
                                             CO_ICON                  the container is in icon-mode
                                             CO_DETAIL                the container is in detail-mode

                                             CO_FLOW                  arrange objects dynamicaly (text and
                                                                      name mode only)
                                             CO_MINI                  the container use small icons
                                             CO_TREE                  the container is in tree-mode
                                             CO_OWNERPAINTBACKGROUND  the owner will draw the background
                                                                      (see XBackgroundDrawEvent and
                                                                       XBackgroundDrawHandler)
                                             CO_TREELINE              draw the tree-line in tree-mode
                                             CO_DRAWBITMAP            draw icons
                                             CO_DRAWICON              draw bitmaps

                                             CO_TITLE                 show the container-title
                                             CO_TITLELEFT             title is left-justified
                                             CO_TITLERIGHT            title is right-justified
                                             CO_TITLECENTER           title is centered
                                             CO_TITLESEPARATOR        the title is drawn with a separator
                                             CO_TITLEREADONLY         the title cannot been edited by the user

                                             CO_DETAILTITLES          in detail-mode the titles of XContainerColumn
                                                                      are shown
                                         The attributes can be or-ed
                                         Default is CO_ICON.
Returns:     -
*/
XContainerInfo :: XContainerInfo( char * title, LONG style)
{
   memset( &cnrinfo, 0, sizeof(cnrinfo));
   changes = 0;

   if( title)
      SetTitle( title );
   if( style )
      SetAttributes( style );
}


/*DOC
CLASS XContainerInfo
FUNCTION EnableSorting
Enables sorting records when they are inserted.

Parameters:    BOOL sort                 Set TRUE if the container items should be sorted
                                         when they are inserted. Therefor you must override the
                                         method XContainerObject::Sort.
                                         Default is TRUE.
Returns:       -
*/
void XContainerInfo :: EnableSorting( BOOL enable)
{
   if( enable )
      cnrinfo.pSortRecord = (void*) SortRecord;
   else
      cnrinfo.pSortRecord = NULL;
   changes |= CMA_PSORTRECORD;
}


/*DOC
CLASS XContainerInfo
FUNCTION SetAttributes
GROUP set/query attributes
REMARKS specify here how the container should be displayed. After you have set
up the XContainerInfo use XContainerColumn::SetInfo()

Parameters:   LONG newAttributes         attributes how the container should be
                                         displayed ( see XContainerInfo() )
Returns:      -
*/
void XContainerInfo :: SetAttributes( LONG attribute )
{
   cnrinfo.flWindowAttr = attribute;
   changes |= CMA_FLWINDOWATTR;
}


/*DOC
CLASS XContainerInfo
FUNCTION SetTitle
GROUP set/query container title
REMARKS specify here the title of the container. After you have set
up the XContainerInfo use XContainerColumn::SetInfo()

Parameters:    char * theTitle
Returns:       -
*/
void XContainerInfo :: SetTitle( char * t )
{
   cnrinfo.pszCnrTitle = (PSZ) t;
   changes |= CMA_CNRTITLE;
}


/*DOC
CLASS XContainerInfo
FUNCTION SetSplitbarColumn
GROUP splitbar
REMARKS You can set a splitbar in a container. When you have used this function
call XContainerControl::SetInfo() to actualize the container

Parameters:    XContainerColumn * theColumn    the XContainerColumn after that the splitbar
                                               will be displayed
Returns:       -
*/
void XContainerInfo :: SetSplitbarColumn( XContainerColumn * col)
{
  cnrinfo.pFieldInfoLast = col->info;
  changes |=  CMA_PFIELDINFOLAST;
}


/*DOC
CLASS XContainerInfo
FUNCTION QueryAtrtributes
GROUP set/query container title
REMARKS Use XContainerColumn::QueryInfo() to get information about the
container. With QueryAttributes() you get the attributes of the container.

Parameters:    -
Returns:       LONG  theAttributes       the attributes which are set for the
                                         container (can be or-ed). See XContainerInfo()
*/
LONG XContainerInfo :: QueryAttributes( void )
{
   return cnrinfo.flWindowAttr;
}


/*DOC
CLASS XContainerInfo
FUNCTION QueryTitle
GROUP set/query containertitle
REMARKS Use XContainerColumn::QueryInfo() to get information about the
container. With QueryTitle() you  get the title of the container

Parameters:    XString * theTitleBuffer    here the title will be stored
Returns:       -
*/
void XContainerInfo :: QueryTitle( XString * s )
{
   char * b = s->GetBuffer(strlen((char*) cnrinfo.pszCnrTitle) + 1);
   strcpy( b, (char*) cnrinfo.pszCnrTitle);
}


/*DOC
CLASS XContainerInfo
FUNCTION SetSplitbarPos
GROUP splitbar
REMARKS You can set the position of the splitbar of a container. When you have used this
function call XContainerControl::SetInfo() to actualize the container

Parameters:    LONG position             the position in window-pixels
Returns:       -
*/
void XContainerInfo :: SetSplitbarPos( LONG pos )
{
   changes|= CMA_XVERTSPLITBAR;
   cnrinfo.xVertSplitbar = pos;
}


/*DOC
CLASS XContainerInfo
FUNCTION QuerySplitbarPos
GROUP splitbar
REMARKS You can query the position of the splitbar of a container. Before you use
this function call XContainerControl::QueryInfo() to get the actual settings
of the container

Parameters:    -
Returns:       LONG         the position in window-pixels
*/

LONG XContainerInfo :: QuerySplitbarPos( void )
{
   return cnrinfo.xVertSplitbar;
}


void XContainerInfo :: SetBitmapSize( SHORT size)
{
   changes |= CMA_SLBITMAPORICON;
   cnrinfo.slBitmapOrIcon.cx = cnrinfo.slBitmapOrIcon.cy = size;
}


SHORT XContainerInfo :: QueryBitmapSize( void)
{
   return cnrinfo.slBitmapOrIcon.cx;
}

