#ifndef __OOL_XMLE_H__
#define __OOL_XMLE_H__

/*===========================================================================*/
/* OOL ------------------- the Open Object Library ------ OS/2 version 0.01a */
/*===========================================================================*/
/*                              class: XMultiLineEdit                        */
/*                       derived from: XControl                              */
/*                              class: XMLESearch                            */
/*                       derived from: XControl                              */
/*                        last update: 5/96                                  */
/*                      programmed by: Stefan von Brauk                      */
/*===========================================================================*/

#include "xcontrol.h"

#ifdef OOL_FOR_OS2_X86
   #define MLE_BORDER      0x0002
   #define MLE_READONLY    0x0010
   #define MLE_WORDWRAP    0x0001
   #define MLE_HORZSCROLL  0x0008
   #define MLE_VERTSCROLL  0x0004
   #define MLE_IGNORETAB   0x0020
   #define MLE_DISABLEUNDO 0x0040
#endif


class XString;


class _export_ XMLESearch: public XObject
{
      friend class XMultiLineEdit;
   private:
      MLE_SEARCHDATA sStruct;
      LONG mode;
   public:
      XMLESearch();
      ~XMLESearch();
      LONG GetStartPoint(void);
      void QueryReplaceItem( XString * s);
      void QuerySearchItem( XString * s);
      void SetCaseSensitive( BOOL sensitive = TRUE);
      void SetSearchEndPoint( LONG );
      void SetSearchItem( char * );
      void SetSearchStartPoint( LONG );
      void SetReplaceAll( BOOL replace = TRUE);
      void SetReplaceItem( char * );
};


class _export_ XMultiLineEdit: public XControl{
      friend class XFrameWindow;
   private:
      XMultiLineEdit(HWND hwnd);
   public:
      XMultiLineEdit(XWindow * owner, XRect * rec,  USHORT id = 0, ULONG style=MLE_BORDER|MLE_WORDWRAP|WIN_VISIBLE, const char * title = "");
      virtual ~XMultiLineEdit() {;}
      BOOL CanUndo( void );
      void EnableOverWrite( BOOL overWrite = TRUE);
      BOOL HasChanged( void );
      void InsertString( const char * p);
      void QuerySel(LONG& start, LONG& end);
      LONG QueryTextLength( void);
      BOOL Search ( XMLESearch * s);
      void SelectText( unsigned short start, unsigned short end);
      void SetLimit( USHORT len);
      void SetSel( LONG from, LONG to);
      void ShowFirstChar( SHORT firstChar = 0);
      BOOL Undo( void );
};


#endif
