#ifndef __OOL_XLISTBOX_H__
#define __OOL_XLISTBOX_H__

/*===========================================================================*/
/* OOL ------------------- the Open Object Library ------ OS/2 version 0.01a */
/*===========================================================================*/
/*                              class: XListBox                              */
/*                       derived from: XControl                              */
/*                        last update: 4/96                                  */
/*                      programmed by: Stefan von Brauk                      */
/*===========================================================================*/


#include "xcontrol.h"


#ifdef OOL_FOR_OS2_X86
   #define LS_NONE          -1
   #define LS_FIRST         -1
   #define LS_LAST          -1
   #define LS_ASCENDING     -2
   #define LS_DESCENDING    -3
   #define LS_PREFIX        0x0002
   #define LS_CASESENSITIVE 0x0004
   #define LS_SUBSTRING     0x0001
   #define LS_SCROLL        LS_HORZSCROLL
   #define LS_MULTI         LS_MULTIPLESEL
   #define LS_EXTENDED      LS_EXTENDEDSEL
#endif

class _export_ XListBox: public XControl
{
      friend class XFrameWindow;
   protected:
      XListBox( HWND hwnd);
      XListBox(XRect * rec, ULONG style, XWindow * owner, USHORT id, PSZ className);
   public:
      XListBox(XWindow * owner, XRect * rec, USHORT id = 0, ULONG style = WIN_VISIBLE);
      virtual ~XListBox() {;}
      SHORT InsertItem( const char * item, SHORT pos = LS_LAST);
      SHORT QueryCount(void);
      LONG QueryItemHandle( SHORT pos);
      SHORT QueryItemText( SHORT pos, XString * buffer);
      SHORT QuerySelection( SHORT start = LS_FIRST);
      BOOL RemoveAll(void);
      void RemoveItem( SHORT pos);
      SHORT SearchString ( const char * p, SHORT start=LS_FIRST, SHORT matchCode=LS_CASESENSITIVE);
      BOOL SelectItem( SHORT pos, BOOL select = TRUE);
      BOOL SetItemHandle(SHORT pos, LONG handle);
      BOOL SetItemText(SHORT pos, const char * p);
};

#endif
