#ifndef __OOL_XGRAPHICOBJ_H__
#define __OOL_XGRAPHICOBJ_H__

/*===========================================================================*/
/* OOL ------------------- the Open Object Library ------ OS/2 version 0.01a */
/*===========================================================================*/
/*                              class: XGraphicObject                        */
/*                       derived from: XObject                               */
/*                        last update: 7/96                                  */
/*                      programmed by: Stefan von Brauk                      */
/*===========================================================================*/



#include "xpoint.h"
#include "xobject.h"
#include "XColor.h"

#define GO_HIDE 1


class XGraphicDevice;
class XRect;

#define GO_HIDE 1


class _export_ XGraphicObject: public XObject
{
      friend XGraphicDevice;
   protected:
      XGraphicObject * next;
      XGraphicDevice * dev;
      CHAR lineEnd;
      CHAR lineJoin;
      SHORT lineWidth;
      XColor color;
      XPoint p;
      char settings;
      virtual BOOL HitTest( LONG x, LONG y) { return FALSE;}
      XGraphicObject();
   public:
      XGraphicObject( XGraphicDevice*, XPoint * p = NULL);
      XGraphicObject( XGraphicDevice*, LONG x, LONG y) { p.p.x = x; p.p.y = y; }
      virtual ~XGraphicObject();
      virtual void Draw( XRect * r = NULL) { ;}
      void GetColor( XColor * c) { memcpy( &c->color, &color.color, 3); }
      void GetPos( XPoint * point) { point->p = p.p; }
      void Move( XPoint * point) { p.p = point->p; }
      void SetColor( XColor * c) { memcpy( &color.color, &c->color, 3); }
      virtual void SetupDevice ( void );
      void Show( BOOL show = TRUE );
};

#endif
