/* VBPRINT.DLL v2.0 Last Updated 05-30-1996 by Robert Simpson
	This version designed for 16-bit Windows apps.

	NOTES
	This program, though designed for Win3.x will work properly
	with the expanded DEVMODE structure in Windows 95 and/or Win NT.
	However, if you wish to access any of the extra items in the Win95
	DEVMODE structure, I highly recommend using the full 32-bit version
	of this DLL.

	The sample programs, DLL files and all source code have been released
	to the public domain.

	This DLL was written and compiled in Borland C++ 4.5
*/

#include <windows.h>
#include <string.h>
#include <stdio.h>
#include "vbapi.h"
#include <stdlib.h>
#include <math.h>
#include <ctype.h>
#include <dos.h>
#include <print.h>

/*  Exported Functions are listed below, here are the proper VB declares:

Declare Function VBGetPrinters		  Lib "vbprint.dll" () As String
Declare Function VBGetDriverFromName  Lib "vbprint.dll" (printername As String) As String
Declare Function VBSetDefPrinter		  Lib "vbprint.dll" (printername As String) As Integer
Declare Function VBGetDefPrinter		  Lib "vbprint.dll" () As String
Declare Function VBExtDeviceMode		  Lib "vbprint.dll" (ByVal hWnd As Integer, printername As String, inDev As DEVMODE_TYPE, outDev As DEVMODE_TYPE, ByVal fMode As Integer) As Integer
Declare Function VBDevModeToStr		  Lib "vbprint.dll" (inDev As DEVMODE_TYPE) As String
Declare Function VBStrToDevMode		  Lib "vbprint.dll" (dmString As String, outDev As DEVMODE_TYPE) As Integer
Declare Function VBDeviceCapabilities Lib "vbprint.dll" (printername As String, ByVal iCap As Integer, lpStr As Any, inDev As DEVMODE_TYPE) As Long
Declare Function VBResetDC            Lib "vbprint.dll" (ByVal hDC As Integer, outDev As DEVMODE_TYPE) As Integer

' Here is the VB DEVMODE that should be used in all calls to this DLL requiring a DEVMODE structure:

Type DEVMODE_TYPE
  dmDeviceName As String * 32
  dmSpecVersion As Integer
  dmDriverVersion As Integer
  dmSize As Integer
  dmDriverExtra As Integer
  dmFields As Long
  dmOrientation As Integer
  dmPaperSize As Integer
  dmPaperLength As Integer
  dmPaperWidth As Integer
  dmScale As Integer
  dmCopies As Integer
  dmDefaultSource As Integer
  dmPrintQuality As Integer
  dmColor As Integer
  dmDuplex As Integer
  dmYResolution As Integer
  dmTTOption As Integer
  dmPrivate As String
End Type

'  The DEVMODE_TYPE structure in VB is essentially a base DEVMODE structure with a dynamic
'  string attached to the end (the C version is directly below, named VBDEVMODE) which
'  holds the printer's private data (if there is any).
*/


#define PRINTERLIST 2048 // Size of the buffer that holds the available printers

struct VBDEVMODE      // The C equivilent to the VB DEVMODE_TYPE structure above
{
  DEVMODE dm;        // The size of the DEVMODE structure is larger in Win95 than in Win31
  HLSTR dmPrivate;   // To compensate for size differences, this dmPrivate area holds the extra data
};                   // required by Win95 and by the specific printer driver (if it DOES require anything).

// Exported functions
HLSTR FAR PASCAL _export VBGetPrinters();
HLSTR FAR PASCAL _export VBGetDriverFromName(HLSTR printername);
int   FAR PASCAL _export VBSetDefPrinter(HLSTR);
HLSTR FAR PASCAL _export VBGetDefPrinter();
int   FAR PASCAL _export VBExtDeviceMode(HWND,HLSTR,struct VBDEVMODE *,struct VBDEVMODE *,WORD);
HLSTR FAR PASCAL _export VBDevModeToStr(struct VBDEVMODE *);
int   FAR PASCAL _export VBStrToDevMode(HLSTR,struct VBDEVMODE *);
long  FAR PASCAL _export VBDeviceCapabilities(HLSTR,WORD,LPSTR,struct VBDEVMODE *);
int   FAR PASCAL _export VBResetDC(HDC, struct VBDEVMODE *);

// Internal functions
int      GetDriverFromName(HLSTR,char *,char *,char *);
DEVMODE *GetVBDevMode(struct VBDEVMODE *);
void     SetVBDevMode(DEVMODE *,struct VBDEVMODE *);

typedef int (FAR PASCAL *ExtDeviceMode)(HWND,HANDLE,LPDEVMODE,LPSTR,LPSTR,LPDEVMODE,LPSTR,WORD);
typedef DWORD (FAR PASCAL *DevCaps)(LPSTR,LPSTR,WORD,LPSTR,LPDEVMODE);

/* This function works similar to the VB Dir$() function.  The first time it is
	called, it retrieves the list of installed printers and returns them one at a
	time to VB.  Each call returns the next installed printer.  A NULL return value
	indicates the end of the list. */
HLSTR FAR PASCAL _export VBGetPrinters()
{
  static int prevcall;
  static char printers[PRINTERLIST];
  static char buff[256];
  char printer[64];
  char *driver;
  char *port;
  char output[128];
  char *port2;

  if (*printers == 0)
	 {
		if (prevcall == 1)
		  {
			 prevcall = 0;
			 return 0;
		  }
		prevcall = 1;
		GetProfileString("devices",NULL,"",printers,PRINTERLIST);
	 }
  if (buff[0] != 0)
	 {
		port = strchr(buff,',');
		if (port == 0) return 0;
		*port = 0;
		port ++;
		strncpy(printer,buff,(int)(port-buff));
		printer[(int)(port-buff)] = 0;
		driver = strchr(port,',');
		if (driver == 0) return 0;
		driver[0] = 0;
		sprintf(output,"%s on %s",printer,port);
		memmove(buff,driver+1,sizeof buff-(int)(driver-buff));
	 }
  else
	 {
		strcpy(printer,printers);
		GetProfileString("devices",printer,"",output,sizeof output);
		driver = strtok(output,",");
		port = strtok(NULL,",");
		port2 = strtok(NULL,",");
		while (port2 != 0)
		  {
			 strcat(buff,printer);
			 strcat(buff,",");
			 strcat(buff,port2);
			 strcat(buff,",");
			 port2 = strtok(NULL,",");
		  }
		sprintf(output,"%s on %s",printer,port);
		memmove(printers,printers+strlen(printer)+1,PRINTERLIST-(strlen(printer)));
	 }
  return VBCreateTempHlstr(output,strlen(output));
}

/* This function returns the printer driver assigned to the specified printer.
	It's of little use other than reference purposes.  The <printername> VB string
	must follow the format "<printername> on <port>" such as "Epson Stylus COLOR on LPT1:"
	This is the same format that VBGetPrinters() returns the available printers. */
HLSTR FAR PASCAL _export VBGetDriverFromName(HLSTR name)
{
  char pname[80];
  char driver[80];
  char port[80];

  if (GetDriverFromName(name,pname,driver,port) != 0)
	 return VBCreateTempHlstr(driver,strlen(driver));
  return 0;
}

/* Internal function to parse the name of a printer and determine its driver and port.
	The caller provides pointers for the name, driver and port that this function
	will fill in */
int GetDriverFromName(HLSTR name,char *pname,char *pdriver,char *pport)
{
  char printer[128];
  char *port;
  char *driver;
  char iniprinter[128];
  char *found;

  VBGetHlstr(name,printer,128);
  if (strlen(printer) == 0) return 0;
  found = strstr(printer," on ");
  if (found == 0) return 0;
  *found = 0;
  GetProfileString("devices",printer,"",iniprinter,sizeof iniprinter);
  if (iniprinter[0] == 0) return 0;
  driver = strtok(iniprinter,",");
  port = found+4;
  strcpy(pname,printer);
  strcpy(pdriver,driver);
  strcpy(pport,port);
  return -1;
}

/* Sets the default Windows printer. */
int FAR PASCAL _export VBSetDefPrinter(HLSTR printer)
{
  char newprinter[128];
  char port[32];
  char driver[32];
  char name[32];

  if (GetDriverFromName(printer,name,driver,port) == NULL) return 0;

  sprintf(newprinter,"%s,%s,%s",name,driver,port);
  WriteProfileString("windows","device",newprinter);
  return -1;
}

/* Gets the default Windows printer from the INI file and parses it */
HLSTR FAR PASCAL _export VBGetDefPrinter()
{
  char *name;
  char *port;
  char inistring[128];
  char final[128];

  GetProfileString("windows","device","",inistring,sizeof inistring);
  if (inistring[0] == 0) return 0;
  name = strtok(inistring,",");
  port = strtok(NULL,",");
  port = strtok(NULL,",");
  sprintf(final,"%s on %s",name,port);
  return VBCreateTempHlstr(final,strlen(final));
}

/* Converts a VB DevMode structure to one long string so it can be saved to
	disk easier. */
HLSTR FAR PASCAL _export VBDevModeToStr(struct VBDEVMODE *inmode)
{
  DEVMODE *outmode;
  int size;
  HLSTR hlstr;

  size = inmode->dm.dmSize + inmode->dm.dmDriverExtra;
  if (size < 0) return 0;
  if (size == 0) size = sizeof(DEVMODE);
  outmode = GetVBDevMode(inmode);
  if (outmode == 0) return 0;
  hlstr = VBCreateTempHlstr(outmode,size);
  free (outmode);
  return hlstr;
}

/* Converts a string (hopefully created with the VBDevModeToStr() function)
	back to a VB DevMode structure */
int FAR PASCAL _export VBStrToDevMode(HLSTR hlstr,struct VBDEVMODE *outmode)
{
  DEVMODE *inmode;
  int size;

  size = VBGetHlstrLen(hlstr);
  if (size < sizeof (DEVMODE)) return 0;
  inmode = malloc(size);
  if (inmode == 0) return 0;
  VBGetHlstr(hlstr,(char *)inmode,size);
  SetVBDevMode(inmode,outmode);
  return -1;
}

/* Here's the real meat.  Calls the printer's ExtDeviceMode function.  This one function allows you
	to bring up the printer's configuration screen, get a copy of the default config, write out a new
	config and all sorts of other nEeT stuff! */
int FAR PASCAL _export VBExtDeviceMode(HWND hwnd,HLSTR printername,struct VBDEVMODE *indata,struct VBDEVMODE *outdata,WORD mode)
{
  DEVMODE *realoutput = 0;
  DEVMODE *indev = 0;
  char pname[64];
  char pdriver[32];
  char pport[32];
  HANDLE hlib;
  ExtDeviceMode EDM;
  int retval;
  int size;

  if (GetDriverFromName(printername,pname,pdriver,pport) == NULL) return 0;
  strcat(pdriver,".drv");
  hlib = LoadLibrary(pdriver);
  if (hlib < 32) return 0;
  EDM = (ExtDeviceMode)GetProcAddress(hlib,"EXTDEVICEMODE");
  if (EDM == 0)
	 {
		FreeLibrary(hlib);
		return 0;
	 }
  size = EDM(hwnd,hlib,NULL,pname,pport,NULL,NULL,0);
  if (size != 0)
	 {

		realoutput = malloc(size);
		if (indata->dm.dmSize != 0) indev = GetVBDevMode(indata);
		if (realoutput != 0)
		  {
			 retval = EDM(hwnd,hlib,realoutput,pname,pport,indev,NULL,mode);
			 if (retval == 1) SetVBDevMode(realoutput,outdata);
			 FreeLibrary(hlib);
			 return retval;
		  }
		else
		  {
			 if (realoutput != 0) free(realoutput);
			 if (indev != 0) free(indev);
		  }
	 }
  return -1;
}

/* Query the printer device.  This function allows you to get information on paper
	bins, paper sizes, available resolutions and etc from the printer driver. */
long FAR PASCAL _export VBDeviceCapabilities(HLSTR printername,WORD caps,LPSTR output,struct VBDEVMODE *indata)
{
  DEVMODE *indev = 0;
  char pname[64];
  char pdriver[32];
  char pport[32];
  HANDLE hlib;
  DevCaps PDM;
  long retval;

  if (GetDriverFromName(printername,pname,pdriver,pport) == NULL) return 0;
  strcat(pdriver,".drv");
  hlib = LoadLibrary(pdriver);
  if (hlib < 32) return 0;
  PDM = (DevCaps)GetProcAddress(hlib,"DEVICECAPABILITIES");
  if (PDM == 0)
	 {
		FreeLibrary(hlib);
		return 0;
	 }
  if (indata->dm.dmSize != 0) indev = GetVBDevMode(indata);
  retval = PDM(pdriver,pport,caps,output,indev);
  if (indev != 0) free(indev);
  return retval;
}

int FAR PASCAL _export VBResetDC(HDC dc, struct VBDEVMODE *indata)
{
  DEVMODE *indev = 0;
  int retval = 0;

  if (indata->dm.dmSize == 0) return 0;
  indev = GetVBDevMode(indata);
  if (indev != 0) retval = ResetDC(dc,indev);
  if (indev != 0) free(indev);
  return retval;
}

/* Internal function, converts a VBDEVMODE to a regular DEVMODE structure */
DEVMODE *GetVBDevMode(struct VBDEVMODE *inmode)
{
  DEVMODE *outdevmode;
  int extra = 0;
  int size;

  size = inmode->dm.dmSize + inmode->dm.dmDriverExtra;
  extra = inmode->dm.dmSize-sizeof(DEVMODE)+inmode->dm.dmDriverExtra;
  if (size < sizeof(DEVMODE))
  {
	 size = sizeof(DEVMODE);
	 extra = 0;
  }
  outdevmode = malloc(size);
  if (outdevmode == 0) return 0;
  if (extra != 0)
	 VBGetHlstr(inmode->dmPrivate,outdevmode+1,extra);
  memcpy(outdevmode,inmode,sizeof(DEVMODE));
  return outdevmode;
}

/* Internal function, converts a DEVMODE to a VBDEVMODE */
void SetVBDevMode(DEVMODE *inmode,struct VBDEVMODE *outmode)
{
  int extra;

  extra = inmode->dmSize-sizeof(DEVMODE)+inmode->dmDriverExtra;
  if (extra < 0) extra = 0;
  memcpy(outmode,inmode,sizeof(DEVMODE));
  VBSetHlstr(&outmode->dmPrivate,inmode+1,extra);
  free(inmode);
}

