'-----------------------------------------------
'   Subroutine to clear user selections
'-----------------------------------------------
sub ClearPicks()
  for i = 1 to 80
    userPick[i] = 0
  next i
  winners = 0
  return
end sub

'-----------------------------------------------
'   Subroutine to draw control 'buttons'
'-----------------------------------------------
sub drawButtons()
  PenColor 0,155,0
  DrawRect 0,160,200,40,FILLED
  PenColor 0,0,0
  PenWidth 3
  DrawRect 0,160,200,40
  TextColor 0,0,0
  SetFont "Dialog",14
  DrawText "GO!",80,180

  PenColor 0,64,192
  DrawRect 0,200,200,40,FILLED
  PenColor 0,0,0
  PenWidth 3
  DrawRect 0,200,200,40
  TextColor 0,0,0
  SetFont "Dialog",14
  DrawText "Reset",80,220

  return
end sub

'-----------------------------------------------
'   Subroutine to draw the keno board
'-----------------------------------------------
sub drawBoard()

PenWidth 2
i = 1
SetFont "TimesRoman",10
TextColor 255,255,0
for y=1 to 8
  for x = 0 to 9
    'print x,y
    PenColor 255,0,0
    DrawRect x*20,(y-1)*20,20,20,FILLED
    PenColor 0,0,0
    DrawRect x*20,(y-1)*20,20,20
    DrawText i,x*20+5,(y-1)*20+10
    '
    ' now, let's save the xy position for each
    ' square in two varrays for ease of use later
    '
    locX[((y-1)*10)+x+1] = x*20
    locY[((y-1)*10)+x+1] = (y-1)*20
    i = i + 1
  next x
next y
return
end sub

'-----------------------------------------------
'   Subroutine to pick and draw the winners!
'-----------------------------------------------
sub PickWinners()

for j=1 to 20
  picks[j] = 0
next j

nextpick = 1

SetFont "TimesRoman",10

myloop: q=int(rnd()*80)+1
   found = 0

   for j = 1 to 20
     if q = picks[j]
       found = j
     end if
   next j

   if found <> 0
     q = q
   else
     picks[nextpick] = q
     nextpick = nextpick + 1
     if userPick[q] = 0 then
       PenColor 225,228,0
       TextColor 0,0,0
     else
       PenColor 0,0,255
       TextColor 255,255,255
       winners = winners + 1
     endif

     x = locX[q]
     y = locY[q]
     DrawRect x+1,y+1,18,18,FILLED
     DrawText q,x+5,y+10
   end if

   if nextpick <= 20
     goto myloop
   endif

PenColor 255,255,255
DrawRect 0,240,200,20,FILLED
TextColor 0,0,0
DrawText "You Had " ! winners ! " winners!",50,250

end sub


'-----------------------------------------------
'   Subroutine to handle mouse clicks
'-----------------------------------------------
sub mouse_click()

  '
  ' convert the mouse coordinate to 'square' coordinates
  '
  x = int(xparm / 20)+1;
  y = int(yparm / 20)+1;

  '
  ' did the user pick the virtual 'GO' button?
  '
  if (y = 9) | (y = 10) then
    call PickWinners
    return
  endif

  '
  ' did the user pick the virtual 'RESET' button?
  '
  if y >= 11 then
    PenColor 255,255,255
    DrawRect 0,240,200,20,FILLED
    TextColor 0,0,0
    DrawText "HotTEA 2.0 Keno!",50,250
    call drawButtons
    call clearPicks
    call drawBoard
    return
  endif

  'print "click on ",x,",",y

  square = ((y-1)*10)+x
  userPick[square] = 1

  dx = locX[square]
  dy = locY[square]

  PenColor 0,255,0
  DrawRect dx,dy,20,20

end sub

'-----------------------------------------------
'
'   Main program
'
'-----------------------------------------------
sub main()
  PenColor 255,255,255
  DrawRect 0,240,200,20,FILLED
  TextColor 0,0,0
  DrawText "HotTEA 2.0 Keno!",50,250
  call drawButtons
  call clearPicks
  call drawBoard
end sub
