{$M 1024,0,0}
{$R-,S-,I-}
uses dos;

const
  timerint         = $08;
var
  oldtimervec           : procedure;
  {$f+}
  drivestatus           : byte;
  oldchar , oldatr      : byte;
  newstatus , oldstatus : byte;

procedure newtimervec( flags , cs , ip , ax , bx , cx , dx , si , di , ds , es , bp : word ); interrupt;
begin
  drivestatus := mem[ $0040 : $03f ];
  newstatus := drivestatus and 1;

  if ( ( newstatus > 0 ) and ( oldstatus = 0 ) ) then begin
    if ( mem[ $b800 : $0000 ] <> 44 ) then begin
      oldchar := mem[ $b800 : $0001 ];
      oldatr := mem[ $b800 : $0000 ];
    end;
  end;

  if ( ( newstatus > 0 ) and ( oldstatus > 0 ) ) then begin
    memw[ $b800 : $0000 ] := ( drivestatus div 128 ) * 5 + 82 + 44 * 256;
  end;

  if ( ( newstatus = 0 ) and ( oldstatus > 0 ) ) then begin
    mem[ $b800 : $0000 ] := oldatr;
    mem[ $b800 : $0001 ] := oldchar;
  end;

  oldstatus := newstatus;
  inline( $9C );
  oldtimervec;
end;

{$f-}
begin
  oldstatus := mem[ $0040 : $003f ] and 1;
  getintvec( timerint , @oldtimervec );
  setintvec( timerint , @newtimervec );
  keep( 0 );
end.
