#include <stdio.h>
#include <dos.h>
#include <conio.h>
#include <stdlib.h>
#include <io.h>
#include <bios.h>
#include <fcntl.h>
#include <string.h>

short nrecs;
short reclen;

char in_file[16];
char temp_file[16];
char data_in[1000];

main(short argc, char *argv[])
{
FILE *fp;
FILE *fpout;
short cnt;
short stat;

  if(argc != 2)
  {
    printf("Parameter Error or Filename Missing\n");
    return 1;
  }

  strcpy(in_file, argv[1]);
  fp = fopen(in_file, "rb+");
  if(fp == NULL)
  {
    printf("File Not Available - Press a key to continue\n");
    getch();
    fclose(fp);
    return 1;
  }
  get_file_parms(fp);

  strcpy(temp_file, "ptemp.dat");
  fpout = fopen(temp_file, "wb");
  if(fpout == NULL)
  {
    printf("Trouble opening temporary file\n");
    getch();
    fclose(fp);
    fclose(fpout);
    return 1;
  }

  do
  {
    stat = fread(data_in, reclen, 1, fp);

    cnt++;
    if(data_in[0] != '!')
    {
      stat = fwrite(data_in, reclen, 1, fpout);
    }
    if(feof(fp))
      break;
  }
  while(cnt < nrecs);

  fclose(fp);
  if(fclose(fpout)==0)
  {
    remove(in_file);
    rename(temp_file, in_file);
    return 0;
  }
  return 1;
}


/* This routine figures no. of records based of length of first record */
/* by how many characters to the Linefeed and then divides filesize by */
/* record length obtaining number of records */

get_file_parms(fp)
FILE *fp;
{
fpos_t position;
char chr;

  nrecs = 0;
  reclen = 0;
  fseek(fp, 0L, SEEK_SET);
  do
  {
    chr = fgetc(fp);
    if(chr == EOF)
      break;
    reclen++;
  }
  while(chr != 10);

  nrecs = (short) (filelength(fileno(fp)) / reclen);
  fseek(fp, 0L, SEEK_SET);
}

