#include "\c\window\window.h"
#include "\c\window\mouse.h"
#include "\c\window\keyboard.h"
#include "\c\window\defaults.h"
#include "\c\window\field.h"
#include "\c\window\controls.h"
#include "\c\window\wgraphic.h"
#include "\c\window\winvars.h"

#include <conio.h>
#include <stdlib.h>
#include <stdio.h>
#include <io.h>
#include <dos.h>
#include <bios.h>
#include <fcntl.h>
#include <string.h>
#include <malloc.h>
#include <memory.h>
#include <graphics.h>
#include <process.h>

#define AALPHA '@'
#define FFILE '|'
#define PPROTECTED '!'
#define NNUMERIC '#'
#define DUPLICATE '~'


#if ! defined(FA_NORMAL)
   #define FA_NORMAL 0
#endif
/*
L T T T T T --+-T--2----T----3--T-+----4T---+---T5----+-T--6----T----7--T-+--R
*/

Window de_window;

char ms_mask[] =
 "_________________________________________________________________________";

char cats[15][40];
FILE *ffp;
char line[2000];
short px, py;
short xoffset, yoffset;
short floodx, floody;

struct pcxx
{
char mfg;
char version;
char encoding;
char bpp;
short xmin, ymin;
short xmax, ymax;
short hres;
short vres;
char palette[48];
char res;
char color_p;
short bytes_per_line;
short pal_type;
char filler[58];
} p;

struct filearea
{
  short reclen;
  short nrecs;
} farea;

short recno;
short Colr;

FILE *fdata;
FILE *fscrn;

short file_present;
short fname_pos;

short ddsize;

struct dditem
{
  short col;
  short row;
  Field field; 
  char prompt[70];
  char mask[70];
  char data[70];
  short dpos;
  short dlen;
};

#define DARSIZE 154

struct darray
{
  struct dditem root[DARSIZE];
};

struct darray datadef;


char tbufr[1000];

void interrupt (far *int_timer) (void);
static void interrupt timer_svc(void);

void buffer_save();
char dataname[18];
char edtname[18];
char catname[18];
char cfgname[18];

void quit();
short Checksum;
short Edt_pos;
short rtcode = 1;


main(int argc, char *argv[])
{
char fname[18];
char scrnname[18];
short cnt;
short stat;
short type;
Mouse_State mstate;
Window tmp_window;
static Window de1_window;
Defaults def;

/*  exitmsg(); */

  atexit(quit);

  disable();
  int_timer = getvect(0x1c);
  enable();

  def = d_get();
  d_change(SYSENV, DISABLE);
  load_color();

  if(d_vidtype() < 6)
    d_colorset(WHITE+BRIGHT, COLOR(Colr, WHITE+BRIGHT),
      COLOR(BLACK, WHITE+BRIGHT),
      COLOR(WHITE+BRIGHT, Colr),
      COLOR(WHITE+BRIGHT, Colr),
      COLOR(WHITE+BRIGHT, Colr),
      COLOR(BLACK, BLACK));

  if(d_vidtype() < 6)
  {
    d_change(SYSWRTMODE, GRAPH16);
    d_biosfont(14);
  }
  else
  {
    d_change(SYSWRTMODE, HERC43);
    d_font8x8();
  }
  s_open();
//  {
//    printf("Mouse not available");
//  sleep(5);
//  d_put(def);
//  return;
//}          

  k_idle(buffer_save);
  ddsize = 0;
  recno = 1;
  file_present = 0;
  fname_pos = 0;
  Checksum = 0;
  Edt_pos = -1;

  if(argc>1)
    strcpy(fname, argv[1]);
  else
  {
    d_put(def);
    fname[0] = 0;  
    printf("DEG:  (C) 1994 Daniel Bingamon - Kadima Technology\n");
    printf("Fixed File Data Entry Software\n");
    s_close();
    return;
  }

  if(argc>2)
    strcpy(scrnname, argv[2]);
  else
    strcpy(scrnname, fname);

  strcpy(catname, scrnname);
  strcpy(cfgname, scrnname);
  strcpy(edtname, scrnname);
  strcat(edtname, ".POS");

  load_edtpos();

  strcat(scrnname, ".SCN");
  strcat(catname, ".CAT");
  strcat(cfgname, ".CFG");

  strcpy(dataname, fname);

  if(strstr(dataname, ".")==NULL)
    strcat(dataname, ".DAT");

  fscrn = fopen(catname, "r");
  rd_cat();
  load_cfg();
  fclose(fscrn);

  fscrn = fopen(scrnname, "rb");
  if(fscrn==NULL)
  {
    error_window("Screen not found");
    s_close();
    d_put(def);
    return;
  }

  de1_window = w_open(1, 1, 78, 23);
  de_window = de1_window;
  if(de_window == NULL)
  {
    fclose(fscrn);
    s_close();
    printf("array %u\n", sizeof(struct darray));
    printf("Window init error\n");
    d_put(def);
    return;
  }

  for(cnt=0;cnt<999;cnt++)
    tbufr[cnt] = 0;

  rd_scrn();

  fclose(fscrn);


  fdata = fopen(dataname, "rb");
  fclose(fdata);
  if(fdata==NULL)
  {
    sound(440, 2);
    fdata = fopen(dataname, "wb+");
    if(fdata==NULL)
    {
      error_window("Data File Open Error");
      w_closeall();
      s_close();
      d_put(def);
      return;
    }
    farea.nrecs = 1;
    fb_rec(1);
    fclose(fdata);
    recno = 0;
  }
  else
    recno = 1;
  fdata = fopen(dataname, "rb+");
  if(fdata==NULL)
  {
    error_window("Data File Open Error");
    w_closeall();
    s_close();
    d_put(def);
    return;
  }

  farea.nrecs = (short) (filelength(fileno(fdata)) / farea.reclen);

  s_wlimit(de_window);
  edit();
  s_wlimit(NULL);
  fclose(fdata);
  w_closeall();
  s_close();
/*  d_graphic_blink(0, 0);  */
  d_change(SYSWRTMODE, GRAPH16);
  d_put(def);
  poscurs(23,1);
  curson();
  exit(rtcode);
}


quit()
{
/*   d_graphic_blink(0, 0); */
  w_closeall();
  disable();
  setvect(0x1c, int_timer);
  enable();
}


rd_scrn()
{
short reclen;
short stat;
char temp[10]; 
short ct;

  reclen = 0;
  do
  {
    temp[0] = 0;
    if(fscanf(fscrn, "%s", temp)!=1)
      break;

    if(strncmp(temp, "-1", 2)==0)
      break;

    if(temp[0]=='P') 
    {
      sscanf(&temp[1], "%d", &datadef.root[ddsize].col);
    }
    else
    {
      sscanf(temp, "%d", &datadef.root[ddsize].col);
    }
    if(fscanf(fscrn, "%d", &datadef.root[ddsize].row)!=1)
      break;
    if(temp[0]=='P')
    {
      if(fscanf(fscrn, "%d", &datadef.root[ddsize].dpos)!=1)
        break;
    }
    if(fscanf(fscrn, "%s", datadef.root[ddsize].prompt)!=1)
      break;

    if(datadef.root[ddsize].prompt[strlen(datadef.root[ddsize].prompt)-1]
       == 10)
      datadef.root[ddsize].prompt[strlen(datadef.root[ddsize].prompt)-1] =  0;
    if(datadef.root[ddsize].prompt[strlen(datadef.root[ddsize].prompt)-2]
       == 10)
      datadef.root[ddsize].prompt[strlen(datadef.root[ddsize].prompt)-2] =  0;

    datadef.root[ddsize].col--;
    datadef.root[ddsize].row--;

    if((datadef.root[ddsize].prompt[0] == AALPHA)||
       (datadef.root[ddsize].prompt[0] == NNUMERIC)||
       (datadef.root[ddsize].prompt[0] == FFILE)||
       (datadef.root[ddsize].prompt[0] == DUPLICATE)||
       (datadef.root[ddsize].prompt[0] == PPROTECTED))
    {
      if(datadef.root[ddsize].prompt[0] == FFILE)
      {
        file_present = 1;
        fname_pos = ddsize;
      }
      if(temp[0]!='P')
        datadef.root[ddsize].dpos = reclen;

      datadef.root[ddsize].dlen = strlen(datadef.root[ddsize].prompt);
      reclen += datadef.root[ddsize].dlen;
      strncpy(datadef.root[ddsize].mask, ms_mask, datadef.root[ddsize].dlen);
      datadef.root[ddsize].mask[datadef.root[ddsize].dlen] = 0;
      if(strlen(datadef.root[ddsize].mask) != datadef.root[ddsize].dlen)
        printf("length error\n"); 

      if(datadef.root[ddsize].dlen == 0) 
      {
        printf("size error %d\n", datadef.root[ddsize].dlen);
        getch();
      }
 
      w_poscurs(de_window, datadef.root[ddsize].col, datadef.root[ddsize].row);
      w_print(de_window, datadef.root[ddsize].mask);

      datadef.root[ddsize].field = f_create("", datadef.root[ddsize].mask);
      if(datadef.root[ddsize].field == NULL)
        printf("field error ");

      datadef.root[ddsize].data[0] = 0;
      if(datadef.root[ddsize].field!=NULL)
      { 
        stat = f_append(de_window, datadef.root[ddsize].col,
             datadef.root[ddsize].row, datadef.root[ddsize].field);  
        if(stat == -1)
          printf("f_append error %d %s\n", ddsize, datadef.root[ddsize].prompt);

        if(datadef.root[ddsize].prompt[0] == NNUMERIC)
        {
          f_range(datadef.root[ddsize].field, NUMERIC|SIGN|POINT|BLANK);

        }
        if(datadef.root[ddsize].prompt[0] == PPROTECTED)
        {
          stat = f_protect(datadef.root[ddsize].field, ENABLE);
          if(stat == -1)
            printf("f_protect error %d\n", ex_werrno);
        }
      }
    }
    else
    {
      datadef.root[ddsize].data[0] = 0;
      w_poscurs(de_window, datadef.root[ddsize].col, datadef.root[ddsize].row);
      if(datadef.root[ddsize].prompt[0] != '&')
        w_print(de_window, datadef.root[ddsize].prompt);
      else
      {
        sscanf(&datadef.root[ddsize].prompt[1], "%d", &ct);
        w_print(de_window, &cats[ct-1][0]);
      }
    }
    ddsize++;
    if(ddsize >= DARSIZE)
    {
      w_printf(de_window, "Warning:  Oversized Screen File\n");
      getch();
    }
  }
  while(!feof(fscrn));
  farea.reclen = reclen + 2;
}


show_scrn()
{
short cnt;
short cnt2;

  for(cnt=0;cnt<ddsize;cnt++)
  {
    if((datadef.root[cnt].prompt[0] == AALPHA)||
       (datadef.root[cnt].prompt[0] == NNUMERIC)||
       (datadef.root[cnt].prompt[0] == FFILE)||
       (datadef.root[cnt].prompt[0] == DUPLICATE)||
       (datadef.root[cnt].prompt[0] == PPROTECTED))
    {
      for(cnt2=0;cnt2<strlen(datadef.root[cnt].data);cnt2++);
      {
        if((datadef.root[cnt].data[cnt2] == 13)||
           (datadef.root[cnt].data[cnt2] == 13))
          datadef.root[cnt].data[cnt2] = 32;
      }
      f_setbuffer(datadef.root[cnt].field, datadef.root[cnt].data);
    }
  }
}


edit()
{
short cnt;
short cnt2, tmp;
short closex, closey, mcnt;
short nxt_rec;
short code;
short ltr;
short ctr;
char buffer[40];
Field fjump;

unsigned keys[] =
{
  _F2, _F7, _F8, _F9, _F10, 0
};

  f_termkeys(keys);
  w_lmessage(de_window, "EDITOR V2.1  - F10 EXIT");


  c_add_button(de_window, "F7: FWD", 0, 0, _F7, BUTTON_PLAIN);
  c_add_button(de_window, "F8: REV", 8, 0, _F8, BUTTON_PLAIN);
  c_add_button(de_window, "F9: DEL", 16, 0, _F9, BUTTON_PLAIN);
  c_add_button(de_window, "F2: JMP", 24, 0, _F2, BUTTON_PLAIN);
  c_add_button(de_window, "F10: EXIT", 32, 0, _F10, BUTTON_PLAIN);
/*
  c_add_button(de_window, "SEARCH", 38, 0, ALT_S, BUTTON_PLAIN);
*/

  nxt_rec = recno;
  show_scrn();

  do
  {
    recno = nxt_rec;
    if(recno==0)
    {
      recno = 1;
      for(cnt=0;cnt<ddsize;cnt++)
        datadef.root[cnt].data[0] = 0;
      farea.nrecs = 1;
    }
    else
    {
      if(recno == farea.nrecs)
      {
        fb_prep();
        fseek(fdata, (((long) recno * farea.reclen) - (long) farea.reclen), 
                      SEEK_SET); 
        fread(tbufr, farea.reclen, 1, fdata);
        load_data();
        w_poscurs(de_window, 60, 0);
        w_print(de_window, "EOD   ");
      }
      else if(recno>farea.nrecs)
      {
        farea.nrecs = recno;
        memcpy(line, tbufr, 999);
        fb_rec(1);
        w_poscurs(de_window, 60, 0);
        w_print(de_window, "ADDING  ");
        for(cnt=0;cnt<ddsize;cnt++)
        {
          if(datadef.root[cnt].prompt[0] == PPROTECTED)
            if(datadef.root[cnt].prompt[1] == PPROTECTED)
              f_protect(datadef.root[cnt].field, DISABLE);

          if(datadef.root[cnt].prompt[1] == DUPLICATE)
          {
            strncpy(datadef.root[cnt].data,
                    &line[datadef.root[cnt].dpos],
                    datadef.root[cnt].dlen);
          }
        }
        memset(line, 0, 999);
      }
      else
      {
        fseek(fdata, (((long) recno * farea.reclen) - (long) farea.reclen), 
                      SEEK_SET); 
        fread(tbufr, farea.reclen, 1, fdata);
        load_data();
        w_poscurs(de_window, 60, 0);
        w_print(de_window, "UPDATE  ");
        for(cnt=0;cnt<ddsize;cnt++)
          if(datadef.root[cnt].prompt[0] == PPROTECTED)
            f_protect(datadef.root[cnt].field, ENABLE);
      }
    }
    show_scrn();
    w_poscurs(de_window, 70, 0);
    w_printf(de_window, "REC: %03d", recno);

    w_poscurs(de_window, 45, 0);
    w_printf(de_window, "Busy");
    w_on(de_window);
    if(file_present == 1)
      show_pcx(datadef.root[fname_pos].data);
    w_poscurs(de_window, 45, 0);
    w_printf(de_window, "    ");

    do
    {
      cnt = -1;

      w_curson(de_window);
/*      d_graphic_blink(6, 4);  */
      code = f_batch(de_window);
/*      d_graphic_blink(0, 0);  */
      for(ctr=0;ctr<4000;ctr++);
      w_cursoff();
      if(code == -1)
      {
        printf("batch error %d\n", ex_werrno);
      }
    }
    while(cnt!=-1);
    save_data();

    if(code==_F10)
      break;

    if(code==_F7)
    {
      nxt_rec = recno + 1;
    }

    if(code==_F9)
    {
      nxt_rec = fd_rec();
    }
    if(code==_F2)
    {
      fjump = f_create("JUMP TO: ", "____");
      f_setint(fjump, recno, ENABLE, DISABLE, DISABLE);
      f_process(de_window, 45, 0, fjump);
      ltr = f_getint(fjump);
      f_delete(de_window, fjump);
      w_putsat(de_window, 45, 0, "             ");

      if(ltr==0)
        ltr = farea.nrecs;
      if((ltr > 0) && (ltr <=farea.nrecs))
        nxt_rec = ltr;
    }
    if(code==ALT_S)
    {
/*    poscurs(  0, 1 ); */
/*    printf("Search - Enter Search Data, F10 ACCEPT, <ESC> to quit"); */
  /*    nxt_rec = srch_data(recno); */

//  Currently Unreached code - embedded for identification
      poscurs(  0, 1 );
      printf("Software by: D. Bingamon - Kadima Technology");

    }
    if(code==_F8)
    {
      nxt_rec = recno - 1;
      if(nxt_rec == 0)
        nxt_rec = 1;
    }
    if(recno>farea.nrecs)
      farea.nrecs = recno;
  }
  while(code!=_F10);
  if(recno>farea.nrecs)
    farea.nrecs = recno;
}


load_data()
{
short cnt;

  Checksum = 0;
  for(cnt=0;cnt<ddsize;cnt++)
  {
    strncpy(datadef.root[cnt].data, &tbufr[datadef.root[cnt].dpos],
            datadef.root[cnt].dlen);
    Checksum += chkk(datadef.root[cnt].data, datadef.root[cnt].dlen);
    fix_str(datadef.root[cnt].data);
  }
}


save_data()
{
short cnt;
short check;

  check = 0;
  for(cnt=0;cnt<ddsize;cnt++)
  {
    if(datadef.root[cnt].dlen != 0)
    {
      f_getbuffer(datadef.root[cnt].field, datadef.root[cnt].data);
      sprintf(&tbufr[datadef.root[cnt].dpos],
         "%-*.*s", datadef.root[cnt].dlen, datadef.root[cnt].dlen,
         datadef.root[cnt].data);
       check += chkk(datadef.root[cnt].data, datadef.root[cnt].dlen);
     }
  }
  if(check != Checksum)
  {
    if((Edt_pos  != -1) && (Edt_pos <= farea.reclen))
      tbufr[Edt_pos] = '1';
    rtcode = 0;
  }
  fseek(fdata, (((long) recno * farea.reclen) - (long) farea.reclen),
                 SEEK_SET);
  tbufr[farea.reclen - 2] = 0x0d;
  tbufr[farea.reclen - 1] = 0x0a;

  fwrite(tbufr, farea.reclen, 1, fdata);
}


fd_rec()
{
short cnt;
Mouse_State mstate;
Window temp_window;
short key;
short rec;

  rec = recno;
  temp_window = w_open(25, 5, 30, 10);
  c_add_button(temp_window, "Y YES", 20, 4, 'Y', 0);
  c_add_button(temp_window, "N NO ", 20, 6, 'N', 0);

  w_poscurs(temp_window, 2, 2);
  w_print(temp_window, "DELETE:  Are you sure?");
          
  w_on(temp_window);

  key = s_getkey(&mstate);
  while(-1)
  {
    key = s_getkey(&mstate);
    if((key == 'Y')||(key == 'y'))
    {
      w_off(temp_window);
      w_close(temp_window);
      break;
    }
    if((key == 'N')||(key == 'n'))
    {
      w_off(temp_window);
      w_close(temp_window);
      break;   
    }
  }

  if((key == 'Y')||(key == 'y'))
  {
    w_poscurs(de_window, 60, 0);
    w_print(de_window, "Deleting");
    rec = fb_rec(2);

    w_poscurs(de_window, 60, 0);
    w_print(de_window, "DELETED");
  }
  return rec;
}


fb_rec(cde)
short cde;
{
short cnt;
short nxt_rec;

  fseek(fdata, (((long) recno * farea.reclen) - (long) farea.reclen),
                 SEEK_SET);
  memset(tbufr, ' ', farea.reclen);
  if(cde == 2)
    tbufr[0] = '!'; 
  tbufr[farea.reclen - 2] = 0x0d;
  tbufr[farea.reclen - 1] = 0x0a;
  fwrite(tbufr, farea.reclen, 1, fdata);

  for(cnt=0;cnt<ddsize;cnt++)
  {
    strncpy(datadef.root[cnt].data, tbufr, datadef.root[cnt].dlen);
  }

  if(cde == 2)
  {
    nxt_rec = recno;
    if((recno + 1) >= farea.nrecs)
      if(recno > 1)
        nxt_rec = recno - 1;

    fclose(fdata);
    spawnlp(P_WAIT, "remove.exe", "remove.exe", dataname, 0L);
    fdata = fopen(dataname, "rb+");
    farea.nrecs = (short) (filelength(fileno(fdata)) / farea.reclen);
  }
  return nxt_rec;
}


fb_prep()
{
short cnt;

  memset(tbufr, ' ', farea.reclen);
  tbufr[farea.reclen - 2] = 0x0d;
  tbufr[farea.reclen - 1] = 0x0a;

  for(cnt=0;cnt<ddsize;cnt++)
  {
    strncpy(datadef.root[cnt].data, tbufr, datadef.root[cnt].dlen);
  }
}


fix_str(str)
char *str;
{
short cnt;

  if(strlen(str)==0)
    return;

  for(cnt=0;cnt<strlen(str);cnt++)
  {
    if(str[cnt] == 0x0d)
      str[cnt] = 32;
    if(str[cnt] == 0x0a)
      str[cnt] = 32;
  }
  
  for(cnt=strlen(str)-1;cnt>=0;cnt--)
  {
    if(str[cnt]!=32)
      return;
    str[cnt]=0;
  }
}



clean(str)
char *str;
{
char str_2[25];
char *str2;

  str2 = str_2;
  if(strlen(str)==0)
    return;
  strcpy(str_2, str);
  while(*str2!=0)
  {
    if((*str2!=13)&&(*str2!=10))
      *str++ = *str2;
    str2++;
  }
  *str = 0;
}


get_kb()
{
short chr;

  do
  {
  }
  while(!kbhit());

  return getch();
}


error_window(err)
char *err;
{
Window temp_window;
Mouse_State mstate;
short key;

  temp_window = w_open(18, 5, 44, 5);
  w_poscurs(temp_window, 2, 1);
  w_printf(temp_window, "Internal Error: %s", err);
  w_poscurs(temp_window, 2, 3);
  w_print(temp_window, "Click Mouse to continue.");
  key = s_getkey(&mstate);
  while((key != _ESC) && (key != _ENTER) && (key != MOUSE_LEFTCLK))
    key = s_getkey(&mstate);
  w_close(temp_window);
}


show_pcx(ffname)
char *ffname;
{
char fn[13];
short n,c,i;
char pat = PENCOLOR;

  s_off();
  fill_style(&pat, 1, 1);
  move_to(xoffset, yoffset);
  pen_color(7);
  disable();
  flood(floodx,  floody);

  enable();

  py = 0;
  px = 0;


  strncpy(fn, ffname, 12);

  ffp = fopen(fn, "rb");
  if(ffp != NULL)
  {
    if(fread(&p, 1, sizeof(p), ffp) == sizeof(p))
    {
      do
      {
        n = read_pcx();
        disable();
        for(i = 0;i < n;i++)
        {
          w_dot(py, px, line[i] & 128);
          coords();
          w_dot(py, px, line[i] & 64); 
          coords();
          w_dot(py, px, line[i] & 32); 
          coords();
          w_dot(py, px, line[i] & 16); 
          coords();
          w_dot(py, px, line[i] & 8); 
          coords();
          w_dot(py, px, line[i] & 4); 
          coords();
          w_dot(py, px, line[i] & 2); 
          coords();
          w_dot(py, px, line[i] & 1); 
          coords();
          if(py > floody)
            break;
        }
        enable();
        if(feof(ffp))
          break;
        if(py > floody)
          break;
      }
      while((n != 0) && (py < p.ymax));
    }
    fclose(ffp);
  }
  s_on();
}


read_pcx()
{
short n, c, i;

  memset(line, 0, p.bytes_per_line);
  n = 0;
  c = 0;
  i = 0;
  do
  {
    if(feof(ffp)) 
      break;
    c = fgetc(ffp) & 0xff;
    if((c & 0xc0) == 0xc0)
    {
      i = c & 0x3f;
      c = fgetc(ffp);

      while(i--)
        line[n++] = c;
    }
    else
      line[n++] = c;
  }
  while(n < p.bytes_per_line);
  return n;
}


coords()
{
  px++;
  if(px > ((p.bytes_per_line * 8) - 1))
  {
    py++;
    px = 0;
  }
}
          

w_dot(y, x, c)
short y, x, c;
{
short xa, ya;

  xa = x + xoffset;
  ya = y + yoffset;

  if((xa > 639)||(ya > 479))
    return;

  if((xa > (xoffset + floodx)) || (ya > (yoffset + floody)))
    return;


  if(x <= p.xmax)
  {
    if(c>0)
      writedot(ya, xa, 0);
  }
}


void buffer_save()
{
FILE *Fdd;
static short Cnt_b;
char far *outbuffer;
short x;

  if(Cnt_b < 200)
  {
    Cnt_b++;
    return;
  }
  Cnt_b = 0;
  x = (long) getvect(0x61);

  if(x==0L)
    return;

  _CL = 0;
  geninterrupt(0x61);
  if(_CL == 0)
    return;

  outbuffer = MK_FP(_AX, _BX);

  Fdd = fopen("bgdata.dat", "a+");
  if(Fdd == NULL)
  {
    return -1;
  }
  fwrite(outbuffer, strlen(outbuffer), 1, Fdd);
  fclose(Fdd);
  outbuffer[0] = 0;

}

                                               
load_color()
{
FILE *ff;
short colr;

  Colr = 1;
  ff = fopen("deg.clr", "r");
  if(ff != NULL)
  {
    fscanf(ff, "%d", &colr);
    d_colorscheme(colr);
  }
  fclose(ff);

  Colr = colr;
}


load_edtpos()
{
FILE *ff;

  ff = fopen(edtname, "r");
  if(ff != NULL)
  {
    fscanf(ff, "%d", &Edt_pos);
  }
  fclose(ff);
}


chkk(str, len)
char *str;
short len;
{
short cnt;
short chk;

  if(cnt==0)
    return 0;

  chk = 0;
  for(cnt=0;cnt<len;cnt++)
    chk += str[cnt];

  return chk;
}


rd_cat()
{
short cnt;

  if(fscrn==NULL)
  {
    for(cnt=0;cnt<15;cnt++)
      cats[cnt][0] = 0;
  }
  else
  {
    for(cnt=0;cnt<15;cnt++)
    {
      fgets(&cats[cnt][0], 25, fscrn);
      clean(&cats[cnt][0]);
    }
  }
}


load_cfg()
{
FILE *ff;

  xoffset = 10;
  yoffset = 230;
  floodx = 400;
  floody = 100;

  ff = fopen(cfgname, "r");
  if(ff != NULL)
  {
    fscanf(ff, "%d %d %d %d", &xoffset, &yoffset, &floodx, &floody);
  }
  fclose(ff);
}



