void VESA_Pix8BC ( long X , long Y , unsigned long C , unsigned short Selector ) {
    if ( X < VESA_MinX ) return;
    if ( X > VESA_MaxX ) return;
    if ( Y < VESA_MinY ) return;
    if ( Y > VESA_MaxY ) return;
    *(char far*)( Selector :> (char*)( Y * VESA_BpL + X ) ) = char( C );
};

void VESA_FilledTriangleTex8BC( long x1, long y1, long x2, long y2, long x3, long y3,
                                long tx1, long ty1, long tx2, long ty2,
                                long tx3, long ty3, DWORD MUL, WORD S ) {
    long m,i;
    long x12,x13,x23,m12,m13,m23;
    long tx12,tx13,tx23,mtx12,mtx13,mtx23;
    long ty12,ty13,ty23,mty12,mty13,mty23;
    if ( y1 >= y2 ) {
        m = y1; y1 = y2; y2 = m;
        m = x1; x1 = x2; x2 = m;
        m = tx1; tx1 = tx2; tx2 = m; 
        m = ty1; ty1 = ty2; ty2 = m; };
    if ( y2 >= y3 ) {
        m = y2; y2 = y3; y3 = m;
        m = x2; x2 = x3; x3 = m;
        m = tx2; tx2 = tx3; tx3 = m; 
        m = ty2; ty2 = ty3; ty3 = m; };
    if ( y1 >= y2 ) {
        m = y1; y1 = y2; y2 = m;
        m = x1; x1 = x2; x2 = m;
        m = tx1; tx1 = tx2; tx2 = m; 
        m = ty1; ty1 = ty2; ty2 = m; };
    x12 = x1 << 16;
    x13 = x1 << 16;
    x23 = x2 << 16;
    tx12 = tx1 << 16;
    tx13 = tx1 << 16;
    tx23 = tx2 << 16;
    ty12 = ty1 << 16;
    ty13 = ty1 << 16;
    ty23 = ty2 << 16;
    if ( y2 != y1 ) { m12   = ( (  x2 -  x1 ) << 16 ) / ( y2 - y1 );
                      mtx12 = ( ( tx2 - tx1 ) << 16 ) / ( y2 - y1 ); 
                      mty12 = ( ( ty2 - ty1 ) << 16 ) / ( y2 - y1 ); };
    if ( y3 != y1 ) { m13  = ( ( x3 - x1 ) << 16 ) / ( y3 - y1 ); 
                      mtx13 = ( ( tx3 - tx1 ) << 16 ) / ( y3 - y1 ); 
                      mty13 = ( ( ty3 - ty1 ) << 16 ) / ( y3 - y1 ); };
    if ( y3 != y2 ) { m23  = ( ( x3 - x2 ) << 16 ) / ( y3 - y2 ); 
                      mtx23 = ( ( tx3 - tx2 ) << 16 ) / ( y3 - y2 ); 
                      mty23 = ( ( ty3 - ty2 ) << 16 ) / ( y3 - y2 ); };
    for ( i = y1; i < y2; i++ ) {
        VESA_HLineTex8B( x12 >> 16, x13 >> 16, i, tx12, ty12, tx13, ty13,
                         MUL, S );
        x12 += m12;
        x13 += m13;
        tx12 += mtx12;
        ty12 += mty12;
        tx13 += mtx13;
        ty13 += mty13; };
    for ( ; i <= y3; i++ ) {
        VESA_HLineTex8B( x13 >> 16, x23 >> 16, i, tx13, ty13, tx23, ty23,
                         MUL, S );
        x13 += m13;
        x23 += m23;
        tx13 += mtx13;
        ty13 += mty13;
        tx23 += mtx23;
        ty23 += mty23; };
};

void VESA_FilledTriangleTexZ8BC( long x1, long y1, long x2, long y2, long x3, long y3,
                                 long tx1, long ty1, long tx2, long ty2,
                                 long tx3, long ty3, long z1, long z2, long z3,
                                 DWORD MUL, WORD ZSEL, WORD S ) {
    long m,i;
    long x12,x13,x23,m12,m13,m23;
    long tx12,tx13,tx23,mtx12,mtx13,mtx23;
    long ty12,ty13,ty23,mty12,mty13,mty23;
    long z12,z13,z23,mz12,mz13,mz23;
    if ( y1 >= y2 ) {
        m = y1; y1 = y2; y2 = m;
        m = x1; x1 = x2; x2 = m;
        m = z1; z1 = z2; z2 = m;
        m = tx1; tx1 = tx2; tx2 = m; 
        m = ty1; ty1 = ty2; ty2 = m; };
    if ( y2 >= y3 ) {
        m = y2; y2 = y3; y3 = m;
        m = x2; x2 = x3; x3 = m;
        m = z2; z2 = z3; z3 = m;
        m = tx2; tx2 = tx3; tx3 = m; 
        m = ty2; ty2 = ty3; ty3 = m; };
    if ( y1 >= y2 ) {
        m = y1; y1 = y2; y2 = m;
        m = x1; x1 = x2; x2 = m;
        m = z1; z1 = z2; z2 = m;
        m = tx1; tx1 = tx2; tx2 = m; 
        m = ty1; ty1 = ty2; ty2 = m; };
    x12 = x1 << 16;
    x13 = x1 << 16;
    x23 = x2 << 16;
    z12 = z1;
    z13 = z1;
    z23 = z2;
    tx12 = tx1 << 16;
    tx13 = tx1 << 16;
    tx23 = tx2 << 16;
    ty12 = ty1 << 16;
    ty13 = ty1 << 16;
    ty23 = ty2 << 16;
    if ( y2 != y1 ) { m12   = ( ( x2 - x1 ) << 16 ) / ( y2 - y1 );
                      mz12   = ( ( z2 - z1 ) ) / ( y2 - y1 );
                      mtx12 = ( ( tx2 - tx1 ) << 16 ) / ( y2 - y1 ); 
                      mty12 = ( ( ty2 - ty1 ) << 16 ) / ( y2 - y1 ); };
    if ( y3 != y1 ) { m13  = ( ( x3 - x1 ) << 16 ) / ( y3 - y1 ); 
                      mz13   = ( ( z3 - z1 ) ) / ( y3 - y1 );
                      mtx13 = ( ( tx3 - tx1 ) << 16 ) / ( y3 - y1 ); 
                      mty13 = ( ( ty3 - ty1 ) << 16 ) / ( y3 - y1 ); };
    if ( y3 != y2 ) { m23  = ( ( x3 - x2 ) << 16 ) / ( y3 - y2 ); 
                      mz23   = ( ( z3 - z2 ) ) / ( y3 - y2 );
                      mtx23 = ( ( tx3 - tx2 ) << 16 ) / ( y3 - y2 ); 
                      mty23 = ( ( ty3 - ty2 ) << 16 ) / ( y3 - y2 ); };
    for ( i = y1; i < y2; i++ ) {
        VESA_HLineTexZ8B( x12 >> 16, x13 >> 16, i, tx12, ty12, tx13, ty13, z12, z13,
                         MUL, ZSEL, S );
        x12 += m12;
        x13 += m13;
        z12 += mz12;
        z13 += mz13;
        tx12 += mtx12;
        ty12 += mty12;
        tx13 += mtx13;
        ty13 += mty13; };
    for ( ; i <= y3; i++ ) {
        VESA_HLineTexZ8B( x13 >> 16, x23 >> 16, i, tx13, ty13, tx23, ty23, z13, z23,
                         MUL, ZSEL, S );
        x13 += m13;
        x23 += m23;
        z13 += mz13;
        z23 += mz23;
        tx13 += mtx13;
        ty13 += mty13;
        tx23 += mtx23;
        ty23 += mty23; };
};

void VESA_FilledTriangleZBuf8BC( long x1, long y1, long x2, long y2, long x3, long y3,
                                  long z1, long z2, long z3,
                                  DWORD C, WORD ZSEL, WORD S ) {
    long m,i;
    long x12,x13,x23,m12,m13,m23;
    long z12,z13,z23;
    long mz12,mz13,mz23;
    if ( y1 >= y2 ) {
        m = y1; y1 = y2; y2 = m;
        m = x1; x1 = x2; x2 = m;
        m = z1; z1 = z2; z2 = m; };
    if ( y2 >= y3 ) {
        m = y2; y2 = y3; y3 = m;
        m = x2; x2 = x3; x3 = m;
        m = z2; z2 = z3; z3 = m; };
    if ( y1 >= y2 ) {
        m = y1; y1 = y2; y2 = m;
        m = x1; x1 = x2; x2 = m;
        m = z1; z1 = z2; z2 = m; };
    x12 = x1 << 16;
    x13 = x1 << 16;
    x23 = x2 << 16;
    z12 = z1;
    z13 = z1;
    z23 = z2;
    if ( y2 != y1 ) { m12  = ( ( x2 - x1 ) << 16 ) / ( y2 - y1 );
                      mz12 = ( z2 - z1 ) / ( y2 - y1 ); };
    if ( y3 != y1 ) { m13  = ( ( x3 - x1 ) << 16 ) / ( y3 - y1 ); 
                      mz13 = ( z3 - z1 ) / ( y3 - y1 ); };
    if ( y3 != y2 ) { m23  = ( ( x3 - x2 ) << 16 ) / ( y3 - y2 ); 
                      mz23 = ( z3 - z2 ) / ( y3 - y2 ); };
    for ( i = y1; i < y2; i++ ) {
        VESA_HLineZ8B( x12 >> 16, x13 >> 16, i, z12, z13, C, ZSEL, S );
        x12 += m12;
        x13 += m13;
        z12 += mz12;
        z13 += mz13; };
    for ( ; i <= y3; i++ ) {
        VESA_HLineZ8B( x23 >> 16, x13 >> 16, i, z23, z13, C, ZSEL, S );
        x13 += m13;
        x23 += m23;
        z13 += mz13;
        z23 += mz23; };
};

void VESA_FilledTriangleGZBuf8BC( long x1, long y1, long x2, long y2, long x3, long y3,
                                   long z1, long z2, long z3, long c1, long c2, long c3,
                                   WORD ZSEL, WORD S ) {
    long m,i;
    long x12,x13,x23,m12,m13,m23;
    long z12,z13,z23,mz12,mz13,mz23;
    long c12,c13,c23,mc12,mc13,mc23;
    if ( y1 >= y2 ) {
        m = y1; y1 = y2; y2 = m;
        m = x1; x1 = x2; x2 = m;
        m = c1; c1 = c2; c2 = m;
        m = z1; z1 = z2; z2 = m; };
    if ( y2 >= y3 ) {
        m = y2; y2 = y3; y3 = m;
        m = x2; x2 = x3; x3 = m;
        m = c2; c2 = c3; c3 = m;
        m = z2; z2 = z3; z3 = m; };
    if ( y1 >= y2 ) {
        m = y1; y1 = y2; y2 = m;
        m = x1; x1 = x2; x2 = m;
        m = c1; c1 = c2; c2 = m;
        m = z1; z1 = z2; z2 = m; };
    x12 = x1 << 16;
    x13 = x1 << 16;
    x23 = x2 << 16;
    z12 = z1;
    z13 = z1;
    z23 = z2;
    c12 = c1 << 16;
    c13 = c1 << 16;
    c23 = c2 << 16;
    if ( y2 != y1 ) { m12  = ( ( x2 - x1 ) << 16 ) / ( y2 - y1 );
                      mc12 = ( ( c2 - c1 ) << 16 ) / ( y2 - y1 ); 
                      mz12 = ( z2 - z1 ) / ( y2 - y1 ); };
    if ( y3 != y1 ) { m13  = ( ( x3 - x1 ) << 16 ) / ( y3 - y1 ); 
                      mc13 = ( ( c3 - c1 ) << 16 ) / ( y3 - y1 ); 
                      mz13 = ( z3 - z1 ) / ( y3 - y1 ); };
    if ( y3 != y2 ) { m23  = ( ( x3 - x2 ) << 16 ) / ( y3 - y2 ); 
                      mc23 = ( ( c3 - c2 ) << 16 ) / ( y3 - y2 ); 
                      mz23 = ( z3 - z2 ) / ( y3 - y2 ); };
    for ( i = y1; i < y2; i++ ) {
        VESA_HLineGZ8B( x12 >> 16, x13 >> 16, i, z12, z13, c12, c13, ZSEL, S );
        x12 += m12;
        x13 += m13;
        c12 += mc12;
        c13 += mc13;
        z12 += mz12;
        z13 += mz13; };
    for ( ; i <= y3; i++ ) {
        VESA_HLineGZ8B( x23 >> 16, x13 >> 16, i, z23, z13, c23, c13, ZSEL, S );
        x13 += m13;
        x23 += m23;
        c13 += mc13;
        c23 += mc23;
        z13 += mz13;
        z23 += mz23; };
};

void VESA_FilledTriangleG8BC( long x1, long y1, long x2, long y2, long x3, long y3,
                               long c1, long c2, long c3, WORD S ) {
    
    long m,i;
    long x12,x13,x23,m12,m13,m23;
    long c12,c13,c23,mc12,mc13,mc23;
    long dcdx12,dcdx23;
    
    if ( y1 >= y2 ) {
        m = y1; y1 = y2; y2 = m;
        m = x1; x1 = x2; x2 = m;
        m = c1; c1 = c2; c2 = m; }
    if ( y2 >= y3 ) {
        m = y2; y2 = y3; y3 = m;
        m = x2; x2 = x3; x3 = m;
        m = c2; c2 = c3; c3 = m; };
    if ( y1 >= y2 ) {
        m = y1; y1 = y2; y2 = m;
        m = x1; x1 = x2; x2 = m;
        m = c1; c1 = c2; c2 = m; };

    x12 = x1 << 16;
    x13 = x1 << 16;
    x23 = x2 << 16;
    
    c12 = c1 << 16;
    c13 = c1 << 16;
    c23 = c2 << 16;

    if ( y2 != y1 ) {
        m12 = ((x2-x1) << 16) / (y2-y1);
        mc12 = ((c2-c1) << 16) / (y2-y1);
    };
    if ( y3 != y1 ) {
        m13 = ((x3-x1) << 16) / (y3-y1);
        mc13 = ((c3-c1) << 16) / (y3-y1);
    };
    if ( y3 != y2 ) {
        m23 = ((x3-x2) << 16) / (y3-y2); 
        mc23 = ((c3-c2) << 16) / (y3-y2);
    };

    dcdx12 = (x3-x1)*(y2-y1)-(x2-x1)*(y3-y1);
    if ( dcdx12 != 0 )
         dcdx12 = double((c3-c1)*(y2-y1)-(c2-c1)*(y3-y1)) / dcdx12 * 65536;

    dcdx23 = (x3-x1)*(y3-y2)-(x3-x2)*(y3-y1);
    if ( dcdx23 != 0 )
         dcdx23 = double((c3-c1)*(y3-y2)-(c3-c2)*(y3-y1)) / dcdx23 * 65536;

    for ( i = y1; i < y2; i++ ) {
        VESA_HLineG8BFast( x12 >> 16, x13 >> 16, i, c12, c13, dcdx12, S );
        x12 += m12;
        x13 += m13;
        c12 += mc12;
        c13 += mc13;
    };

    for ( ; i <= y3; i++ ) {
        VESA_HLineG8BFast( x23 >> 16, x13 >> 16, i, c23, c13, dcdx23, S );
        x23 += m23;
        x13 += m13;
        c23 += mc23;
        c13 += mc13;
    };
};

void VESA_FilledTriangleTex8BCF( long x1, long y1, long x2, long y2, long x3, long y3,
                                 long tx1, long ty1, long tx2, long ty2,
                                 long tx3, long ty3, DWORD MUL, WORD S ) {
    long m,i;
    long x12,x13,x23,m12,m13,m23;
    long tx12,tx13,tx23,mtx12,mtx13,mtx23;
    long ty12,ty13,ty23,mty12,mty13,mty23;
    long dtxdx12,dtxdx23,dtydx12,dtydx23;
    
    if ( y1 >= y2 ) {
        m = y1; y1 = y2; y2 = m;
        m = x1; x1 = x2; x2 = m;
        m = tx1; tx1 = tx2; tx2 = m; 
        m = ty1; ty1 = ty2; ty2 = m; };
    if ( y2 >= y3 ) {
        m = y2; y2 = y3; y3 = m;
        m = x2; x2 = x3; x3 = m;
        m = tx2; tx2 = tx3; tx3 = m; 
        m = ty2; ty2 = ty3; ty3 = m; };
    if ( y1 >= y2 ) {
        m = y1; y1 = y2; y2 = m;
        m = x1; x1 = x2; x2 = m;
        m = tx1; tx1 = tx2; tx2 = m; 
        m = ty1; ty1 = ty2; ty2 = m; };
        
    x12 = x1 << 16;
    x13 = x1 << 16;
    x23 = x2 << 16;
    
    tx12 = tx1 << 16;
    tx13 = tx1 << 16;
    tx23 = tx2 << 16;
    
    ty12 = ty1 << 16;
    ty13 = ty1 << 16;
    ty23 = ty2 << 16;
    
    if ( y2 != y1 ) { m12 = double(x2-x1) / (y2-y1) * 65536;
                      mtx12 = double(tx2-tx1) / (y2-y1) * 65536; 
                      mty12 = double(ty2-ty1) / (y2-y1) * 65536; };
    if ( y3 != y1 ) { m13  = double(x3-x1) / (y3-y1) * 65536; 
                      mtx13 = double(tx3-tx1) / (y3-y1) * 65536; 
                      mty13 = double(ty3-ty1) / (y3-y1) * 65536; };
    if ( y3 != y2 ) { m23 = double(x3-x2)/ (y3-y2) * 65536; 
                      mtx23 = double(tx3-tx2) / (y3-y2) * 65536; 
                      mty23 = double(ty3-ty2) / (y3-y2) * 65536; };

    dtxdx12 = (x3-x1)*(y2-y1)-(x2-x1)*(y3-y1);
    if ( dtxdx12 != 0 )
         dtxdx12 = double((tx3-tx1)*(y2-y1)-(tx2-tx1)*(y3-y1)) / dtxdx12 * 65536;

    dtxdx23 = (x3-x1)*(y3-y2)-(x3-x2)*(y3-y1);
    if ( dtxdx23 != 0 )
         dtxdx23 = double((tx3-tx1)*(y3-y2)-(tx3-tx2)*(y3-y1)) / dtxdx23 * 65536;

    dtydx12 = (x3-x1)*(y2-y1)-(x2-x1)*(y3-y1);
    if ( dtydx12 != 0 )
         dtydx12 = double((ty3-ty1)*(y2-y1)-(ty2-ty1)*(y3-y1)) / dtydx12 * 65536;

    dtydx23 = (x3-x1)*(y3-y2)-(x3-x2)*(y3-y1);
    if ( dtydx23 != 0 )
         dtydx23 = double((ty3-ty1)*(y3-y2)-(ty3-ty2)*(y3-y1)) / dtydx23 * 65536;

    for ( i = y1; i < y2; i++ ) {
        VESA_HLineTex8BFast( x12 >> 16, x13 >> 16, i, tx12, ty12, tx13, ty13, dtxdx12,
                             dtydx12, MUL, S );
        x12 += m12;
        x13 += m13;
        tx12 += mtx12;
        ty12 += mty12;
        tx13 += mtx13;
        ty13 += mty13; };

    for ( ; i <= y3; i++ ) {
        VESA_HLineTex8BFast( x13 >> 16, x23 >> 16, i, tx13, ty13, tx23, ty23, dtxdx23,
                             dtydx23, MUL, S );
        x13 += m13;
        x23 += m23;
        tx13 += mtx13;
        ty13 += mty13;
        tx23 += mtx23;
        ty23 += mty23; };
};


