/*Ŀ
 ݳ                                                                      
 ݳ Program Name: MAKE.PRG                                               
 ݳ       Author: Kevin S Gallagher                                      
 Ĵ
 ݳ * Read [readme.txt] before using compiling/linking                   
 
            */

#include "main.h"

procedure main
    local nLen := len(cHeaderFiles_), i

    AskUser()

    ?"Copying files...  "
    CopyChFiles()

    DoStd()

    for i := 1 to nLen
        DoRest(cHeaderFiles_[i,1],cHeaderFiles_[i,2])
    next

    ?"Creating linkfile..."
    WriteHeader()

    ?"Creating support files... "
    MainFile()
    MakeRsp()
    MakeBat()

    if alert("Create Norton Guides file",{"No","Yes"}) == 2
        swpruncmd(".\heads.bat",0)
        if file(NG_NAME)
            if alert("Copy NG to NG directory?",{"Yes","No"}) == 1
                NgHome()
            endif
        endif
    endif

    if alert("Remove temp files?",{"No","Yes"}) == 2
        aeval(directory("*.eho"),{|a| qout("Erasing " + a[1]),ferase(a[1])})
        aeval(directory("*.txt"),{|a| qout("Erasing " + a[1]),ferase(a[1])})
        aeval(A_JUNK_FILES_     ,{|a| qout("Erasing " + a   ),ferase(a)   })
    endif

    set cursor on
    quit
return

/*
*   Routine: DoRest(<cFile>,<nSkip>)
*          : 
*   Purpose: creates source file suitable for EH compiler from .CH files
*          : 
* Arguments: <cFile>    .CH file to process
*          : <nSkip>    lines to skip at beginning for <cFile>
*          : 
*  Comments: The parameter 'nSkip' is used to bypass the headers and
*          : initial empty/unwanted lines. Some special processing
*          : is done on some files which require special handling.
*          : 
*/
procedure DoRest(cFile,nSkip)
    local nLen
    local i
    local nHandle
    local nDest
    local cLine
    local cDestFile := strtran(cFile,".CH",".TXT")

    ?lower(cFile) + "...    "

    nHandle := fopen(cFile,0)
    nDest   := fcreate(cDestFile,0)

    if cFile != "RESERVED.CH"
        for i := 1 to nSkip
            kgreadline(nHandle,1,1,@cLine)
        next
    endif

    do case
        case cFile == "GETEXIT.CH"
            fwrite(nDest,"!short: Get:exitstates"   + CRLF)
        case cFile == "SIMPLEIO.CH"
            fwrite(nDest,"!short: Simpleio.ch"      + CRLF)
        case cFile == "RDDSYS.CH"
            fwrite(nDest,"!short: Rddsys.ch"        + CRLF)
        case cFile == "SET.CH"
            fwrite(nDest,"!short: Set.ch"           + CRLF)
        case cFile == "RESERVED.CH"
            fwrite(nDest,"!short: reserve.ch"       + CRLF)
            while (kgreadline(nHandle,1,1,@cLine)) >0 .and. !AbortRequest()
                fwrite(nDest,cLine + CRLF)
            enddo
            fclose(nHandle)
            fclose(nDest)
            ferase(cFile)
            return
    endcase

    while (kgreadline(nHandle,1,1,@cLine)) >0 .and. !AbortRequest()
        if "//" $ left(cLine,2) 
            if left(cLine,26) == "// NOTE:  FCREATE() always"
                fwrite(nDest,ltrim(strtran(cLine,"//","")) + CRLF)
                loop
            endif
            fwrite(nDest,"!short: " + ltrim(strtran(cLine,"//","")) + CRLF)
        else
            fwrite(nDest,cLine + CRLF)
        endif
        if AbortRequest()
            exit
        endif
    enddo

    fclose(nHandle)
    fclose(nDest)
    ferase(cFile)
return

/*
*   Routine: DoStd()
*          : 
*   Purpose: creates source file suitable for EH compiler from std.ch
*          : 
* Arguments: void
*          : 
*  Comments: void
*          : 
*/
procedure DoStd()
    local nLen
    local i
    local nPos
    local nHandle
    local nDest
    local cLine

    ?"Processing std.ch... "

    nHandle := fopen("std.ch",0)
    nDest   := fcreate("std.txt",0)

    for i := 1 to 14
        kgreadline(nHandle,1,1,@cLine)
    next

    while (kgreadline(nHandle,1,1,@cLine)) >0 .and. !AbortRequest()
        if "/*" $ left(cLine,2)
            kgreadline(nHandle,1,1,@cLine)
            fwrite(nDest,"!short: " + ltrim(strtran(cLine,"*","")) + CRLF)
            kgreadline(nHandle,1,1,@cLine)

            while (kgreadline(nHandle,1,1,@cLine)) >0 .and. !AbortRequest()
                if "/*" $ left(cLine,2)
                    nPos := fseek(nHandle, 0,1) -2
                    nPos -= len(cLine) 
                    fseek(nHandle,nPos,0)
                    exit
                endif
                fwrite(nDest,cLine + CRLF)
            enddo
        endif
        if AbortRequest()
            exit
        endif
    enddo
    fclose(nHandle)
    fclose(nDest)
return

/*
*   Routine: AbortRequest
*          : 
*   Purpose: allows early exit from utility while reading/written files
*          : 
* Arguments: void
*          : 
*  Comments: void
*          : 
*/
function AbortRequest()
return (inkey()) == 27

/*
*   Routine: WriteHeader()
*          : 
*   Purpose: Creates linkfile for CH file
*          : 
* Arguments: 
*          : 
*  Comments: 
*          : 
*/
procedure WriteHeader()
local nHandle
nHandle := fcreate("caheader.lnk")
fwrite(nHandle,"!name: Clipper Standard CH files" + CRLF)
fwrite(nHandle,"!credits:" + CRLF)
fwrite(nHandle,"" + CRLF)
fwrite(nHandle,                                                     ;
 "Copyright (c) 1990-1993, Computer Associates International, Inc." + CRLF)
fwrite(nHandle,"All rights reserved." + CRLF)
fwrite(nHandle,"Norton Guides created by Kevin S. Gallagher" + CRLF)
fwrite(nHandle,"!menu: Include files" + CRLF)
fwrite(nHandle,"    Standard Clipper headers            Headers.eho" + CRLF)

fclose(nHandle)
return

/*
*   Routine: MainFile()
*          : 
*   Purpose: Creates top level code to link all .eho's together
*          : 
* Arguments: void
*          : 
*  Comments: void
*          : 
*/
procedure MainFile 
    local i
    local nLen := len(cHeaderFiles_)
    local nHandle := fcreate("headers.txt")

    for i := 1 to nLen
        fwrite(nHandle,"!short: " + cHeaderFiles_[i,1] + CRLF)
        fwrite(nHandle,"!file: "  +                                 ;
            strtran(cHeaderFiles_[i,1],".CH",".EHO") + CRLF         ;
        )
    next
    fwrite(nHandle,"!short: " + "Std.ch" + CRLF)
    fwrite(nHandle,"!file: std.eho" + CRLF)
    fclose(nHandle)
return

/*
*   Routine: MakeRsp()
*          : 
*   Purpose: used to create a .rsp file for Expert Help utilities
*          : 
* Arguments: void
*          : 
*  Comments: void
*          : 
*/
procedure MakeRsp()
    local i
    local nLen := len(cHeaderFiles_)
    local nHandle := fcreate("headers.rsp")

    for i := 1 to nLen
        fwrite(nHandle,strtran(cHeaderFiles_[i,1],".CH",".TXT")+ CRLF)
    next

    fwrite(nHandle,"std.txt" + CRLF)
    fwrite(nHandle,"headers.txt" + CRLF)
    fclose(nHandle)
return

/*
*   Routine: MakeBat
*          : 
*   Purpose: Creates batch file for creating NG
*          : 
* Arguments: void
*          : 
*  Comments: void
*          : 
*/
procedure MakeBat()
    local nHandle := fcreate("heads.bat")
    fwrite(nHandle,"@Echo Off" + CRLF)
    fwrite(nHandle,"REM  Compile The Source Files" + CRLF)
    fwrite(nHandle,"EHC @headers.rsp -Eerr.ehc -NP" + CRLF)
    fwrite(nHandle,"REM Link the Source Files to Create a Database. " + CRLF)
    fwrite(nHandle,"EHML caheader.lnk -Eerr.ehl" + CRLF)
    fwrite(nHandle,"echo." + CRLF)
    fclose(nHandle)
return

/*
*   Routine: CopyChFiles()
*          : 
*   Purpose: used to copy .CH files to temp directory
*          : 
* Arguments: void
*          : 
*  Comments: void
*          : 
*/
procedure CopyChFiles
    local i
    local nLen := len(cHeaderFiles_)


    for i := 1 to nLen
        ?"Copying " + C_HOME + cHeaderFiles_[i,1] + " to current directory  "
        if !file(C_HOME + cHeaderFiles_[i,1])
            alert("Missing;"  + cHeaderFiles_[i,1] + ";from;" +;
                  C_HOME;
            )
            quit
        endif

        __CopyFile(C_HOME + cHeaderFiles_[i,1] ,".\" + cHeaderFiles_[i,1])
    next
    ?"Copying " + C_HOME + "std.ch to current directory  "
    __CopyFile(C_HOME + "std.ch" ,".\std.ch")
return

procedure AskUser()
    cls
    aeval(A_ALERT_TXT_,{|x| qout(x)})
    if alert("Read above before answering;;Continue processing?",{"Yes","No"}) !=1
        quit
    endif

    // see if the include directory exist.
    if file(C_HOME +"PRN")
        ?"Could not locate [" + substr(C_HOME,1,rat("\",C_HOME) -1) +"]"
        ?"Make sure to specify the proper directory in C_HOME constant"
        quit
    endif

    set cursor off
    ?
return

/*
*   Routine: NgHome()
*          : 
*   Purpose: Query user to copy newly created .NG file to thier NG directory
*          : 
* Arguments: void
*          : 
*  Comments: void
*          : 
*/
procedure NgHome()
    local nCursor := setcursor(1)
    local cPath   := padr("C:\CLIPPER52\NG",50)
    local cScrn   := savescreen(9,3,12,76)
    local lFlag   := .t.
    local getlist := {}

    readinsert(.t.)

    dispbox(9,3,12,76,"Ŀ ","w+/b")
    @11, 6 say "Press ESC to abort"         color "gr+/b"
    @10, 6 say "Copy NG file to:"           color "w+/b"
    @10,23 get cPath                        color "w/n"     picture "@!"
    read

    if empty(cPath := alltrim(cPath)) .or. lastkey() == 27
        lFlag := .f.
    endif

    cPath += if(right(cPath,1) == "\","","\")

    if lFlag
        if file(cPath + "NUL")
            __copyfile(NG_NAME,cPath + NG_NAME)
            alert("NG file copied!")
        endif
    endif

    setcursor(nCursor)
    restscreen(9,3,12,76,cScrn)
return

init function kg_start
    set scoreboard off
return .t.    
