unit TDMain;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, AdMisc, AdExcept, AdTerm, AdPort, AdXPort,
  Menus, ExtCtrls, StdCtrls;

type
  TMainForm = class(TForm)
    ComPort1: TComPort;
    Terminal1: TTerminal;
    Emulator1: TEmulator;
    MainMenu1: TMainMenu;
    F1: TMenuItem;
    E1: TMenuItem;
    C1: TMenuItem;
    F2: TMenuItem;
    P1: TMenuItem;
    C2: TMenuItem;
    N1: TMenuItem;
    E2: TMenuItem;
    C3: TMenuItem;
    S1: TMenuItem;
    StatusLine: THeader;
    OpenDialog1: TOpenDialog;
    FontDialog1: TFontDialog;
    Label1: TLabel;
    procedure Terminal1TerminalStatus(CP: TObject; Row, Col: Byte; BufRow,
      BufCol: Word);
    procedure P1Click(Sender: TObject);
    procedure ComPort1PortChange(CP: TObject);
    procedure FormActivate(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure C2Click(Sender: TObject);
    procedure E2Click(Sender: TObject);
    procedure C3Click(Sender: TObject);
    procedure S1Click(Sender: TObject);
    procedure F2Click(Sender: TObject);
    procedure FormKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
  private
    { Private declarations }
    procedure AppIdle(Sender: TObject; var Done: Boolean);
    procedure UpdateComInfo(Term : TTerminal);
  public
    { Public declarations }
  end;

var
  MainForm: TMainForm;

implementation

const
  UseFile : Boolean = False;

var
  AnsiFile : String;
  AF       : File;
  AFBuffer : array[1..4096] of Char;
  AFIndex  : Word;

{$R *.DFM}

function Long2Str(L : Longint) : String;
begin
  Str(L , Result);
end;

procedure OpenFile;
  {-Open file and prepare for playback}
begin
  Assign(AF, AnsiFile);
  Reset(AF,1);
  UseFile := True;
  AFIndex := SizeOf(AFBuffer)+1;
  if IoResult <> 0 then
    Halt;
end;

function ReadNextChar(var C : Char) : Boolean;
  {-Return next character from AF}
const
  BytesRead : Word = 0;
begin
  ReadNextChar := False;
  if AFIndex > BytesRead then begin
    BlockRead(AF, AFBuffer, SizeOf(AFBuffer), BytesRead);
    if (IoResult <> 0) or (BytesRead = 0) then
      Exit;
    AFIndex := 1;
  end;
  C := AFBuffer[AFIndex];
  Inc(AFIndex);
  ReadNextChar := True;
end;

procedure TMainForm.AppIdle(Sender: TObject; var Done: Boolean);
const
  PaintInterval = 200;
  CharCount : Word = 0;
var
  C : Char;
begin
  Done := True;
  if UseFile then
    repeat
      {Get next char from file}
      if ReadNextChar(C) then begin
        Terminal1.StuffChar(C);
        Inc(CharCount);
        if CharCount > PaintInterval then begin
          Terminal1.ForcePaint;
          CharCount := 0;
          Exit;
        end else begin
          Done := False;
          Exit;
        end;
      end else begin
        Terminal1.ForcePaint;
        CloseFile(AF);
        UseFile := False;
        Exit;
      end;
    until False;
end;

procedure TMainForm.UpdateComInfo(Term : TTerminal);
  {-Update the comport information}
var
  S : String;
begin
  {Name}
  S := ' ' + ComName(Term.ComPort.ComNumber) + ' ';

  {Line params}
  S := S + Long2Str(Term.ComPort.Databits);
  S := S + ParityName[Term.ComPort.Parity, 1];
  S := S + Long2Str(Term.ComPort.Stopbits) + ' ';

  {Baud}
  S := S + Long2Str(Term.ComPort.Baud);

  StatusLine.Sections[0] := S;
end;

procedure TMainForm.Terminal1TerminalStatus(CP: TObject; Row, Col: Byte;
                                         BufRow, BufCol: Word);
begin
  {Update rows/columns}
  StatusLine.Sections[1] := Format('%2d %2d', [Row, Col]);
  StatusLine.Sections[2] := Format('%2d %2d', [BufRow, BufCol]);
  StatusLine.Sections[3] := '';

  {Set widths}
  StatusLine.SectionWidth[0] := 135;
  StatusLine.SectionWidth[1] := 45;
  StatusLine.SectionWidth[2] := 55;
end;

procedure TMainForm.P1Click(Sender: TObject);
begin
  if OpenDialog1.Execute then begin
    {Open file and prepare to read}
    AnsiFile := OpenDialog1.FileName;
    OpenFile;
  end;
end;

procedure TMainForm.ComPort1PortChange(CP: TObject);
begin
  {Update the cominfo portion of the status line}
  UpdateComInfo(Terminal1);
end;

procedure TMainForm.FormActivate(Sender: TObject);
begin
  UpdateComInfo(Terminal1);
end;

procedure TMainForm.FormCreate(Sender: TObject);
begin
  Application.OnIdle := AppIdle;
end;

procedure TMainForm.C2Click(Sender: TObject);
begin
  Terminal1.ClearBuffer;
end;

procedure TMainForm.E2Click(Sender: TObject);
begin
  Close;
end;

procedure TMainForm.C3Click(Sender: TObject);
begin
  Terminal1.CopyToClipboard;
end;

procedure TMainForm.S1Click(Sender: TObject);
begin
  if Assigned(ComPort1) then
    ComPortOptions.ComPort := ComPort1;

  if ComPortOptions.Execute then begin
    ComPort1.Open := False;
    ComPort1.Assign(ComPortOptions.ComPort);
    ComPort1.Open := True;
  end;

  {Give focus back to terminal window}
  Terminal1.SetFocus;
end;

procedure TMainForm.F2Click(Sender: TObject);
begin
  FontDialog1.Font := Terminal1.Font;
  if FontDialog1.Execute then
    Terminal1.Font := FontDialog1.Font;
end;

procedure TMainForm.FormKeyDown(Sender: TObject; var Key: Word;
                                Shift: TShiftState);
begin
  if Key = VK_INSERT then
    Terminal1.Scrollback := not Terminal1.Scrollback;
end;

end.
