{$G+,X+,F+}

{Conditional defines that may affect this unit}
{$I AWDEFINE.INC}

{*********************************************************}
{*                   TAGFRM.PAS 1.00                     *}
{*        Copyright (c) TurboPower Software 1995         *}
{*                 All rights reserved.                  *}
{*********************************************************}

unit Tagfrm;

interface

uses WinTypes, WinProcs, Classes, Graphics, Forms, Controls, Buttons,
  StdCtrls, OoMisc, AdMisc, AdModDB;

type
  TTagForm = class(TForm)
    OKBtn: TBitBtn;
    CancelBtn: TBitBtn;
    HelpBtn: TBitBtn;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    Tag1Edit: TEdit;
    Tag2Edit: TEdit;
    Tag3Edit: TEdit;
    Tag4Edit: TEdit;
    Tag5Edit: TEdit;
    GroupBox1: TGroupBox;
    procedure OKBtnClick(Sender: TObject);
  public
    EditData : PTagArray;
    EditNum  : ^Word;
    constructor Create(AOwner : TComponent; var Data : TTagArray; var NumTags : Word);
  end;

var
  TagForm: TTagForm;

implementation

{$R *.DFM}

constructor TTagForm.Create(AOwner : TComponent; var Data : TTagArray; var NumTags : Word);
begin
  inherited Create(AOwner);

  EditData := @Data;
  EditNum := @NumTags;

  {set initial values}
  Tag1Edit.Text := EditData^[1];
  Tag2Edit.Text := EditData^[2];
  Tag3Edit.Text := EditData^[3];
  Tag4Edit.Text := EditData^[4];
  Tag5Edit.Text := EditData^[5];
end;

procedure TTagForm.OKBtnClick(Sender: TObject);
var
  I    : Byte;
  OT   : Byte;
  Temp : TTagArray;

begin
  {put strings in array}
  EditData^[1] := Tag1Edit.Text;
  EditData^[2] := Tag2Edit.Text;
  EditData^[3] := Tag3Edit.Text;
  EditData^[4] := Tag4Edit.Text;
  EditData^[5] := Tag5Edit.Text;

  {remove blank strings between tags}
  FillChar(Temp, SizeOf(Temp), 0);
  OT := 0;
  for I := 1 to MaxTags do
    if (EditData^[I] <> '') then begin
      Inc(OT);
      Temp[OT] := EditData^[I];
    end;
  EditData^ := Temp;
  EditNum^ := OT;
  ModalResult := mrOK;
end;

end.
