unit Dialparm;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, Buttons, AdMisc, TComIni;

type
  TDialerParametersForm = class(TForm)
    GroupBox1: TGroupBox;
    GroupBox2: TGroupBox;
    Label1: TLabel;
    Label2: TLabel;
    MaximumRetriesEdit: TEdit;
    TimeBetweenRetriesEdit: TEdit;
    AbortOnVoiceBox: TCheckBox;
    AbortOnBusyBox: TCheckBox;
    AbortOnNoCarrierBox: TCheckBox;
    AbortOnNoDialtoneBox: TCheckBox;
    AbortOnErrorBox: TCheckBox;
    OkBtn: TBitBtn;
    CancelBtn: TBitBtn;
    HelpBtn: TBitBtn;
    procedure OkBtnClick(Sender: TObject);

  public
    constructor Create(AOwner : TComponent); override;
  end;

implementation

{$R *.DFM}

constructor TDialerParametersForm.Create(AOwner : TComponent);
begin
  inherited Create(AOwner);

  {set default values}
  MaximumRetriesEdit.Text     := IntToStr(MaxDialTries);
  TimeBetweenRetriesEdit.Text := IntToStr(RetryTime);

  AbortOnVoiceBox.Checked := mdAbortOnVoice in DialerOpts;
  AbortOnBusyBox.Checked := mdAbortOnBusy in DialerOpts;
  AbortOnNoCarrierBox.Checked := mdAbortOnNoCarrier in DialerOpts;
  AbortOnNoDialtoneBox.Checked := mdAbortOnNoDialtone in DialerOpts;
  AbortOnErrorBox.Checked := mdAbortOnError in DialerOpts;
end;

procedure TDialerParametersForm.OkBtnClick(Sender: TObject);
var
  E    : Integer;
  Temp : Integer;

begin
  Val(MaximumRetriesEdit.Text, Temp, E);
  if (E = 0) then
    MaxDialTries := Temp;
  Val(TimeBetweenRetriesEdit.Text, Temp, E);
  if (E = 0) then
    RetryTime := Temp;

  DialerOpts := [];
  if AbortOnVoiceBox.Checked then
    DialerOpts := DialerOpts + [mdAbortOnVoice];
  if AbortOnBusyBox.Checked then
    DialerOpts := DialerOpts + [mdAbortOnBusy];
  if AbortOnNoCarrierBox.Checked then
    DialerOpts := DialerOpts + [mdAbortOnNoCarrier];
  if AbortOnNoDialtoneBox.Checked then
    DialerOpts := DialerOpts + [mdAbortOnNoDialtone];
  if AbortOnErrorBox.Checked then
    DialerOpts := DialerOpts + [mdAbortOnError];
end;

end.

